// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package servicecatalog

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type DescribeTagOptionInput struct {
	_ struct{} `type:"structure"`

	// The TagOption identifier.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s DescribeTagOptionInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DescribeTagOptionInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "DescribeTagOptionInput"}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type DescribeTagOptionOutput struct {
	_ struct{} `type:"structure"`

	// Information about the TagOption.
	TagOptionDetail *TagOptionDetail `type:"structure"`
}

// String returns the string representation
func (s DescribeTagOptionOutput) String() string {
	return awsutil.Prettify(s)
}

const opDescribeTagOption = "DescribeTagOption"

// DescribeTagOptionRequest returns a request value for making API operation for
// AWS Service Catalog.
//
// Gets information about the specified TagOption.
//
//    // Example sending a request using DescribeTagOptionRequest.
//    req := client.DescribeTagOptionRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/servicecatalog-2015-12-10/DescribeTagOption
func (c *Client) DescribeTagOptionRequest(input *DescribeTagOptionInput) DescribeTagOptionRequest {
	op := &aws.Operation{
		Name:       opDescribeTagOption,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &DescribeTagOptionInput{}
	}

	req := c.newRequest(op, input, &DescribeTagOptionOutput{})

	return DescribeTagOptionRequest{Request: req, Input: input, Copy: c.DescribeTagOptionRequest}
}

// DescribeTagOptionRequest is the request type for the
// DescribeTagOption API operation.
type DescribeTagOptionRequest struct {
	*aws.Request
	Input *DescribeTagOptionInput
	Copy  func(*DescribeTagOptionInput) DescribeTagOptionRequest
}

// Send marshals and sends the DescribeTagOption API request.
func (r DescribeTagOptionRequest) Send(ctx context.Context) (*DescribeTagOptionResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &DescribeTagOptionResponse{
		DescribeTagOptionOutput: r.Request.Data.(*DescribeTagOptionOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// DescribeTagOptionResponse is the response type for the
// DescribeTagOption API operation.
type DescribeTagOptionResponse struct {
	*DescribeTagOptionOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// DescribeTagOption request.
func (r *DescribeTagOptionResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
