// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to return the Amazon SES verification status of a list
// of identities. For domain identities, this request also returns the verification
// token. For information about verifying identities with Amazon SES, see the
// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-addresses-and-domains.html).
type GetIdentityVerificationAttributesInput struct {
	_ struct{} `type:"structure"`

	// A list of identities.
	//
	// Identities is a required field
	Identities []string `type:"list" required:"true"`
}

// String returns the string representation
func (s GetIdentityVerificationAttributesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetIdentityVerificationAttributesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetIdentityVerificationAttributesInput"}

	if s.Identities == nil {
		invalidParams.Add(aws.NewErrParamRequired("Identities"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The Amazon SES verification status of a list of identities. For domain identities,
// this response also contains the verification token.
type GetIdentityVerificationAttributesOutput struct {
	_ struct{} `type:"structure"`

	// A map of Identities to IdentityVerificationAttributes objects.
	//
	// VerificationAttributes is a required field
	VerificationAttributes map[string]IdentityVerificationAttributes `type:"map" required:"true"`
}

// String returns the string representation
func (s GetIdentityVerificationAttributesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetIdentityVerificationAttributes = "GetIdentityVerificationAttributes"

// GetIdentityVerificationAttributesRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Given a list of identities (email addresses and/or domains), returns the
// verification status and (for domain identities) the verification token for
// each identity.
//
// The verification status of an email address is "Pending" until the email
// address owner clicks the link within the verification email that Amazon SES
// sent to that address. If the email address owner clicks the link within 24
// hours, the verification status of the email address changes to "Success".
// If the link is not clicked within 24 hours, the verification status changes
// to "Failed." In that case, if you still want to verify the email address,
// you must restart the verification process from the beginning.
//
// For domain identities, the domain's verification status is "Pending" as Amazon
// SES searches for the required TXT record in the DNS settings of the domain.
// When Amazon SES detects the record, the domain's verification status changes
// to "Success". If Amazon SES is unable to detect the record within 72 hours,
// the domain's verification status changes to "Failed." In that case, if you
// still want to verify the domain, you must restart the verification process
// from the beginning.
//
// This operation is throttled at one request per second and can only get verification
// attributes for up to 100 identities at a time.
//
//    // Example sending a request using GetIdentityVerificationAttributesRequest.
//    req := client.GetIdentityVerificationAttributesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/GetIdentityVerificationAttributes
func (c *Client) GetIdentityVerificationAttributesRequest(input *GetIdentityVerificationAttributesInput) GetIdentityVerificationAttributesRequest {
	op := &aws.Operation{
		Name:       opGetIdentityVerificationAttributes,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetIdentityVerificationAttributesInput{}
	}

	req := c.newRequest(op, input, &GetIdentityVerificationAttributesOutput{})

	return GetIdentityVerificationAttributesRequest{Request: req, Input: input, Copy: c.GetIdentityVerificationAttributesRequest}
}

// GetIdentityVerificationAttributesRequest is the request type for the
// GetIdentityVerificationAttributes API operation.
type GetIdentityVerificationAttributesRequest struct {
	*aws.Request
	Input *GetIdentityVerificationAttributesInput
	Copy  func(*GetIdentityVerificationAttributesInput) GetIdentityVerificationAttributesRequest
}

// Send marshals and sends the GetIdentityVerificationAttributes API request.
func (r GetIdentityVerificationAttributesRequest) Send(ctx context.Context) (*GetIdentityVerificationAttributesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetIdentityVerificationAttributesResponse{
		GetIdentityVerificationAttributesOutput: r.Request.Data.(*GetIdentityVerificationAttributesOutput),
		response:                                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetIdentityVerificationAttributesResponse is the response type for the
// GetIdentityVerificationAttributes API operation.
type GetIdentityVerificationAttributesResponse struct {
	*GetIdentityVerificationAttributesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetIdentityVerificationAttributes request.
func (r *GetIdentityVerificationAttributesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
