// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
	"github.com/aws/aws-sdk-go-v2/private/protocol/query"
)

// Represents a request to update an existing custom verification email template.
type UpdateCustomVerificationEmailTemplateInput struct {
	_ struct{} `type:"structure"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is not successfully verified.
	FailureRedirectionURL *string `type:"string"`

	// The email address that the custom verification email is sent from.
	FromEmailAddress *string `type:"string"`

	// The URL that the recipient of the verification email is sent to if his or
	// her address is successfully verified.
	SuccessRedirectionURL *string `type:"string"`

	// The content of the custom verification email. The total size of the email
	// must be less than 10 MB. The message body may contain HTML, with some limitations.
	// For more information, see Custom Verification Email Frequently Asked Questions
	// (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html#custom-verification-emails-faq)
	// in the Amazon SES Developer Guide.
	TemplateContent *string `type:"string"`

	// The name of the custom verification email template that you want to update.
	//
	// TemplateName is a required field
	TemplateName *string `type:"string" required:"true"`

	// The subject line of the custom verification email.
	TemplateSubject *string `type:"string"`
}

// String returns the string representation
func (s UpdateCustomVerificationEmailTemplateInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateCustomVerificationEmailTemplateInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateCustomVerificationEmailTemplateInput"}

	if s.TemplateName == nil {
		invalidParams.Add(aws.NewErrParamRequired("TemplateName"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateCustomVerificationEmailTemplateOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s UpdateCustomVerificationEmailTemplateOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateCustomVerificationEmailTemplate = "UpdateCustomVerificationEmailTemplate"

// UpdateCustomVerificationEmailTemplateRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Updates an existing custom verification email template.
//
// For more information about custom verification email templates, see Using
// Custom Verification Email Templates (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/custom-verification-emails.html)
// in the Amazon SES Developer Guide.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using UpdateCustomVerificationEmailTemplateRequest.
//    req := client.UpdateCustomVerificationEmailTemplateRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/UpdateCustomVerificationEmailTemplate
func (c *Client) UpdateCustomVerificationEmailTemplateRequest(input *UpdateCustomVerificationEmailTemplateInput) UpdateCustomVerificationEmailTemplateRequest {
	op := &aws.Operation{
		Name:       opUpdateCustomVerificationEmailTemplate,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateCustomVerificationEmailTemplateInput{}
	}

	req := c.newRequest(op, input, &UpdateCustomVerificationEmailTemplateOutput{})
	req.Handlers.Unmarshal.Remove(query.UnmarshalHandler)
	req.Handlers.Unmarshal.PushBackNamed(protocol.UnmarshalDiscardBodyHandler)

	return UpdateCustomVerificationEmailTemplateRequest{Request: req, Input: input, Copy: c.UpdateCustomVerificationEmailTemplateRequest}
}

// UpdateCustomVerificationEmailTemplateRequest is the request type for the
// UpdateCustomVerificationEmailTemplate API operation.
type UpdateCustomVerificationEmailTemplateRequest struct {
	*aws.Request
	Input *UpdateCustomVerificationEmailTemplateInput
	Copy  func(*UpdateCustomVerificationEmailTemplateInput) UpdateCustomVerificationEmailTemplateRequest
}

// Send marshals and sends the UpdateCustomVerificationEmailTemplate API request.
func (r UpdateCustomVerificationEmailTemplateRequest) Send(ctx context.Context) (*UpdateCustomVerificationEmailTemplateResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateCustomVerificationEmailTemplateResponse{
		UpdateCustomVerificationEmailTemplateOutput: r.Request.Data.(*UpdateCustomVerificationEmailTemplateOutput),
		response: &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateCustomVerificationEmailTemplateResponse is the response type for the
// UpdateCustomVerificationEmailTemplate API operation.
type UpdateCustomVerificationEmailTemplateResponse struct {
	*UpdateCustomVerificationEmailTemplateOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateCustomVerificationEmailTemplate request.
func (r *UpdateCustomVerificationEmailTemplateResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
