// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ses

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// Represents a request to generate the CNAME records needed to set up Easy
// DKIM with Amazon SES. For more information about setting up Easy DKIM, see
// the Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
type VerifyDomainDkimInput struct {
	_ struct{} `type:"structure"`

	// The name of the domain to be verified for Easy DKIM signing.
	//
	// Domain is a required field
	Domain *string `type:"string" required:"true"`
}

// String returns the string representation
func (s VerifyDomainDkimInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *VerifyDomainDkimInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "VerifyDomainDkimInput"}

	if s.Domain == nil {
		invalidParams.Add(aws.NewErrParamRequired("Domain"))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// Returns CNAME records that you must publish to the DNS server of your domain
// to set up Easy DKIM with Amazon SES.
type VerifyDomainDkimOutput struct {
	_ struct{} `type:"structure"`

	// A set of character strings that represent the domain's identity. If the identity
	// is an email address, the tokens represent the domain of that address.
	//
	// Using these tokens, you need to create DNS CNAME records that point to DKIM
	// public keys that are hosted by Amazon SES. Amazon Web Services eventually
	// detects that you've updated your DNS records. This detection process might
	// take up to 72 hours. After successful detection, Amazon SES is able to DKIM-sign
	// email originating from that domain. (This only applies to domain identities,
	// not email address identities.)
	//
	// For more information about creating DNS records using DKIM tokens, see the
	// Amazon SES Developer Guide (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
	//
	// DkimTokens is a required field
	DkimTokens []string `type:"list" required:"true"`
}

// String returns the string representation
func (s VerifyDomainDkimOutput) String() string {
	return awsutil.Prettify(s)
}

const opVerifyDomainDkim = "VerifyDomainDkim"

// VerifyDomainDkimRequest returns a request value for making API operation for
// Amazon Simple Email Service.
//
// Returns a set of DKIM tokens for a domain identity.
//
// When you execute the VerifyDomainDkim operation, the domain that you specify
// is added to the list of identities that are associated with your account.
// This is true even if you haven't already associated the domain with your
// account by using the VerifyDomainIdentity operation. However, you can't send
// email from the domain until you either successfully verify it (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/verify-domains.html)
// or you successfully set up DKIM for it (https://docs.aws.amazon.com/ses/latest/DeveloperGuide/easy-dkim.html).
//
// You use the tokens that are generated by this operation to create CNAME records.
// When Amazon SES detects that you've added these records to the DNS configuration
// for a domain, you can start sending email from that domain. You can start
// sending email even if you haven't added the TXT record provided by the VerifyDomainIdentity
// operation to the DNS configuration for your domain. All email that you send
// from the domain is authenticated using DKIM.
//
// To create the CNAME records for DKIM authentication, use the following values:
//
//    * Name: token._domainkey.example.com
//
//    * Type: CNAME
//
//    * Value: token.dkim.amazonses.com
//
// In the preceding example, replace token with one of the tokens that are generated
// when you execute this operation. Replace example.com with your domain. Repeat
// this process for each token that's generated by this operation.
//
// You can execute this operation no more than once per second.
//
//    // Example sending a request using VerifyDomainDkimRequest.
//    req := client.VerifyDomainDkimRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/email-2010-12-01/VerifyDomainDkim
func (c *Client) VerifyDomainDkimRequest(input *VerifyDomainDkimInput) VerifyDomainDkimRequest {
	op := &aws.Operation{
		Name:       opVerifyDomainDkim,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &VerifyDomainDkimInput{}
	}

	req := c.newRequest(op, input, &VerifyDomainDkimOutput{})

	return VerifyDomainDkimRequest{Request: req, Input: input, Copy: c.VerifyDomainDkimRequest}
}

// VerifyDomainDkimRequest is the request type for the
// VerifyDomainDkim API operation.
type VerifyDomainDkimRequest struct {
	*aws.Request
	Input *VerifyDomainDkimInput
	Copy  func(*VerifyDomainDkimInput) VerifyDomainDkimRequest
}

// Send marshals and sends the VerifyDomainDkim API request.
func (r VerifyDomainDkimRequest) Send(ctx context.Context) (*VerifyDomainDkimResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &VerifyDomainDkimResponse{
		VerifyDomainDkimOutput: r.Request.Data.(*VerifyDomainDkimOutput),
		response:               &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// VerifyDomainDkimResponse is the response type for the
// VerifyDomainDkim API operation.
type VerifyDomainDkimResponse struct {
	*VerifyDomainDkimOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// VerifyDomainDkim request.
func (r *VerifyDomainDkimResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
