// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GenerateChangeSetInput struct {
	_ struct{} `type:"structure"`

	// ID of the application associated with the change set.
	AppId *string `locationName:"appId" type:"string"`

	// Format for the change set.
	ChangesetFormat OutputFormat `locationName:"changesetFormat" type:"string" enum:"true"`
}

// String returns the string representation
func (s GenerateChangeSetInput) String() string {
	return awsutil.Prettify(s)
}

type GenerateChangeSetOutput struct {
	_ struct{} `type:"structure"`

	// Location of the Amazon S3 object.
	S3Location *S3Location `locationName:"s3Location" type:"structure"`
}

// String returns the string representation
func (s GenerateChangeSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opGenerateChangeSet = "GenerateChangeSet"

// GenerateChangeSetRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Generates a target change set for a currently launched stack and writes it
// to an Amazon S3 object in the customer’s Amazon S3 bucket.
//
//    // Example sending a request using GenerateChangeSetRequest.
//    req := client.GenerateChangeSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GenerateChangeSet
func (c *Client) GenerateChangeSetRequest(input *GenerateChangeSetInput) GenerateChangeSetRequest {
	op := &aws.Operation{
		Name:       opGenerateChangeSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GenerateChangeSetInput{}
	}

	req := c.newRequest(op, input, &GenerateChangeSetOutput{})

	return GenerateChangeSetRequest{Request: req, Input: input, Copy: c.GenerateChangeSetRequest}
}

// GenerateChangeSetRequest is the request type for the
// GenerateChangeSet API operation.
type GenerateChangeSetRequest struct {
	*aws.Request
	Input *GenerateChangeSetInput
	Copy  func(*GenerateChangeSetInput) GenerateChangeSetRequest
}

// Send marshals and sends the GenerateChangeSet API request.
func (r GenerateChangeSetRequest) Send(ctx context.Context) (*GenerateChangeSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GenerateChangeSetResponse{
		GenerateChangeSetOutput: r.Request.Data.(*GenerateChangeSetOutput),
		response:                &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GenerateChangeSetResponse is the response type for the
// GenerateChangeSet API operation.
type GenerateChangeSetResponse struct {
	*GenerateChangeSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GenerateChangeSet request.
func (r *GenerateChangeSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
