// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package sms

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetAppLaunchConfigurationInput struct {
	_ struct{} `type:"structure"`

	// ID of the application launch configuration.
	AppId *string `locationName:"appId" type:"string"`
}

// String returns the string representation
func (s GetAppLaunchConfigurationInput) String() string {
	return awsutil.Prettify(s)
}

type GetAppLaunchConfigurationOutput struct {
	_ struct{} `type:"structure"`

	// ID of the application associated with the launch configuration.
	AppId *string `locationName:"appId" type:"string"`

	// Name of the service role in the customer's account that Amazon CloudFormation
	// uses to launch the application.
	RoleName *string `locationName:"roleName" type:"string"`

	// List of launch configurations for server groups in this application.
	ServerGroupLaunchConfigurations []ServerGroupLaunchConfiguration `locationName:"serverGroupLaunchConfigurations" type:"list"`
}

// String returns the string representation
func (s GetAppLaunchConfigurationOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetAppLaunchConfiguration = "GetAppLaunchConfiguration"

// GetAppLaunchConfigurationRequest returns a request value for making API operation for
// AWS Server Migration Service.
//
// Retrieves the application launch configuration associated with an application.
//
//    // Example sending a request using GetAppLaunchConfigurationRequest.
//    req := client.GetAppLaunchConfigurationRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/sms-2016-10-24/GetAppLaunchConfiguration
func (c *Client) GetAppLaunchConfigurationRequest(input *GetAppLaunchConfigurationInput) GetAppLaunchConfigurationRequest {
	op := &aws.Operation{
		Name:       opGetAppLaunchConfiguration,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetAppLaunchConfigurationInput{}
	}

	req := c.newRequest(op, input, &GetAppLaunchConfigurationOutput{})

	return GetAppLaunchConfigurationRequest{Request: req, Input: input, Copy: c.GetAppLaunchConfigurationRequest}
}

// GetAppLaunchConfigurationRequest is the request type for the
// GetAppLaunchConfiguration API operation.
type GetAppLaunchConfigurationRequest struct {
	*aws.Request
	Input *GetAppLaunchConfigurationInput
	Copy  func(*GetAppLaunchConfigurationInput) GetAppLaunchConfigurationRequest
}

// Send marshals and sends the GetAppLaunchConfiguration API request.
func (r GetAppLaunchConfigurationRequest) Send(ctx context.Context) (*GetAppLaunchConfigurationResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetAppLaunchConfigurationResponse{
		GetAppLaunchConfigurationOutput: r.Request.Data.(*GetAppLaunchConfigurationOutput),
		response:                        &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetAppLaunchConfigurationResponse is the response type for the
// GetAppLaunchConfiguration API operation.
type GetAppLaunchConfigurationResponse struct {
	*GetAppLaunchConfigurationOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetAppLaunchConfiguration request.
func (r *GetAppLaunchConfigurationResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
