// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package snowball

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetSoftwareUpdatesInput struct {
	_ struct{} `type:"structure"`

	// The ID for a job that you want to get the software update file for, for example
	// JID123e4567-e89b-12d3-a456-426655440000.
	//
	// JobId is a required field
	JobId *string `min:"39" type:"string" required:"true"`
}

// String returns the string representation
func (s GetSoftwareUpdatesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetSoftwareUpdatesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetSoftwareUpdatesInput"}

	if s.JobId == nil {
		invalidParams.Add(aws.NewErrParamRequired("JobId"))
	}
	if s.JobId != nil && len(*s.JobId) < 39 {
		invalidParams.Add(aws.NewErrParamMinLen("JobId", 39))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetSoftwareUpdatesOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon S3 presigned URL for the update file associated with the specified
	// JobId value. The software update will be available for 2 days after this
	// request is made. To access an update after the 2 days have passed, you'll
	// have to make another call to GetSoftwareUpdates.
	UpdatesURI *string `min:"1" type:"string"`
}

// String returns the string representation
func (s GetSoftwareUpdatesOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetSoftwareUpdates = "GetSoftwareUpdates"

// GetSoftwareUpdatesRequest returns a request value for making API operation for
// Amazon Import/Export Snowball.
//
// Returns an Amazon S3 presigned URL for an update file associated with a specified
// JobId.
//
//    // Example sending a request using GetSoftwareUpdatesRequest.
//    req := client.GetSoftwareUpdatesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/snowball-2016-06-30/GetSoftwareUpdates
func (c *Client) GetSoftwareUpdatesRequest(input *GetSoftwareUpdatesInput) GetSoftwareUpdatesRequest {
	op := &aws.Operation{
		Name:       opGetSoftwareUpdates,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetSoftwareUpdatesInput{}
	}

	req := c.newRequest(op, input, &GetSoftwareUpdatesOutput{})

	return GetSoftwareUpdatesRequest{Request: req, Input: input, Copy: c.GetSoftwareUpdatesRequest}
}

// GetSoftwareUpdatesRequest is the request type for the
// GetSoftwareUpdates API operation.
type GetSoftwareUpdatesRequest struct {
	*aws.Request
	Input *GetSoftwareUpdatesInput
	Copy  func(*GetSoftwareUpdatesInput) GetSoftwareUpdatesRequest
}

// Send marshals and sends the GetSoftwareUpdates API request.
func (r GetSoftwareUpdatesRequest) Send(ctx context.Context) (*GetSoftwareUpdatesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetSoftwareUpdatesResponse{
		GetSoftwareUpdatesOutput: r.Request.Data.(*GetSoftwareUpdatesOutput),
		response:                 &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetSoftwareUpdatesResponse is the response type for the
// GetSoftwareUpdates API operation.
type GetSoftwareUpdatesResponse struct {
	*GetSoftwareUpdatesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetSoftwareUpdates request.
func (r *GetSoftwareUpdatesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
