// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package ssm

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListComplianceSummariesInput struct {
	_ struct{} `type:"structure"`

	// One or more compliance or inventory filters. Use a filter to return a more
	// specific list of results.
	Filters []ComplianceStringFilter `type:"list"`

	// The maximum number of items to return for this call. Currently, you can specify
	// null or 50. The call also returns a token that you can specify in a subsequent
	// call to get the next set of results.
	MaxResults *int64 `min:"1" type:"integer"`

	// A token to start the list. Use this token to get the next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListComplianceSummariesInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListComplianceSummariesInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListComplianceSummariesInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}
	if s.Filters != nil {
		for i, v := range s.Filters {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Filters", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListComplianceSummariesOutput struct {
	_ struct{} `type:"structure"`

	// A list of compliant and non-compliant summary counts based on compliance
	// types. For example, this call returns State Manager associations, patches,
	// or custom compliance types according to the filter criteria that you specified.
	ComplianceSummaryItems []ComplianceSummaryItem `type:"list"`

	// The token for the next set of items to return. Use this token to get the
	// next set of results.
	NextToken *string `type:"string"`
}

// String returns the string representation
func (s ListComplianceSummariesOutput) String() string {
	return awsutil.Prettify(s)
}

const opListComplianceSummaries = "ListComplianceSummaries"

// ListComplianceSummariesRequest returns a request value for making API operation for
// Amazon Simple Systems Manager (SSM).
//
// Returns a summary count of compliant and non-compliant resources for a compliance
// type. For example, this call can return State Manager associations, patches,
// or custom compliance types according to the filter criteria that you specify.
//
//    // Example sending a request using ListComplianceSummariesRequest.
//    req := client.ListComplianceSummariesRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/ssm-2014-11-06/ListComplianceSummaries
func (c *Client) ListComplianceSummariesRequest(input *ListComplianceSummariesInput) ListComplianceSummariesRequest {
	op := &aws.Operation{
		Name:       opListComplianceSummaries,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &ListComplianceSummariesInput{}
	}

	req := c.newRequest(op, input, &ListComplianceSummariesOutput{})

	return ListComplianceSummariesRequest{Request: req, Input: input, Copy: c.ListComplianceSummariesRequest}
}

// ListComplianceSummariesRequest is the request type for the
// ListComplianceSummaries API operation.
type ListComplianceSummariesRequest struct {
	*aws.Request
	Input *ListComplianceSummariesInput
	Copy  func(*ListComplianceSummariesInput) ListComplianceSummariesRequest
}

// Send marshals and sends the ListComplianceSummaries API request.
func (r ListComplianceSummariesRequest) Send(ctx context.Context) (*ListComplianceSummariesResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListComplianceSummariesResponse{
		ListComplianceSummariesOutput: r.Request.Data.(*ListComplianceSummariesOutput),
		response:                      &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// ListComplianceSummariesResponse is the response type for the
// ListComplianceSummaries API operation.
type ListComplianceSummariesResponse struct {
	*ListComplianceSummariesOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListComplianceSummaries request.
func (r *ListComplianceSummariesResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
