// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package synthetics

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type StartCanaryInput struct {
	_ struct{} `type:"structure"`

	// The name of the canary that you want to run. To find canary names, use DescribeCanaries
	// (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_DescribeCanaries.html).
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"name" min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s StartCanaryInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *StartCanaryInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "StartCanaryInput"}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartCanaryInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.PathTarget, "name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type StartCanaryOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation
func (s StartCanaryOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s StartCanaryOutput) MarshalFields(e protocol.FieldEncoder) error {
	return nil
}

const opStartCanary = "StartCanary"

// StartCanaryRequest returns a request value for making API operation for
// Synthetics.
//
// Use this operation to run a canary that has already been created. The frequency
// of the canary runs is determined by the value of the canary's Schedule. To
// see a canary's schedule, use GetCanary (https://docs.aws.amazon.com/AmazonSynthetics/latest/APIReference/API_GetCanary.html).
//
//    // Example sending a request using StartCanaryRequest.
//    req := client.StartCanaryRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/synthetics-2017-10-11/StartCanary
func (c *Client) StartCanaryRequest(input *StartCanaryInput) StartCanaryRequest {
	op := &aws.Operation{
		Name:       opStartCanary,
		HTTPMethod: "POST",
		HTTPPath:   "/canary/{name}/start",
	}

	if input == nil {
		input = &StartCanaryInput{}
	}

	req := c.newRequest(op, input, &StartCanaryOutput{})

	return StartCanaryRequest{Request: req, Input: input, Copy: c.StartCanaryRequest}
}

// StartCanaryRequest is the request type for the
// StartCanary API operation.
type StartCanaryRequest struct {
	*aws.Request
	Input *StartCanaryInput
	Copy  func(*StartCanaryInput) StartCanaryRequest
}

// Send marshals and sends the StartCanary API request.
func (r StartCanaryRequest) Send(ctx context.Context) (*StartCanaryResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &StartCanaryResponse{
		StartCanaryOutput: r.Request.Data.(*StartCanaryOutput),
		response:          &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// StartCanaryResponse is the response type for the
// StartCanary API operation.
type StartCanaryResponse struct {
	*StartCanaryOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// StartCanary request.
func (r *StartCanaryResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
