// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package transcribe

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type ListMedicalTranscriptionJobsInput struct {
	_ struct{} `type:"structure"`

	// When specified, the jobs returned in the list are limited to jobs whose name
	// contains the specified string.
	JobNameContains *string `min:"1" type:"string"`

	// The maximum number of medical transcription jobs to return in the response.
	// IF there are fewer results in the list, this response contains only the actual
	// results.
	MaxResults *int64 `min:"1" type:"integer"`

	// If you a receive a truncated result in the previous request of ListMedicalTranscriptionJobs,
	// include NextToken to fetch the next set of jobs.
	NextToken *string `type:"string"`

	// When specified, returns only medical transcription jobs with the specified
	// status. Jobs are ordered by creation date, with the newest jobs returned
	// first. If you don't specify a status, Amazon Transcribe Medical returns all
	// transcription jobs ordered by creation date.
	Status TranscriptionJobStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListMedicalTranscriptionJobsInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListMedicalTranscriptionJobsInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "ListMedicalTranscriptionJobsInput"}
	if s.JobNameContains != nil && len(*s.JobNameContains) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("JobNameContains", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(aws.NewErrParamMinValue("MaxResults", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type ListMedicalTranscriptionJobsOutput struct {
	_ struct{} `type:"structure"`

	// A list of objects containing summary information for a transcription job.
	MedicalTranscriptionJobSummaries []MedicalTranscriptionJobSummary `type:"list"`

	// The ListMedicalTranscriptionJobs operation returns a page of jobs at a time.
	// The maximum size of the page is set by the MaxResults parameter. If the number
	// of jobs exceeds what can fit on a page, Amazon Transcribe Medical returns
	// the NextPage token. Include the token in the next request to the ListMedicalTranscriptionJobs
	// operation to return in the next page of jobs.
	NextToken *string `type:"string"`

	// The requested status of the medical transcription jobs returned.
	Status TranscriptionJobStatus `type:"string" enum:"true"`
}

// String returns the string representation
func (s ListMedicalTranscriptionJobsOutput) String() string {
	return awsutil.Prettify(s)
}

const opListMedicalTranscriptionJobs = "ListMedicalTranscriptionJobs"

// ListMedicalTranscriptionJobsRequest returns a request value for making API operation for
// Amazon Transcribe Service.
//
// Lists medical transcription jobs with a specified status or substring that
// matches their names.
//
//    // Example sending a request using ListMedicalTranscriptionJobsRequest.
//    req := client.ListMedicalTranscriptionJobsRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/transcribe-2017-10-26/ListMedicalTranscriptionJobs
func (c *Client) ListMedicalTranscriptionJobsRequest(input *ListMedicalTranscriptionJobsInput) ListMedicalTranscriptionJobsRequest {
	op := &aws.Operation{
		Name:       opListMedicalTranscriptionJobs,
		HTTPMethod: "POST",
		HTTPPath:   "/",
		Paginator: &aws.Paginator{
			InputTokens:     []string{"NextToken"},
			OutputTokens:    []string{"NextToken"},
			LimitToken:      "MaxResults",
			TruncationToken: "",
		},
	}

	if input == nil {
		input = &ListMedicalTranscriptionJobsInput{}
	}

	req := c.newRequest(op, input, &ListMedicalTranscriptionJobsOutput{})

	return ListMedicalTranscriptionJobsRequest{Request: req, Input: input, Copy: c.ListMedicalTranscriptionJobsRequest}
}

// ListMedicalTranscriptionJobsRequest is the request type for the
// ListMedicalTranscriptionJobs API operation.
type ListMedicalTranscriptionJobsRequest struct {
	*aws.Request
	Input *ListMedicalTranscriptionJobsInput
	Copy  func(*ListMedicalTranscriptionJobsInput) ListMedicalTranscriptionJobsRequest
}

// Send marshals and sends the ListMedicalTranscriptionJobs API request.
func (r ListMedicalTranscriptionJobsRequest) Send(ctx context.Context) (*ListMedicalTranscriptionJobsResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &ListMedicalTranscriptionJobsResponse{
		ListMedicalTranscriptionJobsOutput: r.Request.Data.(*ListMedicalTranscriptionJobsOutput),
		response:                           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// NewListMedicalTranscriptionJobsRequestPaginator returns a paginator for ListMedicalTranscriptionJobs.
// Use Next method to get the next page, and CurrentPage to get the current
// response page from the paginator. Next will return false, if there are
// no more pages, or an error was encountered.
//
// Note: This operation can generate multiple requests to a service.
//
//   // Example iterating over pages.
//   req := client.ListMedicalTranscriptionJobsRequest(input)
//   p := transcribe.NewListMedicalTranscriptionJobsRequestPaginator(req)
//
//   for p.Next(context.TODO()) {
//       page := p.CurrentPage()
//   }
//
//   if err := p.Err(); err != nil {
//       return err
//   }
//
func NewListMedicalTranscriptionJobsPaginator(req ListMedicalTranscriptionJobsRequest) ListMedicalTranscriptionJobsPaginator {
	return ListMedicalTranscriptionJobsPaginator{
		Pager: aws.Pager{
			NewRequest: func(ctx context.Context) (*aws.Request, error) {
				var inCpy *ListMedicalTranscriptionJobsInput
				if req.Input != nil {
					tmp := *req.Input
					inCpy = &tmp
				}

				newReq := req.Copy(inCpy)
				newReq.SetContext(ctx)
				return newReq.Request, nil
			},
		},
	}
}

// ListMedicalTranscriptionJobsPaginator is used to paginate the request. This can be done by
// calling Next and CurrentPage.
type ListMedicalTranscriptionJobsPaginator struct {
	aws.Pager
}

func (p *ListMedicalTranscriptionJobsPaginator) CurrentPage() *ListMedicalTranscriptionJobsOutput {
	return p.Pager.CurrentPage().(*ListMedicalTranscriptionJobsOutput)
}

// ListMedicalTranscriptionJobsResponse is the response type for the
// ListMedicalTranscriptionJobs API operation.
type ListMedicalTranscriptionJobsResponse struct {
	*ListMedicalTranscriptionJobsOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// ListMedicalTranscriptionJobs request.
func (r *ListMedicalTranscriptionJobsResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
