// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package waf

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A request to get an XssMatchSet.
type GetXssMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The XssMatchSetId of the XssMatchSet that you want to get. XssMatchSetId
	// is returned by CreateXssMatchSet and by ListXssMatchSets.
	//
	// XssMatchSetId is a required field
	XssMatchSetId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s GetXssMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetXssMatchSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetXssMatchSetInput"}

	if s.XssMatchSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("XssMatchSetId"))
	}
	if s.XssMatchSetId != nil && len(*s.XssMatchSetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("XssMatchSetId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response to a GetXssMatchSet request.
type GetXssMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// Information about the XssMatchSet that you specified in the GetXssMatchSet
	// request. For more information, see the following topics:
	//
	//    * XssMatchSet: Contains Name, XssMatchSetId, and an array of XssMatchTuple
	//    objects
	//
	//    * XssMatchTuple: Each XssMatchTuple object contains FieldToMatch and TextTransformation
	//
	//    * FieldToMatch: Contains Data and Type
	XssMatchSet *XssMatchSet `type:"structure"`
}

// String returns the string representation
func (s GetXssMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetXssMatchSet = "GetXssMatchSet"

// GetXssMatchSetRequest returns a request value for making API operation for
// AWS WAF.
//
//
// This is AWS WAF Classic documentation. For more information, see AWS WAF
// Classic (https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
// in the developer guide.
//
// For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
// WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
// With the latest version, AWS WAF has a single set of endpoints for regional
// and global use.
//
// Returns the XssMatchSet that is specified by XssMatchSetId.
//
//    // Example sending a request using GetXssMatchSetRequest.
//    req := client.GetXssMatchSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-2015-08-24/GetXssMatchSet
func (c *Client) GetXssMatchSetRequest(input *GetXssMatchSetInput) GetXssMatchSetRequest {
	op := &aws.Operation{
		Name:       opGetXssMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetXssMatchSetInput{}
	}

	req := c.newRequest(op, input, &GetXssMatchSetOutput{})

	return GetXssMatchSetRequest{Request: req, Input: input, Copy: c.GetXssMatchSetRequest}
}

// GetXssMatchSetRequest is the request type for the
// GetXssMatchSet API operation.
type GetXssMatchSetRequest struct {
	*aws.Request
	Input *GetXssMatchSetInput
	Copy  func(*GetXssMatchSetInput) GetXssMatchSetRequest
}

// Send marshals and sends the GetXssMatchSet API request.
func (r GetXssMatchSetRequest) Send(ctx context.Context) (*GetXssMatchSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetXssMatchSetResponse{
		GetXssMatchSetOutput: r.Request.Data.(*GetXssMatchSetOutput),
		response:             &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetXssMatchSetResponse is the response type for the
// GetXssMatchSet API operation.
type GetXssMatchSetResponse struct {
	*GetXssMatchSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetXssMatchSet request.
func (r *GetXssMatchSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
