// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafregional

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

// A request to update a SqlInjectionMatchSet.
type UpdateSqlInjectionMatchSetInput struct {
	_ struct{} `type:"structure"`

	// The value returned by the most recent call to GetChangeToken.
	//
	// ChangeToken is a required field
	ChangeToken *string `min:"1" type:"string" required:"true"`

	// The SqlInjectionMatchSetId of the SqlInjectionMatchSet that you want to update.
	// SqlInjectionMatchSetId is returned by CreateSqlInjectionMatchSet and by ListSqlInjectionMatchSets.
	//
	// SqlInjectionMatchSetId is a required field
	SqlInjectionMatchSetId *string `min:"1" type:"string" required:"true"`

	// An array of SqlInjectionMatchSetUpdate objects that you want to insert into
	// or delete from a SqlInjectionMatchSet. For more information, see the applicable
	// data types:
	//
	//    * SqlInjectionMatchSetUpdate: Contains Action and SqlInjectionMatchTuple
	//
	//    * SqlInjectionMatchTuple: Contains FieldToMatch and TextTransformation
	//
	//    * FieldToMatch: Contains Data and Type
	//
	// Updates is a required field
	Updates []SqlInjectionMatchSetUpdate `min:"1" type:"list" required:"true"`
}

// String returns the string representation
func (s UpdateSqlInjectionMatchSetInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateSqlInjectionMatchSetInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateSqlInjectionMatchSetInput"}

	if s.ChangeToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("ChangeToken"))
	}
	if s.ChangeToken != nil && len(*s.ChangeToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ChangeToken", 1))
	}

	if s.SqlInjectionMatchSetId == nil {
		invalidParams.Add(aws.NewErrParamRequired("SqlInjectionMatchSetId"))
	}
	if s.SqlInjectionMatchSetId != nil && len(*s.SqlInjectionMatchSetId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("SqlInjectionMatchSetId", 1))
	}

	if s.Updates == nil {
		invalidParams.Add(aws.NewErrParamRequired("Updates"))
	}
	if s.Updates != nil && len(s.Updates) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Updates", 1))
	}
	if s.Updates != nil {
		for i, v := range s.Updates {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Updates", i), err.(aws.ErrInvalidParams))
			}
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// The response to an UpdateSqlInjectionMatchSets request.
type UpdateSqlInjectionMatchSetOutput struct {
	_ struct{} `type:"structure"`

	// The ChangeToken that you used to submit the UpdateSqlInjectionMatchSet request.
	// You can also use this value to query the status of the request. For more
	// information, see GetChangeTokenStatus.
	ChangeToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateSqlInjectionMatchSetOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateSqlInjectionMatchSet = "UpdateSqlInjectionMatchSet"

// UpdateSqlInjectionMatchSetRequest returns a request value for making API operation for
// AWS WAF Regional.
//
//
// This is AWS WAF Classic documentation. For more information, see AWS WAF
// Classic (https://docs.aws.amazon.com/waf/latest/developerguide/classic-waf-chapter.html)
// in the developer guide.
//
// For the latest version of AWS WAF, use the AWS WAFV2 API and see the AWS
// WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
// With the latest version, AWS WAF has a single set of endpoints for regional
// and global use.
//
// Inserts or deletes SqlInjectionMatchTuple objects (filters) in a SqlInjectionMatchSet.
// For each SqlInjectionMatchTuple object, you specify the following values:
//
//    * Action: Whether to insert the object into or delete the object from
//    the array. To change a SqlInjectionMatchTuple, you delete the existing
//    object and add a new one.
//
//    * FieldToMatch: The part of web requests that you want AWS WAF to inspect
//    and, if you want AWS WAF to inspect a header or custom query parameter,
//    the name of the header or parameter.
//
//    * TextTransformation: Which text transformation, if any, to perform on
//    the web request before inspecting the request for snippets of malicious
//    SQL code. You can only specify a single type of TextTransformation.
//
// You use SqlInjectionMatchSet objects to specify which CloudFront requests
// that you want to allow, block, or count. For example, if you're receiving
// requests that contain snippets of SQL code in the query string and you want
// to block the requests, you can create a SqlInjectionMatchSet with the applicable
// settings, and then configure AWS WAF to block the requests.
//
// To create and configure a SqlInjectionMatchSet, perform the following steps:
//
// Submit a CreateSqlInjectionMatchSet request.
//
// Use GetChangeToken to get the change token that you provide in the ChangeToken
// parameter of an UpdateIPSet request.
//
// Submit an UpdateSqlInjectionMatchSet request to specify the parts of web
// requests that you want AWS WAF to inspect for snippets of SQL code.
//
// For more information about how to use the AWS WAF API to allow or block HTTP
// requests, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/).
//
//    // Example sending a request using UpdateSqlInjectionMatchSetRequest.
//    req := client.UpdateSqlInjectionMatchSetRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/waf-regional-2016-11-28/UpdateSqlInjectionMatchSet
func (c *Client) UpdateSqlInjectionMatchSetRequest(input *UpdateSqlInjectionMatchSetInput) UpdateSqlInjectionMatchSetRequest {
	op := &aws.Operation{
		Name:       opUpdateSqlInjectionMatchSet,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateSqlInjectionMatchSetInput{}
	}

	req := c.newRequest(op, input, &UpdateSqlInjectionMatchSetOutput{})

	return UpdateSqlInjectionMatchSetRequest{Request: req, Input: input, Copy: c.UpdateSqlInjectionMatchSetRequest}
}

// UpdateSqlInjectionMatchSetRequest is the request type for the
// UpdateSqlInjectionMatchSet API operation.
type UpdateSqlInjectionMatchSetRequest struct {
	*aws.Request
	Input *UpdateSqlInjectionMatchSetInput
	Copy  func(*UpdateSqlInjectionMatchSetInput) UpdateSqlInjectionMatchSetRequest
}

// Send marshals and sends the UpdateSqlInjectionMatchSet API request.
func (r UpdateSqlInjectionMatchSetRequest) Send(ctx context.Context) (*UpdateSqlInjectionMatchSetResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateSqlInjectionMatchSetResponse{
		UpdateSqlInjectionMatchSetOutput: r.Request.Data.(*UpdateSqlInjectionMatchSetOutput),
		response:                         &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateSqlInjectionMatchSetResponse is the response type for the
// UpdateSqlInjectionMatchSet API operation.
type UpdateSqlInjectionMatchSetResponse struct {
	*UpdateSqlInjectionMatchSetOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateSqlInjectionMatchSet request.
func (r *UpdateSqlInjectionMatchSetResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
