// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafv2

import (
	"context"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type GetWebACLForResourceInput struct {
	_ struct{} `type:"structure"`

	// The ARN (Amazon Resource Name) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `min:"20" type:"string" required:"true"`
}

// String returns the string representation
func (s GetWebACLForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetWebACLForResourceInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "GetWebACLForResourceInput"}

	if s.ResourceArn == nil {
		invalidParams.Add(aws.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 20 {
		invalidParams.Add(aws.NewErrParamMinLen("ResourceArn", 20))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type GetWebACLForResourceOutput struct {
	_ struct{} `type:"structure"`

	// The Web ACL that is associated with the resource. If there is no associated
	// resource, AWS WAF returns a null Web ACL.
	WebACL *WebACL `type:"structure"`
}

// String returns the string representation
func (s GetWebACLForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

const opGetWebACLForResource = "GetWebACLForResource"

// GetWebACLForResourceRequest returns a request value for making API operation for
// AWS WAFV2.
//
//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Retrieves the WebACL for the specified resource.
//
//    // Example sending a request using GetWebACLForResourceRequest.
//    req := client.GetWebACLForResourceRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/GetWebACLForResource
func (c *Client) GetWebACLForResourceRequest(input *GetWebACLForResourceInput) GetWebACLForResourceRequest {
	op := &aws.Operation{
		Name:       opGetWebACLForResource,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &GetWebACLForResourceInput{}
	}

	req := c.newRequest(op, input, &GetWebACLForResourceOutput{})

	return GetWebACLForResourceRequest{Request: req, Input: input, Copy: c.GetWebACLForResourceRequest}
}

// GetWebACLForResourceRequest is the request type for the
// GetWebACLForResource API operation.
type GetWebACLForResourceRequest struct {
	*aws.Request
	Input *GetWebACLForResourceInput
	Copy  func(*GetWebACLForResourceInput) GetWebACLForResourceRequest
}

// Send marshals and sends the GetWebACLForResource API request.
func (r GetWebACLForResourceRequest) Send(ctx context.Context) (*GetWebACLForResourceResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &GetWebACLForResourceResponse{
		GetWebACLForResourceOutput: r.Request.Data.(*GetWebACLForResourceOutput),
		response:                   &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// GetWebACLForResourceResponse is the response type for the
// GetWebACLForResource API operation.
type GetWebACLForResourceResponse struct {
	*GetWebACLForResourceOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// GetWebACLForResource request.
func (r *GetWebACLForResourceResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
