// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package wafv2

import (
	"context"
	"fmt"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
)

type UpdateWebACLInput struct {
	_ struct{} `type:"structure"`

	// The action to perform if none of the Rules contained in the WebACL match.
	//
	// DefaultAction is a required field
	DefaultAction *DefaultAction `type:"structure" required:"true"`

	// A description of the Web ACL that helps with identification. You cannot change
	// the description of a Web ACL after you create it.
	Description *string `min:"1" type:"string"`

	// The unique identifier for the Web ACL. This ID is returned in the responses
	// to create and list commands. You provide it to operations like update and
	// delete.
	//
	// Id is a required field
	Id *string `min:"1" type:"string" required:"true"`

	// A token used for optimistic locking. AWS WAF returns a token to your get
	// and list requests, to mark the state of the entity at the time of the request.
	// To make changes to the entity associated with the token, you provide the
	// token to operations like update and delete. AWS WAF uses the token to ensure
	// that no changes have been made to the entity since you last retrieved it.
	// If a change has been made, the update fails with a WAFOptimisticLockException.
	// If this happens, perform another get, and use the new token returned by that
	// operation.
	//
	// LockToken is a required field
	LockToken *string `min:"1" type:"string" required:"true"`

	// The name of the Web ACL. You cannot change the name of a Web ACL after you
	// create it.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The Rule statements used to identify the web requests that you want to allow,
	// block, or count. Each rule includes one top-level statement that AWS WAF
	// uses to identify matching web requests, and parameters that govern how AWS
	// WAF handles them.
	Rules []Rule `type:"list"`

	// Specifies whether this is for an AWS CloudFront distribution or for a regional
	// application. A regional application can be an Application Load Balancer (ALB)
	// or an API Gateway stage.
	//
	// To work with CloudFront, you must also specify the Region US East (N. Virginia)
	// as follows:
	//
	//    * CLI - Specify the Region when you use the CloudFront scope: --scope=CLOUDFRONT
	//    --region=us-east-1.
	//
	//    * API and SDKs - For all calls, use the Region endpoint us-east-1.
	//
	// Scope is a required field
	Scope Scope `type:"string" required:"true" enum:"true"`

	// Defines and enables Amazon CloudWatch metrics and web request sample collection.
	//
	// VisibilityConfig is a required field
	VisibilityConfig *VisibilityConfig `type:"structure" required:"true"`
}

// String returns the string representation
func (s UpdateWebACLInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateWebACLInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "UpdateWebACLInput"}

	if s.DefaultAction == nil {
		invalidParams.Add(aws.NewErrParamRequired("DefaultAction"))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Description", 1))
	}

	if s.Id == nil {
		invalidParams.Add(aws.NewErrParamRequired("Id"))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}

	if s.LockToken == nil {
		invalidParams.Add(aws.NewErrParamRequired("LockToken"))
	}
	if s.LockToken != nil && len(*s.LockToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("LockToken", 1))
	}

	if s.Name == nil {
		invalidParams.Add(aws.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}
	if len(s.Scope) == 0 {
		invalidParams.Add(aws.NewErrParamRequired("Scope"))
	}

	if s.VisibilityConfig == nil {
		invalidParams.Add(aws.NewErrParamRequired("VisibilityConfig"))
	}
	if s.Rules != nil {
		for i, v := range s.Rules {
			if err := v.Validate(); err != nil {
				invalidParams.AddNested(fmt.Sprintf("%s[%v]", "Rules", i), err.(aws.ErrInvalidParams))
			}
		}
	}
	if s.VisibilityConfig != nil {
		if err := s.VisibilityConfig.Validate(); err != nil {
			invalidParams.AddNested("VisibilityConfig", err.(aws.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

type UpdateWebACLOutput struct {
	_ struct{} `type:"structure"`

	// A token used for optimistic locking. AWS WAF returns this token to your update
	// requests. You use NextLockToken in the same manner as you use LockToken.
	NextLockToken *string `min:"1" type:"string"`
}

// String returns the string representation
func (s UpdateWebACLOutput) String() string {
	return awsutil.Prettify(s)
}

const opUpdateWebACL = "UpdateWebACL"

// UpdateWebACLRequest returns a request value for making API operation for
// AWS WAFV2.
//
//
// This is the latest version of AWS WAF, named AWS WAFV2, released in November,
// 2019. For information, including how to migrate your AWS WAF resources from
// the prior release, see the AWS WAF Developer Guide (https://docs.aws.amazon.com/waf/latest/developerguide/waf-chapter.html).
//
// Updates the specified WebACL.
//
// A Web ACL defines a collection of rules to use to inspect and control web
// requests. Each rule has an action defined (allow, block, or count) for requests
// that match the statement of the rule. In the Web ACL, you assign a default
// action to take (allow, block) for any request that does not match any of
// the rules. The rules in a Web ACL can be a combination of the types Rule,
// RuleGroup, and managed rule group. You can associate a Web ACL with one or
// more AWS resources to protect. The resources can be Amazon CloudFront, an
// Amazon API Gateway API, or an Application Load Balancer.
//
//    // Example sending a request using UpdateWebACLRequest.
//    req := client.UpdateWebACLRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/wafv2-2019-07-29/UpdateWebACL
func (c *Client) UpdateWebACLRequest(input *UpdateWebACLInput) UpdateWebACLRequest {
	op := &aws.Operation{
		Name:       opUpdateWebACL,
		HTTPMethod: "POST",
		HTTPPath:   "/",
	}

	if input == nil {
		input = &UpdateWebACLInput{}
	}

	req := c.newRequest(op, input, &UpdateWebACLOutput{})

	return UpdateWebACLRequest{Request: req, Input: input, Copy: c.UpdateWebACLRequest}
}

// UpdateWebACLRequest is the request type for the
// UpdateWebACL API operation.
type UpdateWebACLRequest struct {
	*aws.Request
	Input *UpdateWebACLInput
	Copy  func(*UpdateWebACLInput) UpdateWebACLRequest
}

// Send marshals and sends the UpdateWebACL API request.
func (r UpdateWebACLRequest) Send(ctx context.Context) (*UpdateWebACLResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &UpdateWebACLResponse{
		UpdateWebACLOutput: r.Request.Data.(*UpdateWebACLOutput),
		response:           &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// UpdateWebACLResponse is the response type for the
// UpdateWebACL API operation.
type UpdateWebACLResponse struct {
	*UpdateWebACLOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// UpdateWebACL request.
func (r *UpdateWebACLResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
