// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package workdocs

import (
	"context"
	"time"

	"github.com/aws/aws-sdk-go-v2/aws"
	"github.com/aws/aws-sdk-go-v2/internal/awsutil"
	"github.com/aws/aws-sdk-go-v2/private/protocol"
)

type InitiateDocumentVersionUploadInput struct {
	_ struct{} `type:"structure"`

	// Amazon WorkDocs authentication token. Not required when using AWS administrator
	// credentials to access the API.
	AuthenticationToken *string `location:"header" locationName:"Authentication" min:"1" type:"string" sensitive:"true"`

	// The timestamp when the content of the document was originally created.
	ContentCreatedTimestamp *time.Time `type:"timestamp"`

	// The timestamp when the content of the document was modified.
	ContentModifiedTimestamp *time.Time `type:"timestamp"`

	// The content type of the document.
	ContentType *string `min:"1" type:"string"`

	// The size of the document, in bytes.
	DocumentSizeInBytes *int64 `type:"long"`

	// The ID of the document.
	Id *string `min:"1" type:"string"`

	// The name of the document.
	Name *string `min:"1" type:"string"`

	// The ID of the parent folder.
	//
	// ParentFolderId is a required field
	ParentFolderId *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation
func (s InitiateDocumentVersionUploadInput) String() string {
	return awsutil.Prettify(s)
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *InitiateDocumentVersionUploadInput) Validate() error {
	invalidParams := aws.ErrInvalidParams{Context: "InitiateDocumentVersionUploadInput"}
	if s.AuthenticationToken != nil && len(*s.AuthenticationToken) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("AuthenticationToken", 1))
	}
	if s.ContentType != nil && len(*s.ContentType) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ContentType", 1))
	}
	if s.Id != nil && len(*s.Id) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Id", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("Name", 1))
	}

	if s.ParentFolderId == nil {
		invalidParams.Add(aws.NewErrParamRequired("ParentFolderId"))
	}
	if s.ParentFolderId != nil && len(*s.ParentFolderId) < 1 {
		invalidParams.Add(aws.NewErrParamMinLen("ParentFolderId", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InitiateDocumentVersionUploadInput) MarshalFields(e protocol.FieldEncoder) error {
	e.SetValue(protocol.HeaderTarget, "Content-Type", protocol.StringValue("application/json"), protocol.Metadata{})

	if s.ContentCreatedTimestamp != nil {
		v := *s.ContentCreatedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentCreatedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ContentModifiedTimestamp != nil {
		v := *s.ContentModifiedTimestamp

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentModifiedTimestamp",
			protocol.TimeValue{V: v, Format: protocol.UnixTimeFormatName, QuotedFormatTime: true}, metadata)
	}
	if s.ContentType != nil {
		v := *s.ContentType

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ContentType", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.DocumentSizeInBytes != nil {
		v := *s.DocumentSizeInBytes

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "DocumentSizeInBytes", protocol.Int64Value(v), metadata)
	}
	if s.Id != nil {
		v := *s.Id

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Id", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.Name != nil {
		v := *s.Name

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "Name", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.ParentFolderId != nil {
		v := *s.ParentFolderId

		metadata := protocol.Metadata{}
		e.SetValue(protocol.BodyTarget, "ParentFolderId", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	if s.AuthenticationToken != nil {
		v := *s.AuthenticationToken

		metadata := protocol.Metadata{}
		e.SetValue(protocol.HeaderTarget, "Authentication", protocol.QuotedValue{ValueMarshaler: protocol.StringValue(v)}, metadata)
	}
	return nil
}

type InitiateDocumentVersionUploadOutput struct {
	_ struct{} `type:"structure"`

	// The document metadata.
	Metadata *DocumentMetadata `type:"structure"`

	// The upload metadata.
	UploadMetadata *UploadMetadata `type:"structure"`
}

// String returns the string representation
func (s InitiateDocumentVersionUploadOutput) String() string {
	return awsutil.Prettify(s)
}

// MarshalFields encodes the AWS API shape using the passed in protocol encoder.
func (s InitiateDocumentVersionUploadOutput) MarshalFields(e protocol.FieldEncoder) error {
	if s.Metadata != nil {
		v := s.Metadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "Metadata", v, metadata)
	}
	if s.UploadMetadata != nil {
		v := s.UploadMetadata

		metadata := protocol.Metadata{}
		e.SetFields(protocol.BodyTarget, "UploadMetadata", v, metadata)
	}
	return nil
}

const opInitiateDocumentVersionUpload = "InitiateDocumentVersionUpload"

// InitiateDocumentVersionUploadRequest returns a request value for making API operation for
// Amazon WorkDocs.
//
// Creates a new document object and version object.
//
// The client specifies the parent folder ID and name of the document to upload.
// The ID is optionally specified when creating a new version of an existing
// document. This is the first step to upload a document. Next, upload the document
// to the URL returned from the call, and then call UpdateDocumentVersion.
//
// To cancel the document upload, call AbortDocumentVersionUpload.
//
//    // Example sending a request using InitiateDocumentVersionUploadRequest.
//    req := client.InitiateDocumentVersionUploadRequest(params)
//    resp, err := req.Send(context.TODO())
//    if err == nil {
//        fmt.Println(resp)
//    }
//
// Please also see https://docs.aws.amazon.com/goto/WebAPI/workdocs-2016-05-01/InitiateDocumentVersionUpload
func (c *Client) InitiateDocumentVersionUploadRequest(input *InitiateDocumentVersionUploadInput) InitiateDocumentVersionUploadRequest {
	op := &aws.Operation{
		Name:       opInitiateDocumentVersionUpload,
		HTTPMethod: "POST",
		HTTPPath:   "/api/v1/documents",
	}

	if input == nil {
		input = &InitiateDocumentVersionUploadInput{}
	}

	req := c.newRequest(op, input, &InitiateDocumentVersionUploadOutput{})

	return InitiateDocumentVersionUploadRequest{Request: req, Input: input, Copy: c.InitiateDocumentVersionUploadRequest}
}

// InitiateDocumentVersionUploadRequest is the request type for the
// InitiateDocumentVersionUpload API operation.
type InitiateDocumentVersionUploadRequest struct {
	*aws.Request
	Input *InitiateDocumentVersionUploadInput
	Copy  func(*InitiateDocumentVersionUploadInput) InitiateDocumentVersionUploadRequest
}

// Send marshals and sends the InitiateDocumentVersionUpload API request.
func (r InitiateDocumentVersionUploadRequest) Send(ctx context.Context) (*InitiateDocumentVersionUploadResponse, error) {
	r.Request.SetContext(ctx)
	err := r.Request.Send()
	if err != nil {
		return nil, err
	}

	resp := &InitiateDocumentVersionUploadResponse{
		InitiateDocumentVersionUploadOutput: r.Request.Data.(*InitiateDocumentVersionUploadOutput),
		response:                            &aws.Response{Request: r.Request},
	}

	return resp, nil
}

// InitiateDocumentVersionUploadResponse is the response type for the
// InitiateDocumentVersionUpload API operation.
type InitiateDocumentVersionUploadResponse struct {
	*InitiateDocumentVersionUploadOutput

	response *aws.Response
}

// SDKResponseMetdata returns the response metadata for the
// InitiateDocumentVersionUpload request.
func (r *InitiateDocumentVersionUploadResponse) SDKResponseMetdata() *aws.Response {
	return r.response
}
