// Copyright 2018 JDCLOUD.COM
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
// NOTE: This class is auto generated by the jdcloud code generator program.

package apis

import (
	"github.com/go-acme/jdcloud-sdk-go/core"
)

type CreateMonitorTargetRequest struct {
	core.JDCloudRequest

	/* 实例所属的地域ID  */
	RegionId string `json:"regionId"`

	/* 域名ID，请使用describeDomains接口获取。  */
	DomainId string `json:"domainId"`

	/* 子域名  */
	SubDomainName string `json:"subDomainName"`

	/* 子域名可用监控对象的数组  */
	Targets []string `json:"targets"`
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param subDomainName: 子域名 (Required)
 * param targets: 子域名可用监控对象的数组 (Required)
 *
 * @Deprecated, not compatible when mandatory parameters changed
 */
func NewCreateMonitorTargetRequest(
	regionId string,
	domainId string,
	subDomainName string,
	targets []string,
) *CreateMonitorTargetRequest {

	return &CreateMonitorTargetRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitorTarget",
			Method:  "POST",
			Header:  nil,
			Version: "v2",
		},
		RegionId:      regionId,
		DomainId:      domainId,
		SubDomainName: subDomainName,
		Targets:       targets,
	}
}

/*
 * param regionId: 实例所属的地域ID (Required)
 * param domainId: 域名ID，请使用describeDomains接口获取。 (Required)
 * param subDomainName: 子域名 (Required)
 * param targets: 子域名可用监控对象的数组 (Required)
 */
func NewCreateMonitorTargetRequestWithAllParams(
	regionId string,
	domainId string,
	subDomainName string,
	targets []string,
) *CreateMonitorTargetRequest {

	return &CreateMonitorTargetRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitorTarget",
			Method:  "POST",
			Header:  nil,
			Version: "v2",
		},
		RegionId:      regionId,
		DomainId:      domainId,
		SubDomainName: subDomainName,
		Targets:       targets,
	}
}

/* This constructor has better compatible ability when API parameters changed */
func NewCreateMonitorTargetRequestWithoutParam() *CreateMonitorTargetRequest {

	return &CreateMonitorTargetRequest{
		JDCloudRequest: core.JDCloudRequest{
			URL:     "/regions/{regionId}/domain/{domainId}/monitorTarget",
			Method:  "POST",
			Header:  nil,
			Version: "v2",
		},
	}
}

/* param regionId: 实例所属的地域ID(Required) */
func (r *CreateMonitorTargetRequest) SetRegionId(regionId string) {
	r.RegionId = regionId
}

/* param domainId: 域名ID，请使用describeDomains接口获取。(Required) */
func (r *CreateMonitorTargetRequest) SetDomainId(domainId string) {
	r.DomainId = domainId
}

/* param subDomainName: 子域名(Required) */
func (r *CreateMonitorTargetRequest) SetSubDomainName(subDomainName string) {
	r.SubDomainName = subDomainName
}

/* param targets: 子域名可用监控对象的数组(Required) */
func (r *CreateMonitorTargetRequest) SetTargets(targets []string) {
	r.Targets = targets
}

// GetRegionId returns path parameter 'regionId' if exist,
// otherwise return empty string
func (r CreateMonitorTargetRequest) GetRegionId() string {
	return r.RegionId
}

type CreateMonitorTargetResponse struct {
	RequestID string                    `json:"requestId"`
	Error     core.ErrorResponse        `json:"error"`
	Result    CreateMonitorTargetResult `json:"result"`
}

type CreateMonitorTargetResult struct {
}
