%define compat 0

Summary: The password database library.
%if %{compat}
Name: compat-pwdb
Obsoletes: pwdb
%else
Name: pwdb
%endif
Version: 0.62
Release: 1
License: GPL or BSD
Group: System Environment/Base
Source: pwdb-%{version}.tar.gz
BuildRoot: %{_tmppath}/pwdb-root

%description
The compat-pwdb package contains libpwdb, the password database library.
Libpwdb is a library which implements a generic user information
database.  Libpwdb was specifically designed to work with Linux's PAM
(Pluggable Authentication Modules).  Libpwdb allows configurable
access to and management of security tools like /etc/passwd,
/etc/shadow and network authentication systems including NIS and
Radius.

%prep
%setup -q -n pwdb-%{version}
rm default.defs
ln -s defs/redhat.defs default.defs
# checking out of the CVS sometimes preserves the setgid bit on
# directories...
chmod -R g-s .

%build
make RPM_OPT_FLAGS="$RPM_OPT_FLAGS"

%install
rm -rf $RPM_BUILD_ROOT
mkdir -p $RPM_BUILD_ROOT/{etc,%{_lib},usr/include/pwdb}

make	INCLUDED=$RPM_BUILD_ROOT/usr/include/pwdb \
	LIBDIR=$RPM_BUILD_ROOT/%{_lib} \
	LDCONFIG=":" \
	install

install -m 644 conf/pwdb.conf $RPM_BUILD_ROOT/etc/pwdb.conf

%if %{compat}
rm -fr $RPM_BUILD_ROOT/usr/include/pwdb
rm -f $RPM_BUILD_ROOT/%{_lib}/libpwdb.a
rm -f $RPM_BUILD_ROOT/%{_lib}/libpwdb.so
%endif

%post -p /sbin/ldconfig

%postun -p /sbin/ldconfig

%clean
rm -rf $RPM_BUILD_ROOT

%files
%defattr(-,root,root)
%doc Copyright doc/pwdb.txt doc/html
%config /etc/pwdb.conf
/%{_lib}/libpwdb.so.%{version}

%if ! %{compat}
/usr/include/pwdb
/%{_lib}/libpwdb.a
/%{_lib}/libpwdb.so
%endif

%changelog
* Mon Dec  9 2002 Nalin Dahyabhai <nalin@redhat.com> 0.62-1
- don't trash the sp_flag field when modifying shadow records

* Thu Nov 14 2002 Nalin Dahyabhai <nalin@redhat.com> 0.61.2-4
- move libraries from /lib to /%%{_lib} for the benefit of multilib systems
- remove unpackaged files from the buildroot at the end of the %%install phase

* Fri Jun 21 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Sun May 26 2002 Tim Powers <timp@redhat.com>
- automated rebuild

* Mon Mar 11 2002 Nalin Dahyabhai <nalin@redhat.com> 0.61.2-3
- relegate to binary-compatibility land (again)

* Fri Feb 22 2002 Nalin Dahyabhai <nalin@redhat.com> 0.61.2-2
- rebuild as a full-blown package

* Thu Jan 31 2002 Nalin Dahyabhai <nalin@redhat.com> 0.61.2-1
- build as a binary compat package

* Mon Apr  2 2001 Nalin Dahyabhai <nalin@redhat.com>
- add patch to clean up memory leakage from Mark Wright

* Wed Aug 30 2000 Nalin Dahyabhai <nalin@redhat.com>
- add missing header files (#16951)

* Wed Jul 12 2000 Prospector <bugzilla@redhat.com>
- automatic rebuild

* Sun Jun 18 2000 Matt Wilson <msw@redhat.com>
- rebuild for next release

* Wed Feb 02 2000 Cristian Gafton <gafton@redhat.com>
- fix setting the password for passwordless accounts. Patch from Thomas
  Sailer

* Mon Jan 31 2000 Cristian Gafton <gafton@redhat.com>
- rebuild to fix dependencies
