/*
 * Decompiled with CFR 0.152.
 */
package net.sf.hibernate.expression;

import net.sf.hibernate.HibernateException;
import net.sf.hibernate.engine.SessionFactoryImplementor;
import net.sf.hibernate.engine.TypedValue;
import net.sf.hibernate.expression.Expression;
import net.sf.hibernate.util.StringHelper;

public abstract class PropertyExpression
extends Expression {
    private final String propertyName;
    private final String otherPropertyName;
    private static final TypedValue[] NO_TYPED_VALUES = new TypedValue[0];

    PropertyExpression(String propertyName, String otherPropertyName) {
        this.propertyName = propertyName;
        this.otherPropertyName = otherPropertyName;
    }

    public String toSqlString(SessionFactoryImplementor sessionFactory, Class persistentClass, String alias) throws HibernateException {
        return StringHelper.join(" and ", StringHelper.add(Expression.getColumns(sessionFactory, persistentClass, this.propertyName, alias), this.getOp(), Expression.getColumns(sessionFactory, persistentClass, this.otherPropertyName, alias)));
    }

    public TypedValue[] getTypedValues(SessionFactoryImplementor sessionFactory, Class persistentClass) throws HibernateException {
        return NO_TYPED_VALUES;
    }

    public String toString() {
        return this.propertyName + this.getOp() + this.otherPropertyName;
    }

    abstract String getOp();
}

