/*****************************************************************************
 * Copyright (C) 2020 VLC authors and VideoLAN
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston MA 02110-1301, USA.
 *****************************************************************************/
#ifndef VIDEOWINDOWHANDLER_HPP
#define VIDEOWINDOWHANDLER_HPP

#ifdef HAVE_CONFIG_H
# include "config.h"
#endif

#include <vlc_common.h>

#include <QWindow>
#include <QObject>
#include <QPointer>

#include "qt.hpp"

class MainCtx;

class VideoWindowHandler : public QObject
{
    Q_OBJECT
public:
    explicit VideoWindowHandler(qt_intf_t *intf, QObject *parent = nullptr);

public:
    void setWindow(QWindow* window);

    void disable();
    void requestResizeVideo( unsigned, unsigned );
    void requestVideoState( unsigned );
    void requestVideoWindowed( );
    void requestVideoFullScreen( const char * );

signals:
    void askVideoToResize( unsigned int, unsigned int, Qt::WindowStates );
    void askVideoSetFullScreen( bool );
    void askVideoOnTop( bool );

protected slots:
    /* Manage the Video Functions from the vout threads */
    void setVideoSize(unsigned int w, unsigned int h, Qt::WindowStates states );
    virtual void setVideoFullScreen( bool );
    void setVideoOnTop( bool );

private:
    qt_intf_t *m_intf = nullptr;
    QPointer<QWindow> m_window;

    bool m_videoFullScreen = false;
    bool m_autoresize = false;

    QScreen* m_lastWinScreen = nullptr;

    bool m_hasWayland = false;
};

#endif // VIDEOWINDOWHANDLER_HPP
