# Contributing
Contributions are welcome. Please bear the following in mind:

- **Base your changes on the `main` branch**
    - If necessary, rebase against `main` before opening a pull request
- This codebase uses Ruff, and PRs are gated on `ruff check` passing. Run `ruff check` locally before opening a PR
  - PRs that reformat code will not be accepted.
- Ensure that all methods added have a proper docstring. **Please do not use Doctest**
- If at all possible, don't add dependencies
    - If it is unavoidable, you must ensure that the dependency is maintained, and supported
    - Ensure that you add your dependency to [pyproject.toml](pyproject.toml)
- Run the tests and ensure that they pass. If you are adding a feature **you must add tests that exercise it**
- If your pull request is a feature **document the feature**
- One feature per pull request
- [squash](http://git-scm.com/book/en/Git-Tools-Rewriting-History#Squashing-Commits) your commits before opening a pull request unless it makes no sense to do so
- If in doubt, comment your code.

# License of Contributed Code
Contributions are licensed under the Blue Oak Contributor Licence 1.0.0. See below

# Blue Oak Contributor License

Version 1.0.0

## Purpose

This license gives the steward of a software project
the legal rights and assurances it needs to accept
contributions covered by intellectual property rights.

## Copyright

The contributor licenses the steward to do everything with
their contributions that would otherwise infringe their
copyrights in them.

## Patent

The contributor licenses the steward to do everything with
their contributions that would otherwise infringe any patent
claims they can license or become able to license.

## Sublicensing

The steward can license the contributions to others in
turn, under whatever terms it chooses.

## Reliability

The contributor cannot revoke this license.

## Termination

The contributor can stop this license from covering
contributions submitted in the future by writing the steward
through one of the channels it uses to receive contributions.
Contributions the contributor submitted before remain under
this license.

## Awareness

The contributor is aware that because of legal rules and
contracts, they may need to get someone else's permission to
submit contributions, even of their own work.  For example,
"work made for hire" rules can make employers and clients
the owners of copyrights in the contributor's work.
Contracts with clients, or to form new companies, may make
them the owners of copyrights in the contributor's work.

## Rights

All work in contributions the contributor submits for
inclusion in the project will be either:

- their own work, which they own the copyrights in or
  have permission to submit

- work licensed by others under permissive license
  terms that Blue Oak Council rates "bronze" or better at
  <https://blueoakcouncil.org/list>

## Notices

The contributor promises to copy copyright notices,
license terms, and other licensing-related notices for
work licensed by others in their contributions, so the
steward can tell what work is licensed by others under
what terms and follow their notice requirements.

## No Liability

***As far as the law allows, contributions under this
license come as is, without any warranty or condition,
except those under "Rights" above.***

***As far as the law allows, the contributor will not be
liable to anyone for any damages related to contributions
under this license, under any kind of legal claim, except
for claims under "Rights" above.***

