# \RoutingApi

All URIs are relative to *https://api.transitous.org*

Method | HTTP request | Description
------------- | ------------- | -------------
[**one_to_all**](RoutingApi.md#one_to_all) | **GET** /api/v1/one-to-all | Computes all reachable locations from a given stop within a set duration. Each result entry will contain the fastest travel duration and the number of connections used. 
[**one_to_many**](RoutingApi.md#one_to_many) | **GET** /api/v1/one-to-many | Street routing from one to many places or many to one. The order in the response array corresponds to the order of coordinates of the \\`many\\` parameter in the query. 
[**plan**](RoutingApi.md#plan) | **GET** /api/v5/plan | Computes optimal connections from one place to another.



## one_to_all

> models::Reachable one_to_all(one, max_travel_time, time, arrive_by, max_transfers, min_transfer_time, additional_transfer_time, transfer_time_factor, max_matching_distance, use_routed_transfers, pedestrian_profile, pedestrian_speed, cycling_speed, elevation_costs, transit_modes, pre_transit_modes, post_transit_modes, require_bike_transport, require_car_transport, max_pre_transit_time, max_post_transit_time)
Computes all reachable locations from a given stop within a set duration. Each result entry will contain the fastest travel duration and the number of connections used. 

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**one** | **String** | \\`latitude,longitude[,level]\\` tuple with - latitude and longitude in degrees - (optional) level: the OSM level (default: 0)  OR  stop id  | [required] |
**max_travel_time** | **i32** | The maximum travel time in minutes. Defaults to 90. The limit may be increased by the server administrator using `onetoall_max_travel_minutes` option in `config.yml`. See documentation for details. | [required] |
**time** | Option<**String**> | Optional. Defaults to the current time.  Departure time ($arriveBy=false) / arrival date ($arriveBy=true),  |  |
**arrive_by** | Option<**bool**> | true = all to one, false = one to all  |  |[default to false]
**max_transfers** | Option<**i32**> | The maximum number of allowed transfers (i.e. interchanges between transit legs, pre- and postTransit do not count as transfers). `maxTransfers=0` searches for direct transit connections without any transfers. If you want to search only for non-transit connections (`FOOT`, `CAR`, etc.), send an empty `transitModes` parameter instead.  If not provided, the routing uses the server-side default value which is hardcoded and very high to cover all use cases.  *Warning*: Use with care. Setting this too low can lead to optimal (e.g. the fastest) journeys not being found. If this value is too low to reach the destination at all, it can lead to slow routing performance.  In plan endpoints before v3, the behavior is off by one, i.e. `maxTransfers=0` only returns non-transit connections.  |  |
**min_transfer_time** | Option<**i32**> | Optional. Default is 0 minutes.  Minimum transfer time for each transfer in minutes.  |  |[default to 0]
**additional_transfer_time** | Option<**i32**> | Optional. Default is 0 minutes.  Additional transfer time reserved for each transfer in minutes.  |  |[default to 0]
**transfer_time_factor** | Option<**f64**> | Optional. Default is 1.0  Factor to multiply minimum required transfer times with. Values smaller than 1.0 are not supported.  |  |[default to 1.0]
**max_matching_distance** | Option<**f64**> | Optional. Default is 25 meters.  Maximum matching distance in meters to match geo coordinates to the street network.  |  |[default to 25]
**use_routed_transfers** | Option<**bool**> | Optional. Default is `false`.  Whether to use transfers routed on OpenStreetMap data.  |  |[default to false]
**pedestrian_profile** | Option<[**PedestrianProfile**](.md)> | Optional. Default is `FOOT`.  Accessibility profile to use for pedestrian routing in transfers between transit connections and the first and last mile respectively.  |  |[default to FOOT]
**pedestrian_speed** | Option<**f64**> | Optional  Average speed for pedestrian routing.  |  |
**cycling_speed** | Option<**f64**> | Optional  Average speed for bike routing.  |  |
**elevation_costs** | Option<[**ElevationCosts**](.md)> | Optional. Default is `NONE`.  Set an elevation cost profile, to penalize routes with incline. - `NONE`: No additional costs for elevations. This is the default behavior - `LOW`: Add a low cost for increase in elevation and incline along the way. This will prefer routes with less ascent, if small detours are required. - `HIGH`: Add a high cost for increase in elevation and incline along the way. This will prefer routes with less ascent, if larger detours are required.  As using an elevation costs profile will increase the travel duration, routing through steep terrain may exceed the maximal allowed duration, causing a location to appear unreachable. Increasing the maximum travel time for these segments may resolve this issue.  The profile is used for routing on both the first and last mile.  Elevation cost profiles are currently used by following street modes: - `BIKE`  |  |[default to NONE]
**transit_modes** | Option<[**Vec<models::Mode>**](models::Mode.md)> | Optional. Default is `TRANSIT` which allows all transit modes (no restriction). Allowed modes for the transit part. If empty, no transit connections will be computed. For example, this can be used to allow only `SUBURBAN,SUBWAY,TRAM`.  |  |[default to [TRANSIT]]
**pre_transit_modes** | Option<[**Vec<models::Mode>**](models::Mode.md)> | Optional. Default is `WALK`. The behavior depends on whether `arriveBy` is set:   - `arriveBy=true`: Currently not used   - `arriveBy=false`: Only applies if the `one` place is a coordinate (not a transit stop).  A list of modes that are allowed to be used from the last transit stop to the `to` coordinate. Example: `WALK,BIKE_SHARING`.  |  |[default to [WALK]]
**post_transit_modes** | Option<[**Vec<models::Mode>**](models::Mode.md)> | Optional. Default is `WALK`. The behavior depends on whether `arriveBy` is set:   - `arriveBy=true`: Only applies if the `one` place is a coordinate (not a transit stop).   - `arriveBy=false`: Currently not used  A list of modes that are allowed to be used from the last transit stop to the `to` coordinate. Example: `WALK,BIKE_SHARING`.  |  |[default to [WALK]]
**require_bike_transport** | Option<**bool**> | Optional. Default is `false`.  If set to `true`, all used transit trips are required to allow bike carriage.  |  |[default to false]
**require_car_transport** | Option<**bool**> | Optional. Default is `false`.  If set to `true`, all used transit trips are required to allow car carriage.  |  |[default to false]
**max_pre_transit_time** | Option<**i32**> | Optional. Default is 15min which is `900`.   - `arriveBy=true`: Currently not used   - `arriveBy=false`: Maximum time in seconds for the street leg at `one` location. Is limited by server config variable `street_routing_max_prepost_transit_seconds`.  |  |[default to 900]
**max_post_transit_time** | Option<**i32**> | Optional. Default is 15min which is `900`.   - `arriveBy=true`: Maximum time in seconds for the street leg at `one` location.   - `arriveBy=false`: Currently not used Is limited by server config variable `street_routing_max_prepost_transit_seconds`.  |  |[default to 900]

### Return type

[**models::Reachable**](Reachable.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## one_to_many

> Vec<models::Duration> one_to_many(one, many, mode, max, max_matching_distance, arrive_by, elevation_costs)
Street routing from one to many places or many to one. The order in the response array corresponds to the order of coordinates of the \\`many\\` parameter in the query. 

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**one** | **String** | geo location as latitude;longitude | [required] |
**many** | [**Vec<String>**](String.md) | geo locations as latitude;longitude,latitude;longitude,... | [required] |
**mode** | [**Mode**](.md) | routing profile to use (currently supported: \\`WALK\\`, \\`BIKE\\`, \\`CAR\\`)  | [required] |
**max** | **f64** | maximum travel time in seconds | [required] |
**max_matching_distance** | **f64** | maximum matching distance in meters to match geo coordinates to the street network | [required] |
**arrive_by** | **bool** | true = many to one false = one to many  | [required] |
**elevation_costs** | Option<[**ElevationCosts**](.md)> | Optional. Default is `NONE`.  Set an elevation cost profile, to penalize routes with incline. - `NONE`: No additional costs for elevations. This is the default behavior - `LOW`: Add a low cost for increase in elevation and incline along the way. This will prefer routes with less ascent, if small detours are required. - `HIGH`: Add a high cost for increase in elevation and incline along the way. This will prefer routes with less ascent, if larger detours are required.  As using an elevation costs profile will increase the travel duration, routing through steep terrain may exceed the maximal allowed duration, causing a location to appear unreachable. Increasing the maximum travel time for these segments may resolve this issue.  Elevation cost profiles are currently used by following street modes: - `BIKE`  |  |[default to NONE]

### Return type

[**Vec<models::Duration>**](Duration.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)


## plan

> models::Plan200Response plan(from_place, to_place, detailed_transfers, via, via_minimum_stay, time, max_transfers, max_travel_time, min_transfer_time, additional_transfer_time, transfer_time_factor, max_matching_distance, pedestrian_profile, pedestrian_speed, cycling_speed, elevation_costs, use_routed_transfers, join_interlined_legs, transit_modes, direct_modes, pre_transit_modes, post_transit_modes, direct_rental_form_factors, pre_transit_rental_form_factors, post_transit_rental_form_factors, direct_rental_propulsion_types, pre_transit_rental_propulsion_types, post_transit_rental_propulsion_types, direct_rental_providers, direct_rental_provider_groups, pre_transit_rental_providers, pre_transit_rental_provider_groups, post_transit_rental_providers, post_transit_rental_provider_groups, ignore_direct_rental_return_constraints, ignore_pre_transit_rental_return_constraints, ignore_post_transit_rental_return_constraints, num_itineraries, max_itineraries, page_cursor, timetable_view, arrive_by, search_window, require_bike_transport, require_car_transport, max_pre_transit_time, max_post_transit_time, max_direct_time, fastest_direct_factor, timeout, passengers, luggage, slow_direct, fastest_slow_direct_factor, with_fares, with_scheduled_skipped_stops, language, algorithm)
Computes optimal connections from one place to another.

### Parameters


Name | Type | Description  | Required | Notes
------------- | ------------- | ------------- | ------------- | -------------
**from_place** | **String** | \\`latitude,longitude[,level]\\` tuple with - latitude and longitude in degrees - (optional) level: the OSM level (default: 0)  OR  stop id  | [required] |
**to_place** | **String** | \\`latitude,longitude[,level]\\` tuple with - latitude and longitude in degrees - (optional) level: the OSM level (default: 0)  OR  stop id  | [required] |
**detailed_transfers** | **bool** | - true: Compute transfer polylines and step instructions. - false: Only return basic information (start time, end time, duration) for transfers.  | [required] |[default to true]
**via** | Option<[**Vec<String>**](String.md)> | List of via stops to visit (only stop IDs, no coordinates allowed for now). Also see the optional parameter `viaMinimumStay` to set a set a minimum stay duration for each via stop.  |  |
**via_minimum_stay** | Option<[**Vec<i32>**](i32.md)> | Optional. If not set, the default is `0,0` - no stay required.  For each `via` stop a minimum stay duration in minutes.  The value `0` signals that it's allowed to stay in the same trip. This enables via stays without counting a transfer and can lead  to better connections with less transfers. Transfer connections can still be found with `viaMinimumStay=0`.  |  |[default to [0,0]]
**time** | Option<**String**> | Optional. Defaults to the current time.  Departure time ($arriveBy=false) / arrival date ($arriveBy=true),  |  |
**max_transfers** | Option<**i32**> | The maximum number of allowed transfers (i.e. interchanges between transit legs, pre- and postTransit do not count as transfers). `maxTransfers=0` searches for direct transit connections without any transfers. If you want to search only for non-transit connections (`FOOT`, `CAR`, etc.), send an empty `transitModes` parameter instead.  If not provided, the routing uses the server-side default value which is hardcoded and very high to cover all use cases.  *Warning*: Use with care. Setting this too low can lead to optimal (e.g. the fastest) journeys not being found. If this value is too low to reach the destination at all, it can lead to slow routing performance.  In plan endpoints before v3, the behavior is off by one, i.e. `maxTransfers=0` only returns non-transit connections.  |  |
**max_travel_time** | Option<**i32**> | The maximum travel time in minutes. If not provided, the routing to uses the value hardcoded in the server which is usually quite high.  *Warning*: Use with care. Setting this too low can lead to optimal (e.g. the least transfers) journeys not being found. If this value is too low to reach the destination at all, it can lead to slow routing performance.  |  |
**min_transfer_time** | Option<**i32**> | Optional. Default is 0 minutes.  Minimum transfer time for each transfer in minutes.  |  |[default to 0]
**additional_transfer_time** | Option<**i32**> | Optional. Default is 0 minutes.  Additional transfer time reserved for each transfer in minutes.  |  |[default to 0]
**transfer_time_factor** | Option<**f64**> | Optional. Default is 1.0  Factor to multiply minimum required transfer times with. Values smaller than 1.0 are not supported.  |  |[default to 1.0]
**max_matching_distance** | Option<**f64**> | Optional. Default is 25 meters.  Maximum matching distance in meters to match geo coordinates to the street network.  |  |[default to 25]
**pedestrian_profile** | Option<[**PedestrianProfile**](.md)> | Optional. Default is `FOOT`.  Accessibility profile to use for pedestrian routing in transfers between transit connections, on the first mile, and last mile.  |  |[default to FOOT]
**pedestrian_speed** | Option<**f64**> | Optional  Average speed for pedestrian routing.  |  |
**cycling_speed** | Option<**f64**> | Optional  Average speed for bike routing.  |  |
**elevation_costs** | Option<[**ElevationCosts**](.md)> | Optional. Default is `NONE`.  Set an elevation cost profile, to penalize routes with incline. - `NONE`: No additional costs for elevations. This is the default behavior - `LOW`: Add a low cost for increase in elevation and incline along the way. This will prefer routes with less ascent, if small detours are required. - `HIGH`: Add a high cost for increase in elevation and incline along the way. This will prefer routes with less ascent, if larger detours are required.  As using an elevation costs profile will increase the travel duration, routing through steep terrain may exceed the maximal allowed duration, causing a location to appear unreachable. Increasing the maximum travel time for these segments may resolve this issue.  The profile is used for direct routing, on the first mile, and last mile.  Elevation cost profiles are currently used by following street modes: - `BIKE`  |  |[default to NONE]
**use_routed_transfers** | Option<**bool**> | Optional. Default is `false`.  Whether to use transfers routed on OpenStreetMap data.  |  |[default to false]
**join_interlined_legs** | Option<**bool**> | Optional. Default is `true`.  Controls if a journey section with stay-seated transfers is returned: - `joinInterlinedLegs=false`: as several legs (full information about all trip numbers, headsigns, etc.).   Legs that do not require a transfer (stay-seated transfer) are marked with `interlineWithPreviousLeg=true`. - `joinInterlinedLegs=true` (default behavior): as only one joined leg containing all stops  |  |[default to true]
**transit_modes** | Option<[**Vec<models::Mode>**](models::Mode.md)> | Optional. Default is `TRANSIT` which allows all transit modes (no restriction). Allowed modes for the transit part. If empty, no transit connections will be computed. For example, this can be used to allow only `SUBURBAN,SUBWAY,TRAM`.  |  |[default to ["TRANSIT"]]
**direct_modes** | Option<[**Vec<models::Mode>**](models::Mode.md)> | Optional. Default is `WALK` which will compute walking routes as direct connections.  Modes used for direction connections from start to destination without using transit. Results will be returned on the `direct` key.  Note: Direct connections will only be returned on the first call. For paging calls, they can be omitted.  Note: Transit connections that are slower than the fastest direct connection will not show up. This is being used as a cut-off during transit routing to speed up the search. To prevent this, it's possible to send two separate requests (one with only `transitModes` and one with only `directModes`).  Note: the output `direct` array will stay empty if the input param `maxDirectTime` makes any direct trip impossible.  Only non-transit modes such as `WALK`, `BIKE`, `CAR`, `BIKE_SHARING`, etc. can be used.  |  |[default to ["WALK"]]
**pre_transit_modes** | Option<[**Vec<models::Mode>**](models::Mode.md)> | Optional. Default is `WALK`. Only applies if the `from` place is a coordinate (not a transit stop). Does not apply to direct connections (see `directModes`).  A list of modes that are allowed to be used from the `from` coordinate to the first transit stop. Example: `WALK,BIKE_SHARING`.  |  |[default to [WALK]]
**post_transit_modes** | Option<[**Vec<models::Mode>**](models::Mode.md)> | Optional. Default is `WALK`. Only applies if the `to` place is a coordinate (not a transit stop). Does not apply to direct connections (see `directModes`).  A list of modes that are allowed to be used from the last transit stop to the `to` coordinate. Example: `WALK,BIKE_SHARING`.  |  |[default to [WALK]]
**direct_rental_form_factors** | Option<[**Vec<models::RentalFormFactor>**](models::RentalFormFactor.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies to direct connections.  A list of vehicle type form factors that are allowed to be used for direct connections. If empty (the default), all form factors are allowed. Example: `BICYCLE,SCOOTER_STANDING`.  |  |
**pre_transit_rental_form_factors** | Option<[**Vec<models::RentalFormFactor>**](models::RentalFormFactor.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies if the `from` place is a coordinate (not a transit stop). Does not apply to direct connections (see `directRentalFormFactors`).  A list of vehicle type form factors that are allowed to be used from the `from` coordinate to the first transit stop. If empty (the default), all form factors are allowed. Example: `BICYCLE,SCOOTER_STANDING`.  |  |
**post_transit_rental_form_factors** | Option<[**Vec<models::RentalFormFactor>**](models::RentalFormFactor.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies if the `to` place is a coordinate (not a transit stop). Does not apply to direct connections (see `directRentalFormFactors`).  A list of vehicle type form factors that are allowed to be used from the last transit stop to the `to` coordinate. If empty (the default), all form factors are allowed. Example: `BICYCLE,SCOOTER_STANDING`.  |  |
**direct_rental_propulsion_types** | Option<[**Vec<models::RentalPropulsionType>**](models::RentalPropulsionType.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies to direct connections.  A list of vehicle type form factors that are allowed to be used for direct connections. If empty (the default), all propulsion types are allowed. Example: `HUMAN,ELECTRIC,ELECTRIC_ASSIST`.  |  |
**pre_transit_rental_propulsion_types** | Option<[**Vec<models::RentalPropulsionType>**](models::RentalPropulsionType.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies if the `from` place is a coordinate (not a transit stop). Does not apply to direct connections (see `directRentalPropulsionTypes`).  A list of vehicle propulsion types that are allowed to be used from the `from` coordinate to the first transit stop. If empty (the default), all propulsion types are allowed. Example: `HUMAN,ELECTRIC,ELECTRIC_ASSIST`.  |  |
**post_transit_rental_propulsion_types** | Option<[**Vec<models::RentalPropulsionType>**](models::RentalPropulsionType.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies if the `to` place is a coordinate (not a transit stop). Does not apply to direct connections (see `directRentalPropulsionTypes`).  A list of vehicle propulsion types that are allowed to be used from the last transit stop to the `to` coordinate. If empty (the default), all propulsion types are allowed. Example: `HUMAN,ELECTRIC,ELECTRIC_ASSIST`.  |  |
**direct_rental_providers** | Option<[**Vec<String>**](String.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies to direct connections.  A list of rental providers that are allowed to be used for direct connections. If empty (the default), all providers are allowed.  |  |
**direct_rental_provider_groups** | Option<[**Vec<String>**](String.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies to direct connections.  A list of rental provider groups that are allowed to be used for direct connections. If empty (the default), all providers are allowed.  |  |
**pre_transit_rental_providers** | Option<[**Vec<String>**](String.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies if the `from` place is a coordinate (not a transit stop). Does not apply to direct connections (see `directRentalProviders`).  A list of rental providers that are allowed to be used from the `from` coordinate to the first transit stop. If empty (the default), all providers are allowed.  |  |
**pre_transit_rental_provider_groups** | Option<[**Vec<String>**](String.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies if the `from` place is a coordinate (not a transit stop). Does not apply to direct connections (see `directRentalProviderGroups`).  A list of rental provider groups that are allowed to be used from the `from` coordinate to the first transit stop. If empty (the default), all providers are allowed.  |  |
**post_transit_rental_providers** | Option<[**Vec<String>**](String.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies if the `to` place is a coordinate (not a transit stop). Does not apply to direct connections (see `directRentalProviders`).  A list of rental providers that are allowed to be used from the last transit stop to the `to` coordinate. If empty (the default), all providers are allowed.  |  |
**post_transit_rental_provider_groups** | Option<[**Vec<String>**](String.md)> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Only applies if the `to` place is a coordinate (not a transit stop). Does not apply to direct connections (see `directRentalProviderGroups`).  A list of rental provider groups that are allowed to be used from the last transit stop to the `to` coordinate. If empty (the default), all providers are allowed.  |  |
**ignore_direct_rental_return_constraints** | Option<**bool**> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Default is `false`.  If set to `true`, the routing will ignore rental return constraints for direct connections, allowing the rental vehicle to be parked anywhere.  |  |[default to false]
**ignore_pre_transit_rental_return_constraints** | Option<**bool**> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Default is `false`.  If set to `true`, the routing will ignore rental return constraints for the part from the `from` coordinate to the first transit stop, allowing the rental vehicle to be parked anywhere.  |  |[default to false]
**ignore_post_transit_rental_return_constraints** | Option<**bool**> | Experimental. Expect unannounced breaking changes (without version bumps).  Optional. Default is `false`.  If set to `true`, the routing will ignore rental return constraints for the part from the last transit stop to the `to` coordinate, allowing the rental vehicle to be parked anywhere.  |  |[default to false]
**num_itineraries** | Option<**i32**> | The minimum number of itineraries to compute. This is only relevant if `timetableView=true`. The default value is 5.  |  |[default to 5]
**max_itineraries** | Option<**i32**> | Optional. By default all computed itineraries will be returned  The maximum number of itineraries to compute. This is only relevant if `timetableView=true`.  Note: With the current implementation, setting this to a lower number will not result in any speedup.  Note: The number of returned itineraries might be slightly higher than `maxItineraries` as there might be several itineraries with the same departure time but different number of transfers. In order to not miss any itineraries for paging, either none or all itineraries with the same departure time have to be returned.  |  |
**page_cursor** | Option<**String**> | Use the cursor to go to the next \"page\" of itineraries. Copy the cursor from the last response and keep the original request as is. This will enable you to search for itineraries in the next or previous time-window.  |  |
**timetable_view** | Option<**bool**> | Optional. Default is `true`.  Search for the best trip options within a time window. If true two itineraries are considered optimal if one is better on arrival time (earliest wins) and the other is better on departure time (latest wins). In combination with arriveBy this parameter cover the following use cases:  `timetable=false` = waiting for the first transit departure/arrival is considered travel time:   - `arriveBy=true`: event (e.g. a meeting) starts at 10:00 am,     compute the best journeys that arrive by that time (maximizes departure time)   - `arriveBy=false`: event (e.g. a meeting) ends at 11:00 am,     compute the best journeys that depart after that time  `timetable=true` = optimize \"later departure\" + \"earlier arrival\" and give all options over a time window:   - `arriveBy=true`: the time window around `date` and `time` refers to the arrival time window   - `arriveBy=false`: the time window around `date` and `time` refers to the departure time window  |  |[default to true]
**arrive_by** | Option<**bool**> | Optional. Default is `false`.    - `arriveBy=true`: the parameters `date` and `time` refer to the arrival time   - `arriveBy=false`: the parameters `date` and `time` refer to the departure time  |  |[default to false]
**search_window** | Option<**i32**> | Optional. Default is 2 hours which is `7200`.  The length of the search-window in seconds. Default value two hours.    - `arriveBy=true`: number of seconds between the earliest departure time and latest departure time   - `arriveBy=false`: number of seconds between the earliest arrival time and the latest arrival time  |  |[default to 7200]
**require_bike_transport** | Option<**bool**> | Optional. Default is `false`.  If set to `true`, all used transit trips are required to allow bike carriage.  |  |[default to false]
**require_car_transport** | Option<**bool**> | Optional. Default is `false`.  If set to `true`, all used transit trips are required to allow car carriage.  |  |[default to false]
**max_pre_transit_time** | Option<**i32**> | Optional. Default is 15min which is `900`. Maximum time in seconds for the first street leg. Is limited by server config variable `street_routing_max_prepost_transit_seconds`.  |  |[default to 900]
**max_post_transit_time** | Option<**i32**> | Optional. Default is 15min which is `900`. Maximum time in seconds for the last street leg. Is limited by server config variable `street_routing_max_prepost_transit_seconds`.  |  |[default to 900]
**max_direct_time** | Option<**i32**> | Optional. Default is 30min which is `1800`. Maximum time in seconds for direct connections. Is limited by server config variable `street_routing_max_direct_seconds`.  |  |[default to 1800]
**fastest_direct_factor** | Option<**f64**> | Optional. Experimental. Default is `1.0`. Factor with which the duration of the fastest direct non-public-transit connection is multiplied. Values > 1.0 allow transit connections that are slower than the fastest direct non-public-transit connection to be found.  |  |[default to 1.0]
**timeout** | Option<**i32**> | Optional. Query timeout in seconds. |  |
**passengers** | Option<**i32**> | Optional. Experimental. Number of passengers (e.g. for ODM or price calculation) |  |
**luggage** | Option<**i32**> | Optional. Experimental. Number of luggage pieces; base unit: airline cabin luggage (e.g. for ODM or price calculation)  |  |
**slow_direct** | Option<**bool**> | Optional. Experimental. Adds overtaken direct public transit connections. |  |[default to false]
**fastest_slow_direct_factor** | Option<**f64**> | Optional.  Factor with which the duration of the fastest slowDirect connection is multiplied. Values > 1.0 allow connections that are slower than the fastest direct transit connection to be found. Values < 1.0 will return all slowDirect connections.  |  |[default to 3.0]
**with_fares** | Option<**bool**> | Optional. Experimental. If set to true, the response will contain fare information. |  |[default to false]
**with_scheduled_skipped_stops** | Option<**bool**> | Optional. Include intermediate stops where passengers can not alight/board according to schedule. |  |[default to false]
**language** | Option<[**Vec<String>**](String.md)> | language tags as used in OpenStreetMap / GTFS (usually BCP-47 / ISO 639-1, or ISO 639-2 if there's no ISO 639-1)  |  |
**algorithm** | Option<**String**> | algorithm to use |  |[default to RAPTOR]

### Return type

[**models::Plan200Response**](plan_200_response.md)

### Authorization

No authorization required

### HTTP request headers

- **Content-Type**: Not defined
- **Accept**: application/json

[[Back to top]](#) [[Back to API list]](../README.md#documentation-for-api-endpoints) [[Back to Model list]](../README.md#documentation-for-models) [[Back to README]](../README.md)

