/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */


use reqwest;
use serde::{Deserialize, Serialize, de::Error as _};
use crate::{apis::ResponseContent, models};
use super::{Error, configuration, ContentType};


/// struct for typed errors of method [`one_to_all`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum OneToAllError {
    Status400(models::Error),
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`one_to_many`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum OneToManyError {
    UnknownValue(serde_json::Value),
}

/// struct for typed errors of method [`plan`]
#[derive(Debug, Clone, Serialize, Deserialize)]
#[serde(untagged)]
pub enum PlanError {
    Status400(models::Error),
    UnknownValue(serde_json::Value),
}


pub async fn one_to_all(configuration: &configuration::Configuration, one: &str, max_travel_time: i32, time: Option<String>, arrive_by: Option<bool>, max_transfers: Option<i32>, min_transfer_time: Option<i32>, additional_transfer_time: Option<i32>, transfer_time_factor: Option<f64>, max_matching_distance: Option<f64>, use_routed_transfers: Option<bool>, pedestrian_profile: Option<models::PedestrianProfile>, pedestrian_speed: Option<f64>, cycling_speed: Option<f64>, elevation_costs: Option<models::ElevationCosts>, transit_modes: Option<Vec<models::Mode>>, pre_transit_modes: Option<Vec<models::Mode>>, post_transit_modes: Option<Vec<models::Mode>>, require_bike_transport: Option<bool>, require_car_transport: Option<bool>, max_pre_transit_time: Option<i32>, max_post_transit_time: Option<i32>) -> Result<models::Reachable, Error<OneToAllError>> {
    // add a prefix to parameters to efficiently prevent name collisions
    let p_query_one = one;
    let p_query_max_travel_time = max_travel_time;
    let p_query_time = time;
    let p_query_arrive_by = arrive_by;
    let p_query_max_transfers = max_transfers;
    let p_query_min_transfer_time = min_transfer_time;
    let p_query_additional_transfer_time = additional_transfer_time;
    let p_query_transfer_time_factor = transfer_time_factor;
    let p_query_max_matching_distance = max_matching_distance;
    let p_query_use_routed_transfers = use_routed_transfers;
    let p_query_pedestrian_profile = pedestrian_profile;
    let p_query_pedestrian_speed = pedestrian_speed;
    let p_query_cycling_speed = cycling_speed;
    let p_query_elevation_costs = elevation_costs;
    let p_query_transit_modes = transit_modes;
    let p_query_pre_transit_modes = pre_transit_modes;
    let p_query_post_transit_modes = post_transit_modes;
    let p_query_require_bike_transport = require_bike_transport;
    let p_query_require_car_transport = require_car_transport;
    let p_query_max_pre_transit_time = max_pre_transit_time;
    let p_query_max_post_transit_time = max_post_transit_time;

    let uri_str = format!("{}/api/v1/one-to-all", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    req_builder = req_builder.query(&[("one", &p_query_one.to_string())]);
    if let Some(ref param_value) = p_query_time {
        req_builder = req_builder.query(&[("time", &param_value.to_string())]);
    }
    req_builder = req_builder.query(&[("maxTravelTime", &p_query_max_travel_time.to_string())]);
    if let Some(ref param_value) = p_query_arrive_by {
        req_builder = req_builder.query(&[("arriveBy", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_transfers {
        req_builder = req_builder.query(&[("maxTransfers", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_min_transfer_time {
        req_builder = req_builder.query(&[("minTransferTime", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_additional_transfer_time {
        req_builder = req_builder.query(&[("additionalTransferTime", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_transfer_time_factor {
        req_builder = req_builder.query(&[("transferTimeFactor", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_matching_distance {
        req_builder = req_builder.query(&[("maxMatchingDistance", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_use_routed_transfers {
        req_builder = req_builder.query(&[("useRoutedTransfers", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_pedestrian_profile {
        req_builder = req_builder.query(&[("pedestrianProfile", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_pedestrian_speed {
        req_builder = req_builder.query(&[("pedestrianSpeed", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_cycling_speed {
        req_builder = req_builder.query(&[("cyclingSpeed", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_elevation_costs {
        req_builder = req_builder.query(&[("elevationCosts", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_transit_modes {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("transitModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("transitModes", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_pre_transit_modes {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("preTransitModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("preTransitModes", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_post_transit_modes {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("postTransitModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("postTransitModes", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_require_bike_transport {
        req_builder = req_builder.query(&[("requireBikeTransport", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_require_car_transport {
        req_builder = req_builder.query(&[("requireCarTransport", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_pre_transit_time {
        req_builder = req_builder.query(&[("maxPreTransitTime", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_post_transit_time {
        req_builder = req_builder.query(&[("maxPostTransitTime", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();
    let content_type = resp
        .headers()
        .get("content-type")
        .and_then(|v| v.to_str().ok())
        .unwrap_or("application/octet-stream");
    let content_type = super::ContentType::from(content_type);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        match content_type {
            ContentType::Json => serde_json::from_str(&content).map_err(Error::from),
            ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::Reachable`"))),
            ContentType::Unsupported(unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{unknown_type}` content type response that cannot be converted to `models::Reachable`")))),
        }
    } else {
        let content = resp.text().await?;
        let entity: Option<OneToAllError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

pub async fn one_to_many(configuration: &configuration::Configuration, one: &str, many: Vec<String>, mode: models::Mode, max: f64, max_matching_distance: f64, arrive_by: bool, elevation_costs: Option<models::ElevationCosts>) -> Result<Vec<models::Duration>, Error<OneToManyError>> {
    // add a prefix to parameters to efficiently prevent name collisions
    let p_query_one = one;
    let p_query_many = many;
    let p_query_mode = mode;
    let p_query_max = max;
    let p_query_max_matching_distance = max_matching_distance;
    let p_query_arrive_by = arrive_by;
    let p_query_elevation_costs = elevation_costs;

    let uri_str = format!("{}/api/v1/one-to-many", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    req_builder = req_builder.query(&[("one", &p_query_one.to_string())]);
    req_builder = match "csv" {
        "multi" => req_builder.query(&p_query_many.into_iter().map(|p| ("many".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
        _ => req_builder.query(&[("many", &p_query_many.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
    };
    req_builder = req_builder.query(&[("mode", &p_query_mode.to_string())]);
    req_builder = req_builder.query(&[("max", &p_query_max.to_string())]);
    req_builder = req_builder.query(&[("maxMatchingDistance", &p_query_max_matching_distance.to_string())]);
    if let Some(ref param_value) = p_query_elevation_costs {
        req_builder = req_builder.query(&[("elevationCosts", &param_value.to_string())]);
    }
    req_builder = req_builder.query(&[("arriveBy", &p_query_arrive_by.to_string())]);
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();
    let content_type = resp
        .headers()
        .get("content-type")
        .and_then(|v| v.to_str().ok())
        .unwrap_or("application/octet-stream");
    let content_type = super::ContentType::from(content_type);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        match content_type {
            ContentType::Json => serde_json::from_str(&content).map_err(Error::from),
            ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `Vec&lt;models::Duration&gt;`"))),
            ContentType::Unsupported(unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{unknown_type}` content type response that cannot be converted to `Vec&lt;models::Duration&gt;`")))),
        }
    } else {
        let content = resp.text().await?;
        let entity: Option<OneToManyError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

pub async fn plan(configuration: &configuration::Configuration, from_place: &str, to_place: &str, detailed_transfers: bool, via: Option<Vec<String>>, via_minimum_stay: Option<Vec<i32>>, time: Option<String>, max_transfers: Option<i32>, max_travel_time: Option<i32>, min_transfer_time: Option<i32>, additional_transfer_time: Option<i32>, transfer_time_factor: Option<f64>, max_matching_distance: Option<f64>, pedestrian_profile: Option<models::PedestrianProfile>, pedestrian_speed: Option<f64>, cycling_speed: Option<f64>, elevation_costs: Option<models::ElevationCosts>, use_routed_transfers: Option<bool>, join_interlined_legs: Option<bool>, transit_modes: Option<Vec<models::Mode>>, direct_modes: Option<Vec<models::Mode>>, pre_transit_modes: Option<Vec<models::Mode>>, post_transit_modes: Option<Vec<models::Mode>>, direct_rental_form_factors: Option<Vec<models::RentalFormFactor>>, pre_transit_rental_form_factors: Option<Vec<models::RentalFormFactor>>, post_transit_rental_form_factors: Option<Vec<models::RentalFormFactor>>, direct_rental_propulsion_types: Option<Vec<models::RentalPropulsionType>>, pre_transit_rental_propulsion_types: Option<Vec<models::RentalPropulsionType>>, post_transit_rental_propulsion_types: Option<Vec<models::RentalPropulsionType>>, direct_rental_providers: Option<Vec<String>>, direct_rental_provider_groups: Option<Vec<String>>, pre_transit_rental_providers: Option<Vec<String>>, pre_transit_rental_provider_groups: Option<Vec<String>>, post_transit_rental_providers: Option<Vec<String>>, post_transit_rental_provider_groups: Option<Vec<String>>, ignore_direct_rental_return_constraints: Option<bool>, ignore_pre_transit_rental_return_constraints: Option<bool>, ignore_post_transit_rental_return_constraints: Option<bool>, num_itineraries: Option<i32>, max_itineraries: Option<i32>, page_cursor: Option<&str>, timetable_view: Option<bool>, arrive_by: Option<bool>, search_window: Option<i32>, require_bike_transport: Option<bool>, require_car_transport: Option<bool>, max_pre_transit_time: Option<i32>, max_post_transit_time: Option<i32>, max_direct_time: Option<i32>, fastest_direct_factor: Option<f64>, timeout: Option<i32>, passengers: Option<i32>, luggage: Option<i32>, slow_direct: Option<bool>, fastest_slow_direct_factor: Option<f64>, with_fares: Option<bool>, with_scheduled_skipped_stops: Option<bool>, language: Option<Vec<String>>, algorithm: Option<&str>) -> Result<models::Plan200Response, Error<PlanError>> {
    // add a prefix to parameters to efficiently prevent name collisions
    let p_query_from_place = from_place;
    let p_query_to_place = to_place;
    let p_query_detailed_transfers = detailed_transfers;
    let p_query_via = via;
    let p_query_via_minimum_stay = via_minimum_stay;
    let p_query_time = time;
    let p_query_max_transfers = max_transfers;
    let p_query_max_travel_time = max_travel_time;
    let p_query_min_transfer_time = min_transfer_time;
    let p_query_additional_transfer_time = additional_transfer_time;
    let p_query_transfer_time_factor = transfer_time_factor;
    let p_query_max_matching_distance = max_matching_distance;
    let p_query_pedestrian_profile = pedestrian_profile;
    let p_query_pedestrian_speed = pedestrian_speed;
    let p_query_cycling_speed = cycling_speed;
    let p_query_elevation_costs = elevation_costs;
    let p_query_use_routed_transfers = use_routed_transfers;
    let p_query_join_interlined_legs = join_interlined_legs;
    let p_query_transit_modes = transit_modes;
    let p_query_direct_modes = direct_modes;
    let p_query_pre_transit_modes = pre_transit_modes;
    let p_query_post_transit_modes = post_transit_modes;
    let p_query_direct_rental_form_factors = direct_rental_form_factors;
    let p_query_pre_transit_rental_form_factors = pre_transit_rental_form_factors;
    let p_query_post_transit_rental_form_factors = post_transit_rental_form_factors;
    let p_query_direct_rental_propulsion_types = direct_rental_propulsion_types;
    let p_query_pre_transit_rental_propulsion_types = pre_transit_rental_propulsion_types;
    let p_query_post_transit_rental_propulsion_types = post_transit_rental_propulsion_types;
    let p_query_direct_rental_providers = direct_rental_providers;
    let p_query_direct_rental_provider_groups = direct_rental_provider_groups;
    let p_query_pre_transit_rental_providers = pre_transit_rental_providers;
    let p_query_pre_transit_rental_provider_groups = pre_transit_rental_provider_groups;
    let p_query_post_transit_rental_providers = post_transit_rental_providers;
    let p_query_post_transit_rental_provider_groups = post_transit_rental_provider_groups;
    let p_query_ignore_direct_rental_return_constraints = ignore_direct_rental_return_constraints;
    let p_query_ignore_pre_transit_rental_return_constraints = ignore_pre_transit_rental_return_constraints;
    let p_query_ignore_post_transit_rental_return_constraints = ignore_post_transit_rental_return_constraints;
    let p_query_num_itineraries = num_itineraries;
    let p_query_max_itineraries = max_itineraries;
    let p_query_page_cursor = page_cursor;
    let p_query_timetable_view = timetable_view;
    let p_query_arrive_by = arrive_by;
    let p_query_search_window = search_window;
    let p_query_require_bike_transport = require_bike_transport;
    let p_query_require_car_transport = require_car_transport;
    let p_query_max_pre_transit_time = max_pre_transit_time;
    let p_query_max_post_transit_time = max_post_transit_time;
    let p_query_max_direct_time = max_direct_time;
    let p_query_fastest_direct_factor = fastest_direct_factor;
    let p_query_timeout = timeout;
    let p_query_passengers = passengers;
    let p_query_luggage = luggage;
    let p_query_slow_direct = slow_direct;
    let p_query_fastest_slow_direct_factor = fastest_slow_direct_factor;
    let p_query_with_fares = with_fares;
    let p_query_with_scheduled_skipped_stops = with_scheduled_skipped_stops;
    let p_query_language = language;
    let p_query_algorithm = algorithm;

    let uri_str = format!("{}/api/v5/plan", configuration.base_path);
    let mut req_builder = configuration.client.request(reqwest::Method::GET, &uri_str);

    req_builder = req_builder.query(&[("fromPlace", &p_query_from_place.to_string())]);
    req_builder = req_builder.query(&[("toPlace", &p_query_to_place.to_string())]);
    if let Some(ref param_value) = p_query_via {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("via".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("via", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_via_minimum_stay {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("viaMinimumStay".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("viaMinimumStay", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_time {
        req_builder = req_builder.query(&[("time", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_transfers {
        req_builder = req_builder.query(&[("maxTransfers", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_travel_time {
        req_builder = req_builder.query(&[("maxTravelTime", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_min_transfer_time {
        req_builder = req_builder.query(&[("minTransferTime", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_additional_transfer_time {
        req_builder = req_builder.query(&[("additionalTransferTime", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_transfer_time_factor {
        req_builder = req_builder.query(&[("transferTimeFactor", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_matching_distance {
        req_builder = req_builder.query(&[("maxMatchingDistance", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_pedestrian_profile {
        req_builder = req_builder.query(&[("pedestrianProfile", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_pedestrian_speed {
        req_builder = req_builder.query(&[("pedestrianSpeed", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_cycling_speed {
        req_builder = req_builder.query(&[("cyclingSpeed", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_elevation_costs {
        req_builder = req_builder.query(&[("elevationCosts", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_use_routed_transfers {
        req_builder = req_builder.query(&[("useRoutedTransfers", &param_value.to_string())]);
    }
    req_builder = req_builder.query(&[("detailedTransfers", &p_query_detailed_transfers.to_string())]);
    if let Some(ref param_value) = p_query_join_interlined_legs {
        req_builder = req_builder.query(&[("joinInterlinedLegs", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_transit_modes {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("transitModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("transitModes", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_direct_modes {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("directModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("directModes", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_pre_transit_modes {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("preTransitModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("preTransitModes", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_post_transit_modes {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("postTransitModes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("postTransitModes", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_direct_rental_form_factors {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("directRentalFormFactors".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("directRentalFormFactors", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_pre_transit_rental_form_factors {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("preTransitRentalFormFactors".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("preTransitRentalFormFactors", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_post_transit_rental_form_factors {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("postTransitRentalFormFactors".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("postTransitRentalFormFactors", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_direct_rental_propulsion_types {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("directRentalPropulsionTypes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("directRentalPropulsionTypes", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_pre_transit_rental_propulsion_types {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("preTransitRentalPropulsionTypes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("preTransitRentalPropulsionTypes", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_post_transit_rental_propulsion_types {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("postTransitRentalPropulsionTypes".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("postTransitRentalPropulsionTypes", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_direct_rental_providers {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("directRentalProviders".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("directRentalProviders", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_direct_rental_provider_groups {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("directRentalProviderGroups".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("directRentalProviderGroups", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_pre_transit_rental_providers {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("preTransitRentalProviders".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("preTransitRentalProviders", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_pre_transit_rental_provider_groups {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("preTransitRentalProviderGroups".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("preTransitRentalProviderGroups", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_post_transit_rental_providers {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("postTransitRentalProviders".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("postTransitRentalProviders", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_post_transit_rental_provider_groups {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("postTransitRentalProviderGroups".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("postTransitRentalProviderGroups", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_ignore_direct_rental_return_constraints {
        req_builder = req_builder.query(&[("ignoreDirectRentalReturnConstraints", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_ignore_pre_transit_rental_return_constraints {
        req_builder = req_builder.query(&[("ignorePreTransitRentalReturnConstraints", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_ignore_post_transit_rental_return_constraints {
        req_builder = req_builder.query(&[("ignorePostTransitRentalReturnConstraints", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_num_itineraries {
        req_builder = req_builder.query(&[("numItineraries", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_itineraries {
        req_builder = req_builder.query(&[("maxItineraries", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_page_cursor {
        req_builder = req_builder.query(&[("pageCursor", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_timetable_view {
        req_builder = req_builder.query(&[("timetableView", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_arrive_by {
        req_builder = req_builder.query(&[("arriveBy", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_search_window {
        req_builder = req_builder.query(&[("searchWindow", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_require_bike_transport {
        req_builder = req_builder.query(&[("requireBikeTransport", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_require_car_transport {
        req_builder = req_builder.query(&[("requireCarTransport", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_pre_transit_time {
        req_builder = req_builder.query(&[("maxPreTransitTime", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_post_transit_time {
        req_builder = req_builder.query(&[("maxPostTransitTime", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_max_direct_time {
        req_builder = req_builder.query(&[("maxDirectTime", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_fastest_direct_factor {
        req_builder = req_builder.query(&[("fastestDirectFactor", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_timeout {
        req_builder = req_builder.query(&[("timeout", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_passengers {
        req_builder = req_builder.query(&[("passengers", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_luggage {
        req_builder = req_builder.query(&[("luggage", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_slow_direct {
        req_builder = req_builder.query(&[("slowDirect", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_fastest_slow_direct_factor {
        req_builder = req_builder.query(&[("fastestSlowDirectFactor", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_with_fares {
        req_builder = req_builder.query(&[("withFares", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_with_scheduled_skipped_stops {
        req_builder = req_builder.query(&[("withScheduledSkippedStops", &param_value.to_string())]);
    }
    if let Some(ref param_value) = p_query_language {
        req_builder = match "csv" {
            "multi" => req_builder.query(&param_value.into_iter().map(|p| ("language".to_owned(), p.to_string())).collect::<Vec<(std::string::String, std::string::String)>>()),
            _ => req_builder.query(&[("language", &param_value.into_iter().map(|p| p.to_string()).collect::<Vec<String>>().join(",").to_string())]),
        };
    }
    if let Some(ref param_value) = p_query_algorithm {
        req_builder = req_builder.query(&[("algorithm", &param_value.to_string())]);
    }
    if let Some(ref user_agent) = configuration.user_agent {
        req_builder = req_builder.header(reqwest::header::USER_AGENT, user_agent.clone());
    }

    let req = req_builder.build()?;
    let resp = configuration.client.execute(req).await?;

    let status = resp.status();
    let content_type = resp
        .headers()
        .get("content-type")
        .and_then(|v| v.to_str().ok())
        .unwrap_or("application/octet-stream");
    let content_type = super::ContentType::from(content_type);

    if !status.is_client_error() && !status.is_server_error() {
        let content = resp.text().await?;
        match content_type {
            ContentType::Json => serde_json::from_str(&content).map_err(Error::from),
            ContentType::Text => return Err(Error::from(serde_json::Error::custom("Received `text/plain` content type response that cannot be converted to `models::Plan200Response`"))),
            ContentType::Unsupported(unknown_type) => return Err(Error::from(serde_json::Error::custom(format!("Received `{unknown_type}` content type response that cannot be converted to `models::Plan200Response`")))),
        }
    } else {
        let content = resp.text().await?;
        let entity: Option<PlanError> = serde_json::from_str(&content).ok();
        Err(Error::ResponseError(ResponseContent { status, content, entity }))
    }
}

