/*
 * MOTIS API
 *
 * This is the MOTIS routing API.
 *
 * The version of the OpenAPI document: v1
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// Footpath : footpath from one location to another
#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct Footpath {
    #[serde(rename = "to")]
    pub to: Box<models::Place>,
    /// optional; missing if the GTFS did not contain a footpath footpath duration in minutes according to GTFS (+heuristics) 
    #[serde(rename = "default", skip_serializing_if = "Option::is_none")]
    pub default: Option<f64>,
    /// optional; missing if no path was found (timetable / osr) footpath duration in minutes for the foot profile 
    #[serde(rename = "foot", skip_serializing_if = "Option::is_none")]
    pub foot: Option<f64>,
    /// optional; missing if no path was found with foot routing footpath duration in minutes for the foot profile 
    #[serde(rename = "footRouted", skip_serializing_if = "Option::is_none")]
    pub foot_routed: Option<f64>,
    /// optional; missing if no path was found with the wheelchair profile  footpath duration in minutes for the wheelchair profile 
    #[serde(rename = "wheelchair", skip_serializing_if = "Option::is_none")]
    pub wheelchair: Option<f64>,
    /// optional; missing if no path was found with the wheelchair profile true if the wheelchair path uses an elevator 
    #[serde(rename = "wheelchairUsesElevator", skip_serializing_if = "Option::is_none")]
    pub wheelchair_uses_elevator: Option<bool>,
}

impl Footpath {
    /// footpath from one location to another
    pub fn new(to: models::Place) -> Footpath {
        Footpath {
            to: Box::new(to),
            default: None,
            foot: None,
            foot_routed: None,
            wheelchair: None,
            wheelchair_uses_elevator: None,
        }
    }
}

