/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

/// 
#[derive(Clone, Copy, Debug, Eq, PartialEq, Ord, PartialOrd, Hash, Serialize, Deserialize)]
pub enum RentalPropulsionType {
    #[serde(rename = "HUMAN")]
    Human,
    #[serde(rename = "ELECTRIC_ASSIST")]
    ElectricAssist,
    #[serde(rename = "ELECTRIC")]
    Electric,
    #[serde(rename = "COMBUSTION")]
    Combustion,
    #[serde(rename = "COMBUSTION_DIESEL")]
    CombustionDiesel,
    #[serde(rename = "HYBRID")]
    Hybrid,
    #[serde(rename = "PLUG_IN_HYBRID")]
    PlugInHybrid,
    #[serde(rename = "HYDROGEN_FUEL_CELL")]
    HydrogenFuelCell,

}

impl std::fmt::Display for RentalPropulsionType {
    fn fmt(&self, f: &mut std::fmt::Formatter) -> std::fmt::Result {
        match self {
            Self::Human => write!(f, "HUMAN"),
            Self::ElectricAssist => write!(f, "ELECTRIC_ASSIST"),
            Self::Electric => write!(f, "ELECTRIC"),
            Self::Combustion => write!(f, "COMBUSTION"),
            Self::CombustionDiesel => write!(f, "COMBUSTION_DIESEL"),
            Self::Hybrid => write!(f, "HYBRID"),
            Self::PlugInHybrid => write!(f, "PLUG_IN_HYBRID"),
            Self::HydrogenFuelCell => write!(f, "HYDROGEN_FUEL_CELL"),
        }
    }
}

impl Default for RentalPropulsionType {
    fn default() -> RentalPropulsionType {
        Self::Human
    }
}

