/*
 * MOTIS API
 *
 * This is the MOTIS routing API.  Overview of MOTIS API versions:  MOTIS 0.x - deprecated/discontinued  MOTIS 2.x - current, providing:  * /api/v5/{plan,trip,stoptimes,map/trips} renamed METRO mode to SUBURBAN, AREAL_LIFT to AERIAL_LIFT; since MOTIS 2.5.0 * /api/v4/{plan,trip,stoptimes,map/trips} new displayName property, routeShortName only contains actual route short name from source; since MOTIS 2.2.0 * /api/v3/plan with correct maxTransfers API parameter (transfers actually corresponding to number of changes between transit legs (and not to number of transit legs), i.e. maxTransfers=0 returns direct public transit connections, as expected); since MOTIS 2.0.84  * /api/v2/{plan,trip} returns Google polylines with precision=6; since MOTIS 2.0.60 * /api/v1/{plan,trip} returns Google polylines with precision=7 (not defined for |longitude|>107) * /api/v1/_* all other endpoints  If you use the JS client lib https://www.npmjs.com/package/@motis-project/motis-client, endpoint versions will be taken into account automatically (i.e. the newest one available will be used). 
 *
 * The version of the OpenAPI document: v5
 * Contact: felix@triptix.tech
 * Generated by: https://openapi-generator.tech
 */

use crate::models;
use serde::{Deserialize, Serialize};

#[derive(Clone, Default, Debug, PartialEq, Serialize, Deserialize)]
pub struct RentalProvider {
    /// Unique identifier of the rental provider
    #[serde(rename = "id")]
    pub id: String,
    /// Name of the provider to be displayed to customers
    #[serde(rename = "name")]
    pub name: String,
    /// Id of the rental provider group this provider belongs to
    #[serde(rename = "groupId")]
    pub group_id: String,
    /// Name of the system operator
    #[serde(rename = "operator", skip_serializing_if = "Option::is_none")]
    pub operator: Option<String>,
    /// URL of the vehicle share system
    #[serde(rename = "url", skip_serializing_if = "Option::is_none")]
    pub url: Option<String>,
    /// URL where a customer can purchase a membership
    #[serde(rename = "purchaseUrl", skip_serializing_if = "Option::is_none")]
    pub purchase_url: Option<String>,
    /// Color associated with this provider, in hexadecimal RGB format (e.g. \"#FF0000\" for red). Can be empty. 
    #[serde(rename = "color", skip_serializing_if = "Option::is_none")]
    pub color: Option<String>,
    /// Bounding box of the area covered by this rental provider, [west, south, east, north] as [lon, lat, lon, lat] 
    #[serde(rename = "bbox")]
    pub bbox: Vec<f64>,
    #[serde(rename = "vehicleTypes")]
    pub vehicle_types: Vec<models::RentalVehicleType>,
    /// List of form factors offered by this provider
    #[serde(rename = "formFactors")]
    pub form_factors: Vec<models::RentalFormFactor>,
    #[serde(rename = "defaultRestrictions")]
    pub default_restrictions: Box<models::RentalZoneRestrictions>,
    #[serde(rename = "globalGeofencingRules")]
    pub global_geofencing_rules: Vec<models::RentalZoneRestrictions>,
}

impl RentalProvider {
    pub fn new(id: String, name: String, group_id: String, bbox: Vec<f64>, vehicle_types: Vec<models::RentalVehicleType>, form_factors: Vec<models::RentalFormFactor>, default_restrictions: models::RentalZoneRestrictions, global_geofencing_rules: Vec<models::RentalZoneRestrictions>) -> RentalProvider {
        RentalProvider {
            id,
            name,
            group_id,
            operator: None,
            url: None,
            purchase_url: None,
            color: None,
            bbox,
            vehicle_types,
            form_factors,
            default_restrictions: Box::new(default_restrictions),
            global_geofencing_rules,
        }
    }
}

