/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import net.sourceforge.argparse4j.impl.Arguments;
import net.sourceforge.argparse4j.inf.ArgumentAction;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.RateLimitErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.CaptchaRequiredException;
import org.asamk.signal.manager.api.NonNormalizedPhoneNumberException;
import org.asamk.signal.manager.api.NotPrimaryDeviceException;
import org.asamk.signal.manager.api.RateLimitException;
import org.asamk.signal.manager.api.VerificationMethodNotAvailableException;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.util.CommandUtil;

public class StartChangeNumberCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "startChangeNumber";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Change account to a new phone number with SMS or voice verification.");
        subparser.addArgument(new String[]{"number"}).help("The new phone number in E164 format.").required(true);
        subparser.addArgument(new String[]{"-v", "--voice"}).help("The verification should be done over voice, not SMS.").action((ArgumentAction)Arguments.storeTrue());
        subparser.addArgument(new String[]{"--captcha"}).help("The captcha token, required if change number failed with a captcha required error.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        String newNumber = ns.getString("number");
        boolean voiceVerification = Boolean.TRUE.equals(ns.getBoolean("voice"));
        String captcha = ns.getString("captcha");
        try {
            m.startChangeNumber(newNumber, voiceVerification, captcha);
        }
        catch (RateLimitException e) {
            String message = CommandUtil.getRateLimitMessage(e);
            throw new RateLimitErrorException(message, e);
        }
        catch (CaptchaRequiredException e) {
            String message = CommandUtil.getCaptchaRequiredMessage(e, captcha != null);
            throw new UserErrorException(message);
        }
        catch (NonNormalizedPhoneNumberException e) {
            throw new UserErrorException("Failed to change number: " + e.getMessage(), e);
        }
        catch (NotPrimaryDeviceException e) {
            throw new UserErrorException("This command doesn't work on linked devices.");
        }
        catch (IOException e) {
            throw new IOErrorException("Failed to change number: %s (%s)".formatted(e.getMessage(), e.getClass().getSimpleName()), e);
        }
        catch (VerificationMethodNotAvailableException e) {
            throw new UserErrorException("Failed to register: " + e.getMessage() + (voiceVerification ? ": Before requesting voice verification you need to request SMS verification and wait a minute." : ""), e);
        }
    }
}

