/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.dbus;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Supplier;
import org.asamk.Signal;
import org.asamk.signal.dbus.DbusProperty;

public class DbusInterfacePropertiesHandler {
    private final String interfaceName;
    private final List<DbusProperty<?>> properties;

    public DbusInterfacePropertiesHandler(String interfaceName, List<DbusProperty<?>> properties) {
        this.interfaceName = interfaceName;
        this.properties = properties;
    }

    public String getInterfaceName() {
        return this.interfaceName;
    }

    private <T> DbusProperty<T> findProperty(String propertyName) {
        Optional<DbusProperty> property = this.properties.stream().filter(p -> p.getName().equals(propertyName)).findFirst();
        if (property.isEmpty()) {
            throw new Signal.Error.Failure("Property not found");
        }
        return property.get();
    }

    <T> Consumer<T> getSetter(String propertyName) {
        return this.findProperty(propertyName).getSetter();
    }

    <T> Supplier<T> getGetter(String propertyName) {
        return this.findProperty(propertyName).getGetter();
    }

    Collection<DbusProperty<?>> getProperties() {
        return this.properties;
    }
}

