/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.util;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class Util {
    public static byte[] join(byte[] ... input) {
        try {
            ByteArrayOutputStream baos = new ByteArrayOutputStream();
            for (byte[] part : input) {
                baos.write(part);
            }
            return baos.toByteArray();
        }
        catch (IOException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static String join(Collection<String> list, String delimiter) {
        StringBuilder result2 = new StringBuilder();
        int i = 0;
        for (String item : list) {
            result2.append(item);
            if (++i >= list.size()) continue;
            result2.append(delimiter);
        }
        return result2.toString();
    }

    public static byte[][] split(byte[] input, int firstLength, int secondLength) {
        byte[][] parts = new byte[2][];
        parts[0] = new byte[firstLength];
        System.arraycopy(input, 0, parts[0], 0, firstLength);
        parts[1] = new byte[secondLength];
        System.arraycopy(input, firstLength, parts[1], 0, secondLength);
        return parts;
    }

    public static byte[] trim(byte[] input, int length) {
        byte[] result2 = new byte[length];
        System.arraycopy(input, 0, result2, 0, result2.length);
        return result2;
    }

    public static boolean isEmpty(String value) {
        return value == null || value.trim().length() == 0;
    }

    public static byte[] getSecretBytes(int size) {
        byte[] secret = new byte[size];
        new SecureRandom().nextBytes(secret);
        return secret;
    }

    public static byte[] getRandomLengthSecretBytes(int maxSize) {
        SecureRandom secureRandom = new SecureRandom();
        byte[] result2 = new byte[secureRandom.nextInt(maxSize) + 1];
        secureRandom.nextBytes(result2);
        return result2;
    }

    public static byte[] readFullyAsBytes(InputStream in) throws IOException {
        int read;
        ByteArrayOutputStream bout = new ByteArrayOutputStream();
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            bout.write(buffer, 0, read);
        }
        in.close();
        return bout.toByteArray();
    }

    public static String readFully(InputStream in) throws IOException {
        return new String(Util.readFullyAsBytes(in));
    }

    public static void readFully(InputStream in, byte[] buffer) throws IOException {
        int read;
        int offset = 0;
        while ((read = in.read(buffer, offset, buffer.length - offset)) + offset < buffer.length) {
            offset += read;
        }
    }

    public static void copy(InputStream in, OutputStream out) throws IOException {
        int read;
        byte[] buffer = new byte[4096];
        while ((read = in.read(buffer)) != -1) {
            out.write(buffer, 0, read);
        }
        in.close();
    }

    public static void sleep(long millis) {
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static void wait(Object lock, long millis) {
        try {
            lock.wait(millis);
        }
        catch (InterruptedException e) {
            throw new AssertionError((Object)e);
        }
    }

    public static int toIntExact(long value) {
        if ((long)((int)value) != value) {
            throw new ArithmeticException("integer overflow");
        }
        return (int)value;
    }

    public static <T> List<T> immutableList(T ... elements) {
        return Collections.unmodifiableList(Arrays.asList((Object[])elements.clone()));
    }

    public static int parseInt(String integer, int defaultValue) {
        try {
            return Integer.parseInt(integer);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }

    public static long parseLong(String longString, long defaultValue) {
        try {
            return Long.parseLong(longString);
        }
        catch (NumberFormatException e) {
            return defaultValue;
        }
    }
}

