/*
 * Decompiled with CFR 0.152.
 */
package org.apache.karaf.config.command;

import java.util.Collection;
import org.apache.felix.utils.properties.TypedProperties;
import org.apache.karaf.config.command.ConfigPropertyCommandSupport;
import org.apache.karaf.config.command.completers.ConfigurationPropertyCompleter;
import org.apache.karaf.shell.api.action.Argument;
import org.apache.karaf.shell.api.action.Command;
import org.apache.karaf.shell.api.action.Completion;
import org.apache.karaf.shell.api.action.lifecycle.Service;

@Command(scope="config", name="property-append", description="Appends the given value to an existing property or creates the property with the specified name and value.")
@Service
public class PropAppendCommand
extends ConfigPropertyCommandSupport {
    @Argument(index=0, name="name", description="The name of the property", required=true, multiValued=false)
    @Completion(value=ConfigurationPropertyCompleter.class)
    String prop;
    @Argument(index=1, name="value", description="The value to append to the property", required=true, multiValued=false)
    String value;

    @Override
    public void propertyAction(TypedProperties props) {
        Object currentValue = props.get((Object)this.prop);
        if (currentValue == null) {
            props.put(this.prop, (Object)this.value);
        } else if (currentValue instanceof String) {
            props.put(this.prop, (Object)(currentValue + this.value));
        } else if (currentValue instanceof Collection) {
            ((Collection)currentValue).add(this.value);
        } else {
            System.err.println("Append Failed: current value is not a String.");
        }
    }
}

