/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.californium.core;

import java.util.Collection;
import java.util.List;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.Executor;
import java.util.concurrent.Semaphore;
import java.util.concurrent.locks.ReentrantLock;
import org.eclipse.californium.core.coap.CoAP;
import org.eclipse.californium.core.coap.Response;
import org.eclipse.californium.core.network.Exchange;
import org.eclipse.californium.core.observe.ObserveNotificationOrderer;
import org.eclipse.californium.core.observe.ObserveRelation;
import org.eclipse.californium.core.observe.ObserveRelationFilter;
import org.eclipse.californium.core.server.resources.CoapExchange;
import org.eclipse.californium.core.server.resources.ObservableResource;
import org.eclipse.californium.core.server.resources.Resource;
import org.eclipse.californium.core.server.resources.ResourceAttributes;
import org.eclipse.californium.core.server.resources.ResourceObserver;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CoapResource
implements Resource,
ObservableResource {
    private static final Logger LOGGER = LoggerFactory.getLogger(CoapResource.class);
    private volatile ResourceAttributes attributes;
    private final ReentrantLock recursionProtection = new ReentrantLock();
    private String name;
    private String path;
    private boolean visible;
    private boolean observable;
    private ConcurrentMap<String, Resource> children;
    private Resource parent;
    private CoAP.Type observeType = null;
    private final List<ResourceObserver> observers;
    private final List<ObserveRelation> observeRelations;
    private final ObserveNotificationOrderer notificationOrderer;

    public CoapResource(String name) {
        this(name, true);
    }

    public CoapResource(String name, boolean visible) {
        if (name == null) {
            throw new NullPointerException("name must not be null!");
        }
        if (name.contains("/")) {
            throw new IllegalArgumentException("'/' in '" + name + "' is not supported by the implementation!");
        }
        this.name = name;
        this.path = "";
        this.visible = visible;
        this.attributes = new ResourceAttributes();
        this.children = new ConcurrentHashMap<String, Resource>();
        this.observers = new CopyOnWriteArrayList<ResourceObserver>();
        this.observeRelations = new CopyOnWriteArrayList<ObserveRelation>();
        this.notificationOrderer = new ObserveNotificationOrderer();
    }

    @Override
    public void handleRequest(Exchange exchange) {
        CoAP.Code code = exchange.getRequest().getCode();
        switch (code) {
            case GET: {
                this.handleGET(new CoapExchange(exchange));
                break;
            }
            case POST: {
                this.handlePOST(new CoapExchange(exchange));
                break;
            }
            case PUT: {
                this.handlePUT(new CoapExchange(exchange));
                break;
            }
            case DELETE: {
                this.handleDELETE(new CoapExchange(exchange));
                break;
            }
            case FETCH: {
                this.handleFETCH(new CoapExchange(exchange));
                break;
            }
            case PATCH: {
                this.handlePATCH(new CoapExchange(exchange));
                break;
            }
            case IPATCH: {
                this.handleIPATCH(new CoapExchange(exchange));
                break;
            }
            default: {
                exchange.sendResponse(new Response(CoAP.ResponseCode.METHOD_NOT_ALLOWED, true));
            }
        }
    }

    public void handleGET(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    public void handlePOST(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    public void handlePUT(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    public void handleDELETE(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    public void handleFETCH(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    public void handlePATCH(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    public void handleIPATCH(CoapExchange exchange) {
        exchange.respond(CoAP.ResponseCode.METHOD_NOT_ALLOWED);
    }

    @Override
    public CoAP.Type getObserveType() {
        return this.observeType;
    }

    @Override
    public int getNotificationSequenceNumber() {
        return this.notificationOrderer.getCurrent();
    }

    @Override
    public synchronized void add(Resource child) {
        Resource previous;
        if (child.getName() == null) {
            throw new NullPointerException("Child must have a name");
        }
        Resource parent = child.getParent();
        if (parent == this && parent.getChild(child.getName()) == child) {
            return;
        }
        if (parent != null) {
            parent.delete(child);
        }
        if ((previous = (Resource)this.children.get(child.getName())) != null && previous != child) {
            this.delete(previous);
        }
        this.children.put(child.getName(), child);
        child.setParent(this);
        for (ResourceObserver obs : this.observers) {
            obs.addedChild(child);
        }
    }

    public synchronized CoapResource add(CoapResource child) {
        this.add((Resource)child);
        return this;
    }

    public synchronized CoapResource add(CoapResource ... children) {
        for (CoapResource child : children) {
            this.add(child);
        }
        return this;
    }

    @Override
    public synchronized boolean delete(Resource child) {
        if (child.getParent() == this && this.children.remove(child.getName(), child)) {
            child.setParent(null);
            child.setPath(null);
            for (ResourceObserver obs : this.observers) {
                obs.removedChild(child);
            }
            return true;
        }
        return false;
    }

    public synchronized void delete() {
        Resource parent = this.getParent();
        if (parent != null) {
            parent.delete(this);
        }
        if (this.isObservable()) {
            this.clearAndNotifyObserveRelations(CoAP.ResponseCode.NOT_FOUND);
        }
    }

    public void clearObserveRelations() {
        this.clearAndNotifyObserveRelations(null, null);
    }

    public void clearAndNotifyObserveRelations(CoAP.ResponseCode code) {
        this.clearAndNotifyObserveRelations(null, code);
    }

    public void clearAndNotifyObserveRelations(final ObserveRelationFilter filter, final CoAP.ResponseCode code) {
        if (code != null && code.isSuccess()) {
            throw new IllegalArgumentException("Only error-responses are supported, not a " + (Object)((Object)code) + "/" + code.name() + "!");
        }
        for (ObserveRelation relation : this.observeRelations) {
            final Exchange exchange = relation.getExchange();
            exchange.execute(new Runnable(){

                @Override
                public void run() {
                    ObserveRelation relation = exchange.getRelation();
                    if (relation != null && relation.isEstablished()) {
                        if (code != null && (null == filter || filter.accept(relation))) {
                            Response response = new Response(code, true);
                            response.setType(CoAP.Type.CON);
                            exchange.sendResponse(response);
                        } else {
                            relation.cancel();
                        }
                    }
                }
            });
        }
    }

    @Override
    public Resource getParent() {
        return this.parent;
    }

    @Override
    public void setParent(Resource parent) {
        this.parent = parent;
        if (parent != null) {
            this.path = parent.getPath() + parent.getName() + "/";
        }
        this.adjustChildrenPath();
    }

    @Override
    public Resource getChild(String name) {
        return (Resource)this.children.get(name);
    }

    @Override
    public void addObserver(ResourceObserver observer) {
        this.observers.add(observer);
    }

    @Override
    public void removeObserver(ResourceObserver observer) {
        this.observers.remove(observer);
    }

    @Override
    public ResourceAttributes getAttributes() {
        return this.attributes;
    }

    public void setAttributes(ResourceAttributes attributes) {
        this.attributes = attributes;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public boolean isCachable() {
        return true;
    }

    @Override
    public String getPath() {
        return this.path;
    }

    @Override
    public String getURI() {
        return this.getPath() + this.getName();
    }

    @Override
    public synchronized void setPath(String path) {
        String old = this.path;
        this.path = path;
        for (ResourceObserver obs : this.observers) {
            obs.changedPath(old);
        }
        this.adjustChildrenPath();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void setName(String name) {
        if (name == null) {
            throw new NullPointerException("name must not be null!");
        }
        if (name.contains("/")) {
            throw new IllegalArgumentException("'/' in '" + name + "' is not supported by the implementation!");
        }
        String old = this.name;
        Resource parent = this.getParent();
        if (parent != null) {
            Resource resource = parent;
            synchronized (resource) {
                parent.delete(this);
                this.name = name;
                parent.add(this);
            }
        } else {
            this.name = name;
        }
        this.adjustChildrenPath();
        for (ResourceObserver obs : this.observers) {
            obs.changedName(old);
        }
    }

    private void adjustChildrenPath() {
        String childpath = this.path + this.name + "/";
        for (Resource child : this.getChildren()) {
            child.setPath(childpath);
        }
    }

    @Override
    public boolean isVisible() {
        return this.visible;
    }

    public void setVisible(boolean visible) {
        this.visible = visible;
    }

    @Override
    public boolean isObservable() {
        return this.observable;
    }

    public void setObservable(boolean observable) {
        this.observable = observable;
        if (observable) {
            this.getAttributes().setObservable();
        } else {
            this.getAttributes().clearObservable();
        }
    }

    public void setObserveType(CoAP.Type type) {
        if (type != null && type != CoAP.Type.NON && type != CoAP.Type.CON) {
            throw new IllegalArgumentException("Only CON and NON notifications are allowed or null for no changes by the framework");
        }
        this.observeType = type;
    }

    @Override
    public void addObserveRelation(ObserveRelation relation) {
        this.observeRelations.add(relation);
        LOGGER.info("successfully established observe relation between {} and resource {} ({}, size {})", new Object[]{relation.getKeyToken(), this.getURI(), relation.getExchange(), this.observeRelations.size()});
        for (ResourceObserver obs : this.observers) {
            obs.addedObserveRelation(relation);
        }
    }

    @Override
    public void removeObserveRelation(ObserveRelation relation) {
        if (this.observeRelations.remove(relation)) {
            LOGGER.info("remove observe relation between {} and resource {} ({}, size {})", new Object[]{relation.getKeyToken(), this.getURI(), relation.getExchange(), this.observeRelations.size()});
            for (ResourceObserver obs : this.observers) {
                obs.removedObserveRelation(relation);
            }
        }
    }

    @Override
    public int getObserverCount() {
        return this.observeRelations.size();
    }

    public void changed() {
        this.changed(null);
    }

    public void changed(final ObserveRelationFilter filter) {
        Executor executor = this.getExecutor();
        if (executor == null) {
            if (this.recursionProtection.isHeldByCurrentThread()) {
                throw new IllegalStateException("Recursion detected! Please call \"changed()\" using an executor.");
            }
            this.recursionProtection.lock();
            try {
                this.notifyObserverRelations(filter);
            }
            finally {
                this.recursionProtection.unlock();
            }
        } else {
            executor.execute(new Runnable(){

                @Override
                public void run() {
                    CoapResource.this.notifyObserverRelations(filter);
                }
            });
        }
    }

    protected void notifyObserverRelations(ObserveRelationFilter filter) {
        this.notificationOrderer.getNextObserveNumber();
        for (ObserveRelation relation : this.observeRelations) {
            if (null != filter && !filter.accept(relation)) continue;
            this.handleRequest(relation.getExchange());
        }
    }

    @Override
    public Collection<Resource> getChildren() {
        return this.children.values();
    }

    @Override
    public Executor getExecutor() {
        Resource parent = this.getParent();
        return parent != null ? parent.getExecutor() : null;
    }

    public void execute(Runnable task) {
        Executor executor = this.getExecutor();
        if (executor == null) {
            task.run();
        } else {
            executor.execute(task);
        }
    }

    public void executeAndWait(final Runnable task) throws InterruptedException {
        final Semaphore semaphore = new Semaphore(0);
        this.execute(new Runnable(){

            @Override
            public void run() {
                task.run();
                semaphore.release();
            }
        });
        semaphore.acquire();
    }
}

