// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

package appintegrationsservice

import (
	"fmt"

	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/awsutil"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/private/protocol"
	"github.com/aws/aws-sdk-go/private/protocol/restjson"
)

const opCreateDataIntegration = "CreateDataIntegration"

// CreateDataIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the CreateDataIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateDataIntegration for more information on using the CreateDataIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateDataIntegrationRequest method.
//    req, resp := client.CreateDataIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateDataIntegration
func (c *AppIntegrationsService) CreateDataIntegrationRequest(input *CreateDataIntegrationInput) (req *request.Request, output *CreateDataIntegrationOutput) {
	op := &request.Operation{
		Name:       opCreateDataIntegration,
		HTTPMethod: "POST",
		HTTPPath:   "/dataIntegrations",
	}

	if input == nil {
		input = &CreateDataIntegrationInput{}
	}

	output = &CreateDataIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateDataIntegration API operation for Amazon AppIntegrations Service.
//
// Creates and persists a DataIntegration resource.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation CreateDataIntegration for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ResourceQuotaExceededException
//   The allowed quota for the resource has been exceeded.
//
//   * DuplicateResourceException
//   A resource with the specified name already exists.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateDataIntegration
func (c *AppIntegrationsService) CreateDataIntegration(input *CreateDataIntegrationInput) (*CreateDataIntegrationOutput, error) {
	req, out := c.CreateDataIntegrationRequest(input)
	return out, req.Send()
}

// CreateDataIntegrationWithContext is the same as CreateDataIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateDataIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) CreateDataIntegrationWithContext(ctx aws.Context, input *CreateDataIntegrationInput, opts ...request.Option) (*CreateDataIntegrationOutput, error) {
	req, out := c.CreateDataIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opCreateEventIntegration = "CreateEventIntegration"

// CreateEventIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the CreateEventIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See CreateEventIntegration for more information on using the CreateEventIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the CreateEventIntegrationRequest method.
//    req, resp := client.CreateEventIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateEventIntegration
func (c *AppIntegrationsService) CreateEventIntegrationRequest(input *CreateEventIntegrationInput) (req *request.Request, output *CreateEventIntegrationOutput) {
	op := &request.Operation{
		Name:       opCreateEventIntegration,
		HTTPMethod: "POST",
		HTTPPath:   "/eventIntegrations",
	}

	if input == nil {
		input = &CreateEventIntegrationInput{}
	}

	output = &CreateEventIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// CreateEventIntegration API operation for Amazon AppIntegrations Service.
//
// Creates an EventIntegration, given a specified name, description, and a reference
// to an Amazon EventBridge bus in your account and a partner event source that
// pushes events to that bus. No objects are created in the your account, only
// metadata that is persisted on the EventIntegration control plane.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation CreateEventIntegration for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ResourceQuotaExceededException
//   The allowed quota for the resource has been exceeded.
//
//   * DuplicateResourceException
//   A resource with the specified name already exists.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/CreateEventIntegration
func (c *AppIntegrationsService) CreateEventIntegration(input *CreateEventIntegrationInput) (*CreateEventIntegrationOutput, error) {
	req, out := c.CreateEventIntegrationRequest(input)
	return out, req.Send()
}

// CreateEventIntegrationWithContext is the same as CreateEventIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See CreateEventIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) CreateEventIntegrationWithContext(ctx aws.Context, input *CreateEventIntegrationInput, opts ...request.Option) (*CreateEventIntegrationOutput, error) {
	req, out := c.CreateEventIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteDataIntegration = "DeleteDataIntegration"

// DeleteDataIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteDataIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteDataIntegration for more information on using the DeleteDataIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteDataIntegrationRequest method.
//    req, resp := client.DeleteDataIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteDataIntegration
func (c *AppIntegrationsService) DeleteDataIntegrationRequest(input *DeleteDataIntegrationInput) (req *request.Request, output *DeleteDataIntegrationOutput) {
	op := &request.Operation{
		Name:       opDeleteDataIntegration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/dataIntegrations/{Identifier}",
	}

	if input == nil {
		input = &DeleteDataIntegrationInput{}
	}

	output = &DeleteDataIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteDataIntegration API operation for Amazon AppIntegrations Service.
//
// Deletes the DataIntegration. Only DataIntegrations that don't have any DataIntegrationAssociations
// can be deleted. Deleting a DataIntegration also deletes the underlying Amazon
// AppFlow flow and service linked role.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation DeleteDataIntegration for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteDataIntegration
func (c *AppIntegrationsService) DeleteDataIntegration(input *DeleteDataIntegrationInput) (*DeleteDataIntegrationOutput, error) {
	req, out := c.DeleteDataIntegrationRequest(input)
	return out, req.Send()
}

// DeleteDataIntegrationWithContext is the same as DeleteDataIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteDataIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) DeleteDataIntegrationWithContext(ctx aws.Context, input *DeleteDataIntegrationInput, opts ...request.Option) (*DeleteDataIntegrationOutput, error) {
	req, out := c.DeleteDataIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opDeleteEventIntegration = "DeleteEventIntegration"

// DeleteEventIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the DeleteEventIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See DeleteEventIntegration for more information on using the DeleteEventIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the DeleteEventIntegrationRequest method.
//    req, resp := client.DeleteEventIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteEventIntegration
func (c *AppIntegrationsService) DeleteEventIntegrationRequest(input *DeleteEventIntegrationInput) (req *request.Request, output *DeleteEventIntegrationOutput) {
	op := &request.Operation{
		Name:       opDeleteEventIntegration,
		HTTPMethod: "DELETE",
		HTTPPath:   "/eventIntegrations/{Name}",
	}

	if input == nil {
		input = &DeleteEventIntegrationInput{}
	}

	output = &DeleteEventIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// DeleteEventIntegration API operation for Amazon AppIntegrations Service.
//
// Deletes the specified existing event integration. If the event integration
// is associated with clients, the request is rejected.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation DeleteEventIntegration for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/DeleteEventIntegration
func (c *AppIntegrationsService) DeleteEventIntegration(input *DeleteEventIntegrationInput) (*DeleteEventIntegrationOutput, error) {
	req, out := c.DeleteEventIntegrationRequest(input)
	return out, req.Send()
}

// DeleteEventIntegrationWithContext is the same as DeleteEventIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See DeleteEventIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) DeleteEventIntegrationWithContext(ctx aws.Context, input *DeleteEventIntegrationInput, opts ...request.Option) (*DeleteEventIntegrationOutput, error) {
	req, out := c.DeleteEventIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetDataIntegration = "GetDataIntegration"

// GetDataIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the GetDataIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetDataIntegration for more information on using the GetDataIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetDataIntegrationRequest method.
//    req, resp := client.GetDataIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetDataIntegration
func (c *AppIntegrationsService) GetDataIntegrationRequest(input *GetDataIntegrationInput) (req *request.Request, output *GetDataIntegrationOutput) {
	op := &request.Operation{
		Name:       opGetDataIntegration,
		HTTPMethod: "GET",
		HTTPPath:   "/dataIntegrations/{Identifier}",
	}

	if input == nil {
		input = &GetDataIntegrationInput{}
	}

	output = &GetDataIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetDataIntegration API operation for Amazon AppIntegrations Service.
//
// Returns information about the DataIntegration.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation GetDataIntegration for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetDataIntegration
func (c *AppIntegrationsService) GetDataIntegration(input *GetDataIntegrationInput) (*GetDataIntegrationOutput, error) {
	req, out := c.GetDataIntegrationRequest(input)
	return out, req.Send()
}

// GetDataIntegrationWithContext is the same as GetDataIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See GetDataIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) GetDataIntegrationWithContext(ctx aws.Context, input *GetDataIntegrationInput, opts ...request.Option) (*GetDataIntegrationOutput, error) {
	req, out := c.GetDataIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opGetEventIntegration = "GetEventIntegration"

// GetEventIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the GetEventIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See GetEventIntegration for more information on using the GetEventIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the GetEventIntegrationRequest method.
//    req, resp := client.GetEventIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetEventIntegration
func (c *AppIntegrationsService) GetEventIntegrationRequest(input *GetEventIntegrationInput) (req *request.Request, output *GetEventIntegrationOutput) {
	op := &request.Operation{
		Name:       opGetEventIntegration,
		HTTPMethod: "GET",
		HTTPPath:   "/eventIntegrations/{Name}",
	}

	if input == nil {
		input = &GetEventIntegrationInput{}
	}

	output = &GetEventIntegrationOutput{}
	req = c.newRequest(op, input, output)
	return
}

// GetEventIntegration API operation for Amazon AppIntegrations Service.
//
// Returns information about the event integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation GetEventIntegration for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/GetEventIntegration
func (c *AppIntegrationsService) GetEventIntegration(input *GetEventIntegrationInput) (*GetEventIntegrationOutput, error) {
	req, out := c.GetEventIntegrationRequest(input)
	return out, req.Send()
}

// GetEventIntegrationWithContext is the same as GetEventIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See GetEventIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) GetEventIntegrationWithContext(ctx aws.Context, input *GetEventIntegrationInput, opts ...request.Option) (*GetEventIntegrationOutput, error) {
	req, out := c.GetEventIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataIntegrationAssociations = "ListDataIntegrationAssociations"

// ListDataIntegrationAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataIntegrationAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataIntegrationAssociations for more information on using the ListDataIntegrationAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataIntegrationAssociationsRequest method.
//    req, resp := client.ListDataIntegrationAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations
func (c *AppIntegrationsService) ListDataIntegrationAssociationsRequest(input *ListDataIntegrationAssociationsInput) (req *request.Request, output *ListDataIntegrationAssociationsOutput) {
	op := &request.Operation{
		Name:       opListDataIntegrationAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/dataIntegrations/{Identifier}/associations",
	}

	if input == nil {
		input = &ListDataIntegrationAssociationsInput{}
	}

	output = &ListDataIntegrationAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataIntegrationAssociations API operation for Amazon AppIntegrations Service.
//
// Returns a paginated list of DataIntegration associations in the account.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListDataIntegrationAssociations for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrationAssociations
func (c *AppIntegrationsService) ListDataIntegrationAssociations(input *ListDataIntegrationAssociationsInput) (*ListDataIntegrationAssociationsOutput, error) {
	req, out := c.ListDataIntegrationAssociationsRequest(input)
	return out, req.Send()
}

// ListDataIntegrationAssociationsWithContext is the same as ListDataIntegrationAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataIntegrationAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListDataIntegrationAssociationsWithContext(ctx aws.Context, input *ListDataIntegrationAssociationsInput, opts ...request.Option) (*ListDataIntegrationAssociationsOutput, error) {
	req, out := c.ListDataIntegrationAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListDataIntegrations = "ListDataIntegrations"

// ListDataIntegrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListDataIntegrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListDataIntegrations for more information on using the ListDataIntegrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListDataIntegrationsRequest method.
//    req, resp := client.ListDataIntegrationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations
func (c *AppIntegrationsService) ListDataIntegrationsRequest(input *ListDataIntegrationsInput) (req *request.Request, output *ListDataIntegrationsOutput) {
	op := &request.Operation{
		Name:       opListDataIntegrations,
		HTTPMethod: "GET",
		HTTPPath:   "/dataIntegrations",
	}

	if input == nil {
		input = &ListDataIntegrationsInput{}
	}

	output = &ListDataIntegrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListDataIntegrations API operation for Amazon AppIntegrations Service.
//
// Returns a paginated list of DataIntegrations in the account.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListDataIntegrations for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListDataIntegrations
func (c *AppIntegrationsService) ListDataIntegrations(input *ListDataIntegrationsInput) (*ListDataIntegrationsOutput, error) {
	req, out := c.ListDataIntegrationsRequest(input)
	return out, req.Send()
}

// ListDataIntegrationsWithContext is the same as ListDataIntegrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListDataIntegrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListDataIntegrationsWithContext(ctx aws.Context, input *ListDataIntegrationsInput, opts ...request.Option) (*ListDataIntegrationsOutput, error) {
	req, out := c.ListDataIntegrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEventIntegrationAssociations = "ListEventIntegrationAssociations"

// ListEventIntegrationAssociationsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventIntegrationAssociations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventIntegrationAssociations for more information on using the ListEventIntegrationAssociations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEventIntegrationAssociationsRequest method.
//    req, resp := client.ListEventIntegrationAssociationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations
func (c *AppIntegrationsService) ListEventIntegrationAssociationsRequest(input *ListEventIntegrationAssociationsInput) (req *request.Request, output *ListEventIntegrationAssociationsOutput) {
	op := &request.Operation{
		Name:       opListEventIntegrationAssociations,
		HTTPMethod: "GET",
		HTTPPath:   "/eventIntegrations/{Name}/associations",
	}

	if input == nil {
		input = &ListEventIntegrationAssociationsInput{}
	}

	output = &ListEventIntegrationAssociationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventIntegrationAssociations API operation for Amazon AppIntegrations Service.
//
// Returns a paginated list of event integration associations in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListEventIntegrationAssociations for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrationAssociations
func (c *AppIntegrationsService) ListEventIntegrationAssociations(input *ListEventIntegrationAssociationsInput) (*ListEventIntegrationAssociationsOutput, error) {
	req, out := c.ListEventIntegrationAssociationsRequest(input)
	return out, req.Send()
}

// ListEventIntegrationAssociationsWithContext is the same as ListEventIntegrationAssociations with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventIntegrationAssociations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListEventIntegrationAssociationsWithContext(ctx aws.Context, input *ListEventIntegrationAssociationsInput, opts ...request.Option) (*ListEventIntegrationAssociationsOutput, error) {
	req, out := c.ListEventIntegrationAssociationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListEventIntegrations = "ListEventIntegrations"

// ListEventIntegrationsRequest generates a "aws/request.Request" representing the
// client's request for the ListEventIntegrations operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListEventIntegrations for more information on using the ListEventIntegrations
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListEventIntegrationsRequest method.
//    req, resp := client.ListEventIntegrationsRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations
func (c *AppIntegrationsService) ListEventIntegrationsRequest(input *ListEventIntegrationsInput) (req *request.Request, output *ListEventIntegrationsOutput) {
	op := &request.Operation{
		Name:       opListEventIntegrations,
		HTTPMethod: "GET",
		HTTPPath:   "/eventIntegrations",
	}

	if input == nil {
		input = &ListEventIntegrationsInput{}
	}

	output = &ListEventIntegrationsOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListEventIntegrations API operation for Amazon AppIntegrations Service.
//
// Returns a paginated list of event integrations in the account.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListEventIntegrations for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListEventIntegrations
func (c *AppIntegrationsService) ListEventIntegrations(input *ListEventIntegrationsInput) (*ListEventIntegrationsOutput, error) {
	req, out := c.ListEventIntegrationsRequest(input)
	return out, req.Send()
}

// ListEventIntegrationsWithContext is the same as ListEventIntegrations with the addition of
// the ability to pass a context and additional request options.
//
// See ListEventIntegrations for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListEventIntegrationsWithContext(ctx aws.Context, input *ListEventIntegrationsInput, opts ...request.Option) (*ListEventIntegrationsOutput, error) {
	req, out := c.ListEventIntegrationsRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opListTagsForResource = "ListTagsForResource"

// ListTagsForResourceRequest generates a "aws/request.Request" representing the
// client's request for the ListTagsForResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See ListTagsForResource for more information on using the ListTagsForResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the ListTagsForResourceRequest method.
//    req, resp := client.ListTagsForResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListTagsForResource
func (c *AppIntegrationsService) ListTagsForResourceRequest(input *ListTagsForResourceInput) (req *request.Request, output *ListTagsForResourceOutput) {
	op := &request.Operation{
		Name:       opListTagsForResource,
		HTTPMethod: "GET",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &ListTagsForResourceInput{}
	}

	output = &ListTagsForResourceOutput{}
	req = c.newRequest(op, input, output)
	return
}

// ListTagsForResource API operation for Amazon AppIntegrations Service.
//
// Lists the tags for the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation ListTagsForResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/ListTagsForResource
func (c *AppIntegrationsService) ListTagsForResource(input *ListTagsForResourceInput) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	return out, req.Send()
}

// ListTagsForResourceWithContext is the same as ListTagsForResource with the addition of
// the ability to pass a context and additional request options.
//
// See ListTagsForResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) ListTagsForResourceWithContext(ctx aws.Context, input *ListTagsForResourceInput, opts ...request.Option) (*ListTagsForResourceOutput, error) {
	req, out := c.ListTagsForResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opTagResource = "TagResource"

// TagResourceRequest generates a "aws/request.Request" representing the
// client's request for the TagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See TagResource for more information on using the TagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the TagResourceRequest method.
//    req, resp := client.TagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/TagResource
func (c *AppIntegrationsService) TagResourceRequest(input *TagResourceInput) (req *request.Request, output *TagResourceOutput) {
	op := &request.Operation{
		Name:       opTagResource,
		HTTPMethod: "POST",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &TagResourceInput{}
	}

	output = &TagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// TagResource API operation for Amazon AppIntegrations Service.
//
// Adds the specified tags to the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation TagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/TagResource
func (c *AppIntegrationsService) TagResource(input *TagResourceInput) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	return out, req.Send()
}

// TagResourceWithContext is the same as TagResource with the addition of
// the ability to pass a context and additional request options.
//
// See TagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) TagResourceWithContext(ctx aws.Context, input *TagResourceInput, opts ...request.Option) (*TagResourceOutput, error) {
	req, out := c.TagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUntagResource = "UntagResource"

// UntagResourceRequest generates a "aws/request.Request" representing the
// client's request for the UntagResource operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UntagResource for more information on using the UntagResource
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UntagResourceRequest method.
//    req, resp := client.UntagResourceRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UntagResource
func (c *AppIntegrationsService) UntagResourceRequest(input *UntagResourceInput) (req *request.Request, output *UntagResourceOutput) {
	op := &request.Operation{
		Name:       opUntagResource,
		HTTPMethod: "DELETE",
		HTTPPath:   "/tags/{resourceArn}",
	}

	if input == nil {
		input = &UntagResourceInput{}
	}

	output = &UntagResourceOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UntagResource API operation for Amazon AppIntegrations Service.
//
// Removes the specified tags from the specified resource.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation UntagResource for usage and error information.
//
// Returned Error Types:
//   * InvalidRequestException
//   The request is not valid.
//
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UntagResource
func (c *AppIntegrationsService) UntagResource(input *UntagResourceInput) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	return out, req.Send()
}

// UntagResourceWithContext is the same as UntagResource with the addition of
// the ability to pass a context and additional request options.
//
// See UntagResource for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) UntagResourceWithContext(ctx aws.Context, input *UntagResourceInput, opts ...request.Option) (*UntagResourceOutput, error) {
	req, out := c.UntagResourceRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateDataIntegration = "UpdateDataIntegration"

// UpdateDataIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateDataIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateDataIntegration for more information on using the UpdateDataIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateDataIntegrationRequest method.
//    req, resp := client.UpdateDataIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateDataIntegration
func (c *AppIntegrationsService) UpdateDataIntegrationRequest(input *UpdateDataIntegrationInput) (req *request.Request, output *UpdateDataIntegrationOutput) {
	op := &request.Operation{
		Name:       opUpdateDataIntegration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/dataIntegrations/{Identifier}",
	}

	if input == nil {
		input = &UpdateDataIntegrationInput{}
	}

	output = &UpdateDataIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateDataIntegration API operation for Amazon AppIntegrations Service.
//
// Updates the description of a DataIntegration.
//
// You cannot create a DataIntegration association for a DataIntegration that
// has been previously associated. Use a different DataIntegration, or recreate
// the DataIntegration using the CreateDataIntegration (https://docs.aws.amazon.com/appintegrations/latest/APIReference/API_CreateDataIntegration.html)
// API.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation UpdateDataIntegration for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateDataIntegration
func (c *AppIntegrationsService) UpdateDataIntegration(input *UpdateDataIntegrationInput) (*UpdateDataIntegrationOutput, error) {
	req, out := c.UpdateDataIntegrationRequest(input)
	return out, req.Send()
}

// UpdateDataIntegrationWithContext is the same as UpdateDataIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateDataIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) UpdateDataIntegrationWithContext(ctx aws.Context, input *UpdateDataIntegrationInput, opts ...request.Option) (*UpdateDataIntegrationOutput, error) {
	req, out := c.UpdateDataIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

const opUpdateEventIntegration = "UpdateEventIntegration"

// UpdateEventIntegrationRequest generates a "aws/request.Request" representing the
// client's request for the UpdateEventIntegration operation. The "output" return
// value will be populated with the request's response once the request completes
// successfully.
//
// Use "Send" method on the returned Request to send the API call to the service.
// the "output" return value is not valid until after Send returns without error.
//
// See UpdateEventIntegration for more information on using the UpdateEventIntegration
// API call, and error handling.
//
// This method is useful when you want to inject custom logic or configuration
// into the SDK's request lifecycle. Such as custom headers, or retry logic.
//
//
//    // Example sending a request using the UpdateEventIntegrationRequest method.
//    req, resp := client.UpdateEventIntegrationRequest(params)
//
//    err := req.Send()
//    if err == nil { // resp is now filled
//        fmt.Println(resp)
//    }
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateEventIntegration
func (c *AppIntegrationsService) UpdateEventIntegrationRequest(input *UpdateEventIntegrationInput) (req *request.Request, output *UpdateEventIntegrationOutput) {
	op := &request.Operation{
		Name:       opUpdateEventIntegration,
		HTTPMethod: "PATCH",
		HTTPPath:   "/eventIntegrations/{Name}",
	}

	if input == nil {
		input = &UpdateEventIntegrationInput{}
	}

	output = &UpdateEventIntegrationOutput{}
	req = c.newRequest(op, input, output)
	req.Handlers.Unmarshal.Swap(restjson.UnmarshalHandler.Name, protocol.UnmarshalDiscardBodyHandler)
	return
}

// UpdateEventIntegration API operation for Amazon AppIntegrations Service.
//
// Updates the description of an event integration.
//
// Returns awserr.Error for service API and SDK errors. Use runtime type assertions
// with awserr.Error's Code and Message methods to get detailed information about
// the error.
//
// See the AWS API reference guide for Amazon AppIntegrations Service's
// API operation UpdateEventIntegration for usage and error information.
//
// Returned Error Types:
//   * InternalServiceError
//   Request processing failed due to an error or failure with the service.
//
//   * ThrottlingException
//   The throttling limit has been exceeded.
//
//   * ResourceNotFoundException
//   The specified resource was not found.
//
//   * InvalidRequestException
//   The request is not valid.
//
//   * AccessDeniedException
//   You do not have sufficient access to perform this action.
//
// See also, https://docs.aws.amazon.com/goto/WebAPI/appintegrations-2020-07-29/UpdateEventIntegration
func (c *AppIntegrationsService) UpdateEventIntegration(input *UpdateEventIntegrationInput) (*UpdateEventIntegrationOutput, error) {
	req, out := c.UpdateEventIntegrationRequest(input)
	return out, req.Send()
}

// UpdateEventIntegrationWithContext is the same as UpdateEventIntegration with the addition of
// the ability to pass a context and additional request options.
//
// See UpdateEventIntegration for details on how to use this API operation.
//
// The context must be non-nil and will be used for request cancellation. If
// the context is nil a panic will occur. In the future the SDK may create
// sub-contexts for http.Requests. See https://golang.org/pkg/context/
// for more information on using Contexts.
func (c *AppIntegrationsService) UpdateEventIntegrationWithContext(ctx aws.Context, input *UpdateEventIntegrationInput, opts ...request.Option) (*UpdateEventIntegrationOutput, error) {
	req, out := c.UpdateEventIntegrationRequest(input)
	req.SetContext(ctx)
	req.ApplyOptions(opts...)
	return out, req.Send()
}

// You do not have sufficient access to perform this action.
type AccessDeniedException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s AccessDeniedException) GoString() string {
	return s.String()
}

func newErrorAccessDeniedException(v protocol.ResponseMetadata) error {
	return &AccessDeniedException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *AccessDeniedException) Code() string {
	return "AccessDeniedException"
}

// Message returns the exception's message.
func (s *AccessDeniedException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *AccessDeniedException) OrigErr() error {
	return nil
}

func (s *AccessDeniedException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *AccessDeniedException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *AccessDeniedException) RequestID() string {
	return s.RespMetadata.RequestID
}

type CreateDataIntegrationInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// A description of the DataIntegration.
	Description *string `min:"1" type:"string"`

	// The KMS key for the DataIntegration.
	KmsKey *string `min:"1" type:"string"`

	// The name of the DataIntegration.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// The name of the data and how often it should be pulled from the source.
	ScheduleConfig *ScheduleConfiguration `type:"structure"`

	// The URI of the data source.
	SourceURI *string `min:"1" type:"string"`

	// One or more tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateDataIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateDataIntegrationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.KmsKey != nil && len(*s.KmsKey) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("KmsKey", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.SourceURI != nil && len(*s.SourceURI) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("SourceURI", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.ScheduleConfig != nil {
		if err := s.ScheduleConfig.Validate(); err != nil {
			invalidParams.AddNested("ScheduleConfig", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDataIntegrationInput) SetClientToken(v string) *CreateDataIntegrationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataIntegrationInput) SetDescription(v string) *CreateDataIntegrationInput {
	s.Description = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *CreateDataIntegrationInput) SetKmsKey(v string) *CreateDataIntegrationInput {
	s.KmsKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataIntegrationInput) SetName(v string) *CreateDataIntegrationInput {
	s.Name = &v
	return s
}

// SetScheduleConfig sets the ScheduleConfig field's value.
func (s *CreateDataIntegrationInput) SetScheduleConfig(v *ScheduleConfiguration) *CreateDataIntegrationInput {
	s.ScheduleConfig = v
	return s
}

// SetSourceURI sets the SourceURI field's value.
func (s *CreateDataIntegrationInput) SetSourceURI(v string) *CreateDataIntegrationInput {
	s.SourceURI = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataIntegrationInput) SetTags(v map[string]*string) *CreateDataIntegrationInput {
	s.Tags = v
	return s
}

type CreateDataIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN)
	Arn *string `min:"1" type:"string"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `min:"1" type:"string"`

	// A description of the DataIntegration.
	Description *string `min:"1" type:"string"`

	// A unique identifier.
	Id *string `type:"string"`

	// The KMS key for the DataIntegration.
	KmsKey *string `min:"1" type:"string"`

	// The name of the DataIntegration.
	Name *string `min:"1" type:"string"`

	// The name of the data and how often it should be pulled from the source.
	ScheduleConfiguration *ScheduleConfiguration `type:"structure"`

	// The URI of the data source.
	SourceURI *string `min:"1" type:"string"`

	// One or more tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateDataIntegrationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *CreateDataIntegrationOutput) SetArn(v string) *CreateDataIntegrationOutput {
	s.Arn = &v
	return s
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateDataIntegrationOutput) SetClientToken(v string) *CreateDataIntegrationOutput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateDataIntegrationOutput) SetDescription(v string) *CreateDataIntegrationOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *CreateDataIntegrationOutput) SetId(v string) *CreateDataIntegrationOutput {
	s.Id = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *CreateDataIntegrationOutput) SetKmsKey(v string) *CreateDataIntegrationOutput {
	s.KmsKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *CreateDataIntegrationOutput) SetName(v string) *CreateDataIntegrationOutput {
	s.Name = &v
	return s
}

// SetScheduleConfiguration sets the ScheduleConfiguration field's value.
func (s *CreateDataIntegrationOutput) SetScheduleConfiguration(v *ScheduleConfiguration) *CreateDataIntegrationOutput {
	s.ScheduleConfiguration = v
	return s
}

// SetSourceURI sets the SourceURI field's value.
func (s *CreateDataIntegrationOutput) SetSourceURI(v string) *CreateDataIntegrationOutput {
	s.SourceURI = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateDataIntegrationOutput) SetTags(v map[string]*string) *CreateDataIntegrationOutput {
	s.Tags = v
	return s
}

type CreateEventIntegrationInput struct {
	_ struct{} `type:"structure"`

	// A unique, case-sensitive identifier that you provide to ensure the idempotency
	// of the request.
	ClientToken *string `min:"1" type:"string" idempotencyToken:"true"`

	// The description of the event integration.
	Description *string `min:"1" type:"string"`

	// The EventBridge bus.
	//
	// EventBridgeBus is a required field
	EventBridgeBus *string `min:"1" type:"string" required:"true"`

	// The event filter.
	//
	// EventFilter is a required field
	EventFilter *EventFilter `type:"structure" required:"true"`

	// The name of the event integration.
	//
	// Name is a required field
	Name *string `min:"1" type:"string" required:"true"`

	// One or more tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *CreateEventIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "CreateEventIntegrationInput"}
	if s.ClientToken != nil && len(*s.ClientToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ClientToken", 1))
	}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.EventBridgeBus == nil {
		invalidParams.Add(request.NewErrParamRequired("EventBridgeBus"))
	}
	if s.EventBridgeBus != nil && len(*s.EventBridgeBus) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventBridgeBus", 1))
	}
	if s.EventFilter == nil {
		invalidParams.Add(request.NewErrParamRequired("EventFilter"))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}
	if s.EventFilter != nil {
		if err := s.EventFilter.Validate(); err != nil {
			invalidParams.AddNested("EventFilter", err.(request.ErrInvalidParams))
		}
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetClientToken sets the ClientToken field's value.
func (s *CreateEventIntegrationInput) SetClientToken(v string) *CreateEventIntegrationInput {
	s.ClientToken = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *CreateEventIntegrationInput) SetDescription(v string) *CreateEventIntegrationInput {
	s.Description = &v
	return s
}

// SetEventBridgeBus sets the EventBridgeBus field's value.
func (s *CreateEventIntegrationInput) SetEventBridgeBus(v string) *CreateEventIntegrationInput {
	s.EventBridgeBus = &v
	return s
}

// SetEventFilter sets the EventFilter field's value.
func (s *CreateEventIntegrationInput) SetEventFilter(v *EventFilter) *CreateEventIntegrationInput {
	s.EventFilter = v
	return s
}

// SetName sets the Name field's value.
func (s *CreateEventIntegrationInput) SetName(v string) *CreateEventIntegrationInput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *CreateEventIntegrationInput) SetTags(v map[string]*string) *CreateEventIntegrationInput {
	s.Tags = v
	return s
}

type CreateEventIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the event integration.
	EventIntegrationArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s CreateEventIntegrationOutput) GoString() string {
	return s.String()
}

// SetEventIntegrationArn sets the EventIntegrationArn field's value.
func (s *CreateEventIntegrationOutput) SetEventIntegrationArn(v string) *CreateEventIntegrationOutput {
	s.EventIntegrationArn = &v
	return s
}

// Summary information about the DataIntegration association.
type DataIntegrationAssociationSummary struct {
	_ struct{} `type:"structure"`

	// The identifier for teh client that is associated with the DataIntegration
	// association.
	ClientId *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN)of the DataIntegration.
	DataIntegrationArn *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) of the DataIntegration association.
	DataIntegrationAssociationArn *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataIntegrationAssociationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataIntegrationAssociationSummary) GoString() string {
	return s.String()
}

// SetClientId sets the ClientId field's value.
func (s *DataIntegrationAssociationSummary) SetClientId(v string) *DataIntegrationAssociationSummary {
	s.ClientId = &v
	return s
}

// SetDataIntegrationArn sets the DataIntegrationArn field's value.
func (s *DataIntegrationAssociationSummary) SetDataIntegrationArn(v string) *DataIntegrationAssociationSummary {
	s.DataIntegrationArn = &v
	return s
}

// SetDataIntegrationAssociationArn sets the DataIntegrationAssociationArn field's value.
func (s *DataIntegrationAssociationSummary) SetDataIntegrationAssociationArn(v string) *DataIntegrationAssociationSummary {
	s.DataIntegrationAssociationArn = &v
	return s
}

// Summary information about the DataIntegration.
type DataIntegrationSummary struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the DataIntegration.
	Arn *string `min:"1" type:"string"`

	// The name of the DataIntegration.
	Name *string `min:"1" type:"string"`

	// The URI of the data source.
	SourceURI *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataIntegrationSummary) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DataIntegrationSummary) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *DataIntegrationSummary) SetArn(v string) *DataIntegrationSummary {
	s.Arn = &v
	return s
}

// SetName sets the Name field's value.
func (s *DataIntegrationSummary) SetName(v string) *DataIntegrationSummary {
	s.Name = &v
	return s
}

// SetSourceURI sets the SourceURI field's value.
func (s *DataIntegrationSummary) SetSourceURI(v string) *DataIntegrationSummary {
	s.SourceURI = &v
	return s
}

type DeleteDataIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the DataIntegration.
	//
	// DataIntegrationIdentifier is a required field
	DataIntegrationIdentifier *string `location:"uri" locationName:"Identifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteDataIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteDataIntegrationInput"}
	if s.DataIntegrationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DataIntegrationIdentifier"))
	}
	if s.DataIntegrationIdentifier != nil && len(*s.DataIntegrationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataIntegrationIdentifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataIntegrationIdentifier sets the DataIntegrationIdentifier field's value.
func (s *DeleteDataIntegrationInput) SetDataIntegrationIdentifier(v string) *DeleteDataIntegrationInput {
	s.DataIntegrationIdentifier = &v
	return s
}

type DeleteDataIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteDataIntegrationOutput) GoString() string {
	return s.String()
}

type DeleteEventIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the event integration.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *DeleteEventIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "DeleteEventIntegrationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *DeleteEventIntegrationInput) SetName(v string) *DeleteEventIntegrationInput {
	s.Name = &v
	return s
}

type DeleteEventIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DeleteEventIntegrationOutput) GoString() string {
	return s.String()
}

// A resource with the specified name already exists.
type DuplicateResourceException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateResourceException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s DuplicateResourceException) GoString() string {
	return s.String()
}

func newErrorDuplicateResourceException(v protocol.ResponseMetadata) error {
	return &DuplicateResourceException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *DuplicateResourceException) Code() string {
	return "DuplicateResourceException"
}

// Message returns the exception's message.
func (s *DuplicateResourceException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *DuplicateResourceException) OrigErr() error {
	return nil
}

func (s *DuplicateResourceException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *DuplicateResourceException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *DuplicateResourceException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The event filter.
type EventFilter struct {
	_ struct{} `type:"structure"`

	// The source of the events.
	//
	// Source is a required field
	Source *string `min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventFilter) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventFilter) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *EventFilter) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "EventFilter"}
	if s.Source == nil {
		invalidParams.Add(request.NewErrParamRequired("Source"))
	}
	if s.Source != nil && len(*s.Source) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Source", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetSource sets the Source field's value.
func (s *EventFilter) SetSource(v string) *EventFilter {
	s.Source = &v
	return s
}

// The event integration.
type EventIntegration struct {
	_ struct{} `type:"structure"`

	// The event integration description.
	Description *string `min:"1" type:"string"`

	// The Amazon EventBridge bus for the event integration.
	EventBridgeBus *string `min:"1" type:"string"`

	// The event integration filter.
	EventFilter *EventFilter `type:"structure"`

	// The Amazon Resource Name (ARN) of the event integration.
	EventIntegrationArn *string `min:"1" type:"string"`

	// The name of the event integration.
	Name *string `min:"1" type:"string"`

	// The tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventIntegration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventIntegration) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *EventIntegration) SetDescription(v string) *EventIntegration {
	s.Description = &v
	return s
}

// SetEventBridgeBus sets the EventBridgeBus field's value.
func (s *EventIntegration) SetEventBridgeBus(v string) *EventIntegration {
	s.EventBridgeBus = &v
	return s
}

// SetEventFilter sets the EventFilter field's value.
func (s *EventIntegration) SetEventFilter(v *EventFilter) *EventIntegration {
	s.EventFilter = v
	return s
}

// SetEventIntegrationArn sets the EventIntegrationArn field's value.
func (s *EventIntegration) SetEventIntegrationArn(v string) *EventIntegration {
	s.EventIntegrationArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *EventIntegration) SetName(v string) *EventIntegration {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *EventIntegration) SetTags(v map[string]*string) *EventIntegration {
	s.Tags = v
	return s
}

// The event integration association.
type EventIntegrationAssociation struct {
	_ struct{} `type:"structure"`

	// The metadata associated with the client.
	ClientAssociationMetadata map[string]*string `type:"map"`

	// The identifier for the client that is associated with the event integration.
	ClientId *string `min:"1" type:"string"`

	// The name of the EventBridge rule.
	EventBridgeRuleName *string `min:"1" type:"string"`

	// The Amazon Resource Name (ARN) for the event integration association.
	EventIntegrationAssociationArn *string `min:"1" type:"string"`

	// The identifier for the event integration association.
	EventIntegrationAssociationId *string `type:"string"`

	// The name of the event integration.
	EventIntegrationName *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventIntegrationAssociation) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s EventIntegrationAssociation) GoString() string {
	return s.String()
}

// SetClientAssociationMetadata sets the ClientAssociationMetadata field's value.
func (s *EventIntegrationAssociation) SetClientAssociationMetadata(v map[string]*string) *EventIntegrationAssociation {
	s.ClientAssociationMetadata = v
	return s
}

// SetClientId sets the ClientId field's value.
func (s *EventIntegrationAssociation) SetClientId(v string) *EventIntegrationAssociation {
	s.ClientId = &v
	return s
}

// SetEventBridgeRuleName sets the EventBridgeRuleName field's value.
func (s *EventIntegrationAssociation) SetEventBridgeRuleName(v string) *EventIntegrationAssociation {
	s.EventBridgeRuleName = &v
	return s
}

// SetEventIntegrationAssociationArn sets the EventIntegrationAssociationArn field's value.
func (s *EventIntegrationAssociation) SetEventIntegrationAssociationArn(v string) *EventIntegrationAssociation {
	s.EventIntegrationAssociationArn = &v
	return s
}

// SetEventIntegrationAssociationId sets the EventIntegrationAssociationId field's value.
func (s *EventIntegrationAssociation) SetEventIntegrationAssociationId(v string) *EventIntegrationAssociation {
	s.EventIntegrationAssociationId = &v
	return s
}

// SetEventIntegrationName sets the EventIntegrationName field's value.
func (s *EventIntegrationAssociation) SetEventIntegrationName(v string) *EventIntegrationAssociation {
	s.EventIntegrationName = &v
	return s
}

type GetDataIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"Identifier" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetDataIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetDataIntegrationInput"}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetIdentifier sets the Identifier field's value.
func (s *GetDataIntegrationInput) SetIdentifier(v string) *GetDataIntegrationInput {
	s.Identifier = &v
	return s
}

type GetDataIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) for the DataIntegration.
	Arn *string `min:"1" type:"string"`

	// The KMS key for the DataIntegration.
	Description *string `min:"1" type:"string"`

	// A unique identifier.
	Id *string `type:"string"`

	// The KMS key for the DataIntegration.
	KmsKey *string `min:"1" type:"string"`

	// The name of the DataIntegration.
	Name *string `min:"1" type:"string"`

	// The name of the data and how often it should be pulled from the source.
	ScheduleConfiguration *ScheduleConfiguration `type:"structure"`

	// The URI of the data source.
	SourceURI *string `min:"1" type:"string"`

	// One or more tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetDataIntegrationOutput) GoString() string {
	return s.String()
}

// SetArn sets the Arn field's value.
func (s *GetDataIntegrationOutput) SetArn(v string) *GetDataIntegrationOutput {
	s.Arn = &v
	return s
}

// SetDescription sets the Description field's value.
func (s *GetDataIntegrationOutput) SetDescription(v string) *GetDataIntegrationOutput {
	s.Description = &v
	return s
}

// SetId sets the Id field's value.
func (s *GetDataIntegrationOutput) SetId(v string) *GetDataIntegrationOutput {
	s.Id = &v
	return s
}

// SetKmsKey sets the KmsKey field's value.
func (s *GetDataIntegrationOutput) SetKmsKey(v string) *GetDataIntegrationOutput {
	s.KmsKey = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetDataIntegrationOutput) SetName(v string) *GetDataIntegrationOutput {
	s.Name = &v
	return s
}

// SetScheduleConfiguration sets the ScheduleConfiguration field's value.
func (s *GetDataIntegrationOutput) SetScheduleConfiguration(v *ScheduleConfiguration) *GetDataIntegrationOutput {
	s.ScheduleConfiguration = v
	return s
}

// SetSourceURI sets the SourceURI field's value.
func (s *GetDataIntegrationOutput) SetSourceURI(v string) *GetDataIntegrationOutput {
	s.SourceURI = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetDataIntegrationOutput) SetTags(v map[string]*string) *GetDataIntegrationOutput {
	s.Tags = v
	return s
}

type GetEventIntegrationInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the event integration.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *GetEventIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "GetEventIntegrationInput"}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetName sets the Name field's value.
func (s *GetEventIntegrationInput) SetName(v string) *GetEventIntegrationInput {
	s.Name = &v
	return s
}

type GetEventIntegrationOutput struct {
	_ struct{} `type:"structure"`

	// The description of the event integration.
	Description *string `min:"1" type:"string"`

	// The EventBridge bus.
	EventBridgeBus *string `min:"1" type:"string"`

	// The event filter.
	EventFilter *EventFilter `type:"structure"`

	// The Amazon Resource Name (ARN) for the event integration.
	EventIntegrationArn *string `min:"1" type:"string"`

	// The name of the event integration.
	Name *string `min:"1" type:"string"`

	// One or more tags.
	Tags map[string]*string `min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s GetEventIntegrationOutput) GoString() string {
	return s.String()
}

// SetDescription sets the Description field's value.
func (s *GetEventIntegrationOutput) SetDescription(v string) *GetEventIntegrationOutput {
	s.Description = &v
	return s
}

// SetEventBridgeBus sets the EventBridgeBus field's value.
func (s *GetEventIntegrationOutput) SetEventBridgeBus(v string) *GetEventIntegrationOutput {
	s.EventBridgeBus = &v
	return s
}

// SetEventFilter sets the EventFilter field's value.
func (s *GetEventIntegrationOutput) SetEventFilter(v *EventFilter) *GetEventIntegrationOutput {
	s.EventFilter = v
	return s
}

// SetEventIntegrationArn sets the EventIntegrationArn field's value.
func (s *GetEventIntegrationOutput) SetEventIntegrationArn(v string) *GetEventIntegrationOutput {
	s.EventIntegrationArn = &v
	return s
}

// SetName sets the Name field's value.
func (s *GetEventIntegrationOutput) SetName(v string) *GetEventIntegrationOutput {
	s.Name = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *GetEventIntegrationOutput) SetTags(v map[string]*string) *GetEventIntegrationOutput {
	s.Tags = v
	return s
}

// Request processing failed due to an error or failure with the service.
type InternalServiceError struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InternalServiceError) GoString() string {
	return s.String()
}

func newErrorInternalServiceError(v protocol.ResponseMetadata) error {
	return &InternalServiceError{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InternalServiceError) Code() string {
	return "InternalServiceError"
}

// Message returns the exception's message.
func (s *InternalServiceError) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InternalServiceError) OrigErr() error {
	return nil
}

func (s *InternalServiceError) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InternalServiceError) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InternalServiceError) RequestID() string {
	return s.RespMetadata.RequestID
}

// The request is not valid.
type InvalidRequestException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s InvalidRequestException) GoString() string {
	return s.String()
}

func newErrorInvalidRequestException(v protocol.ResponseMetadata) error {
	return &InvalidRequestException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *InvalidRequestException) Code() string {
	return "InvalidRequestException"
}

// Message returns the exception's message.
func (s *InvalidRequestException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *InvalidRequestException) OrigErr() error {
	return nil
}

func (s *InvalidRequestException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *InvalidRequestException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *InvalidRequestException) RequestID() string {
	return s.RespMetadata.RequestID
}

type ListDataIntegrationAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// A unique identifier for the DataIntegration.
	//
	// DataIntegrationIdentifier is a required field
	DataIntegrationIdentifier *string `location:"uri" locationName:"Identifier" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataIntegrationAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataIntegrationAssociationsInput"}
	if s.DataIntegrationIdentifier == nil {
		invalidParams.Add(request.NewErrParamRequired("DataIntegrationIdentifier"))
	}
	if s.DataIntegrationIdentifier != nil && len(*s.DataIntegrationIdentifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("DataIntegrationIdentifier", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDataIntegrationIdentifier sets the DataIntegrationIdentifier field's value.
func (s *ListDataIntegrationAssociationsInput) SetDataIntegrationIdentifier(v string) *ListDataIntegrationAssociationsInput {
	s.DataIntegrationIdentifier = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataIntegrationAssociationsInput) SetMaxResults(v int64) *ListDataIntegrationAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataIntegrationAssociationsInput) SetNextToken(v string) *ListDataIntegrationAssociationsInput {
	s.NextToken = &v
	return s
}

type ListDataIntegrationAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) and unique ID of the DataIntegration association.
	DataIntegrationAssociations []*DataIntegrationAssociationSummary `min:"1" type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationAssociationsOutput) GoString() string {
	return s.String()
}

// SetDataIntegrationAssociations sets the DataIntegrationAssociations field's value.
func (s *ListDataIntegrationAssociationsOutput) SetDataIntegrationAssociations(v []*DataIntegrationAssociationSummary) *ListDataIntegrationAssociationsOutput {
	s.DataIntegrationAssociations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataIntegrationAssociationsOutput) SetNextToken(v string) *ListDataIntegrationAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListDataIntegrationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListDataIntegrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListDataIntegrationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListDataIntegrationsInput) SetMaxResults(v int64) *ListDataIntegrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataIntegrationsInput) SetNextToken(v string) *ListDataIntegrationsInput {
	s.NextToken = &v
	return s
}

type ListDataIntegrationsOutput struct {
	_ struct{} `type:"structure"`

	// The DataIntegrations associated with this account.
	DataIntegrations []*DataIntegrationSummary `min:"1" type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListDataIntegrationsOutput) GoString() string {
	return s.String()
}

// SetDataIntegrations sets the DataIntegrations field's value.
func (s *ListDataIntegrationsOutput) SetDataIntegrations(v []*DataIntegrationSummary) *ListDataIntegrationsOutput {
	s.DataIntegrations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListDataIntegrationsOutput) SetNextToken(v string) *ListDataIntegrationsOutput {
	s.NextToken = &v
	return s
}

type ListEventIntegrationAssociationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The name of the event integration.
	//
	// EventIntegrationName is a required field
	EventIntegrationName *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationAssociationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationAssociationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventIntegrationAssociationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventIntegrationAssociationsInput"}
	if s.EventIntegrationName == nil {
		invalidParams.Add(request.NewErrParamRequired("EventIntegrationName"))
	}
	if s.EventIntegrationName != nil && len(*s.EventIntegrationName) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("EventIntegrationName", 1))
	}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetEventIntegrationName sets the EventIntegrationName field's value.
func (s *ListEventIntegrationAssociationsInput) SetEventIntegrationName(v string) *ListEventIntegrationAssociationsInput {
	s.EventIntegrationName = &v
	return s
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventIntegrationAssociationsInput) SetMaxResults(v int64) *ListEventIntegrationAssociationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventIntegrationAssociationsInput) SetNextToken(v string) *ListEventIntegrationAssociationsInput {
	s.NextToken = &v
	return s
}

type ListEventIntegrationAssociationsOutput struct {
	_ struct{} `type:"structure"`

	// The event integration associations.
	EventIntegrationAssociations []*EventIntegrationAssociation `min:"1" type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationAssociationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationAssociationsOutput) GoString() string {
	return s.String()
}

// SetEventIntegrationAssociations sets the EventIntegrationAssociations field's value.
func (s *ListEventIntegrationAssociationsOutput) SetEventIntegrationAssociations(v []*EventIntegrationAssociation) *ListEventIntegrationAssociationsOutput {
	s.EventIntegrationAssociations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventIntegrationAssociationsOutput) SetNextToken(v string) *ListEventIntegrationAssociationsOutput {
	s.NextToken = &v
	return s
}

type ListEventIntegrationsInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The maximum number of results to return per page.
	MaxResults *int64 `location:"querystring" locationName:"maxResults" min:"1" type:"integer"`

	// The token for the next set of results. Use the value returned in the previous
	// response in the next request to retrieve the next set of results.
	NextToken *string `location:"querystring" locationName:"nextToken" min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationsInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationsInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListEventIntegrationsInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListEventIntegrationsInput"}
	if s.MaxResults != nil && *s.MaxResults < 1 {
		invalidParams.Add(request.NewErrParamMinValue("MaxResults", 1))
	}
	if s.NextToken != nil && len(*s.NextToken) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("NextToken", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetMaxResults sets the MaxResults field's value.
func (s *ListEventIntegrationsInput) SetMaxResults(v int64) *ListEventIntegrationsInput {
	s.MaxResults = &v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventIntegrationsInput) SetNextToken(v string) *ListEventIntegrationsInput {
	s.NextToken = &v
	return s
}

type ListEventIntegrationsOutput struct {
	_ struct{} `type:"structure"`

	// The event integrations.
	EventIntegrations []*EventIntegration `min:"1" type:"list"`

	// If there are additional results, this is the token for the next set of results.
	NextToken *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationsOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListEventIntegrationsOutput) GoString() string {
	return s.String()
}

// SetEventIntegrations sets the EventIntegrations field's value.
func (s *ListEventIntegrationsOutput) SetEventIntegrations(v []*EventIntegration) *ListEventIntegrationsOutput {
	s.EventIntegrations = v
	return s
}

// SetNextToken sets the NextToken field's value.
func (s *ListEventIntegrationsOutput) SetNextToken(v string) *ListEventIntegrationsOutput {
	s.NextToken = &v
	return s
}

type ListTagsForResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ListTagsForResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ListTagsForResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *ListTagsForResourceInput) SetResourceArn(v string) *ListTagsForResourceInput {
	s.ResourceArn = &v
	return s
}

type ListTagsForResourceOutput struct {
	_ struct{} `type:"structure"`

	// Information about the tags.
	Tags map[string]*string `locationName:"tags" min:"1" type:"map"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ListTagsForResourceOutput) GoString() string {
	return s.String()
}

// SetTags sets the Tags field's value.
func (s *ListTagsForResourceOutput) SetTags(v map[string]*string) *ListTagsForResourceOutput {
	s.Tags = v
	return s
}

// The specified resource was not found.
type ResourceNotFoundException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceNotFoundException) GoString() string {
	return s.String()
}

func newErrorResourceNotFoundException(v protocol.ResponseMetadata) error {
	return &ResourceNotFoundException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceNotFoundException) Code() string {
	return "ResourceNotFoundException"
}

// Message returns the exception's message.
func (s *ResourceNotFoundException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceNotFoundException) OrigErr() error {
	return nil
}

func (s *ResourceNotFoundException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceNotFoundException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceNotFoundException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The allowed quota for the resource has been exceeded.
type ResourceQuotaExceededException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceQuotaExceededException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ResourceQuotaExceededException) GoString() string {
	return s.String()
}

func newErrorResourceQuotaExceededException(v protocol.ResponseMetadata) error {
	return &ResourceQuotaExceededException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ResourceQuotaExceededException) Code() string {
	return "ResourceQuotaExceededException"
}

// Message returns the exception's message.
func (s *ResourceQuotaExceededException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ResourceQuotaExceededException) OrigErr() error {
	return nil
}

func (s *ResourceQuotaExceededException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ResourceQuotaExceededException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ResourceQuotaExceededException) RequestID() string {
	return s.RespMetadata.RequestID
}

// The name of the data and how often it should be pulled from the source.
type ScheduleConfiguration struct {
	_ struct{} `type:"structure"`

	// The start date for objects to import in the first flow run.
	FirstExecutionFrom *string `min:"1" type:"string"`

	// The name of the object to pull from the data source.
	Object *string `min:"1" type:"string"`

	// How often the data should be pulled from data source.
	ScheduleExpression *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleConfiguration) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ScheduleConfiguration) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *ScheduleConfiguration) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "ScheduleConfiguration"}
	if s.FirstExecutionFrom != nil && len(*s.FirstExecutionFrom) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("FirstExecutionFrom", 1))
	}
	if s.Object != nil && len(*s.Object) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Object", 1))
	}
	if s.ScheduleExpression != nil && len(*s.ScheduleExpression) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ScheduleExpression", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetFirstExecutionFrom sets the FirstExecutionFrom field's value.
func (s *ScheduleConfiguration) SetFirstExecutionFrom(v string) *ScheduleConfiguration {
	s.FirstExecutionFrom = &v
	return s
}

// SetObject sets the Object field's value.
func (s *ScheduleConfiguration) SetObject(v string) *ScheduleConfiguration {
	s.Object = &v
	return s
}

// SetScheduleExpression sets the ScheduleExpression field's value.
func (s *ScheduleConfiguration) SetScheduleExpression(v string) *ScheduleConfiguration {
	s.ScheduleExpression = &v
	return s
}

type TagResourceInput struct {
	_ struct{} `type:"structure"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// One or more tags.
	//
	// Tags is a required field
	Tags map[string]*string `locationName:"tags" min:"1" type:"map" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *TagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "TagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.Tags == nil {
		invalidParams.Add(request.NewErrParamRequired("Tags"))
	}
	if s.Tags != nil && len(s.Tags) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Tags", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *TagResourceInput) SetResourceArn(v string) *TagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTags sets the Tags field's value.
func (s *TagResourceInput) SetTags(v map[string]*string) *TagResourceInput {
	s.Tags = v
	return s
}

type TagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s TagResourceOutput) GoString() string {
	return s.String()
}

// The throttling limit has been exceeded.
type ThrottlingException struct {
	_            struct{}                  `type:"structure"`
	RespMetadata protocol.ResponseMetadata `json:"-" xml:"-"`

	Message_ *string `locationName:"Message" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s ThrottlingException) GoString() string {
	return s.String()
}

func newErrorThrottlingException(v protocol.ResponseMetadata) error {
	return &ThrottlingException{
		RespMetadata: v,
	}
}

// Code returns the exception type name.
func (s *ThrottlingException) Code() string {
	return "ThrottlingException"
}

// Message returns the exception's message.
func (s *ThrottlingException) Message() string {
	if s.Message_ != nil {
		return *s.Message_
	}
	return ""
}

// OrigErr always returns nil, satisfies awserr.Error interface.
func (s *ThrottlingException) OrigErr() error {
	return nil
}

func (s *ThrottlingException) Error() string {
	return fmt.Sprintf("%s: %s", s.Code(), s.Message())
}

// Status code returns the HTTP status code for the request's response error.
func (s *ThrottlingException) StatusCode() int {
	return s.RespMetadata.StatusCode
}

// RequestID returns the service's response RequestID for request.
func (s *ThrottlingException) RequestID() string {
	return s.RespMetadata.RequestID
}

type UntagResourceInput struct {
	_ struct{} `type:"structure" nopayload:"true"`

	// The Amazon Resource Name (ARN) of the resource.
	//
	// ResourceArn is a required field
	ResourceArn *string `location:"uri" locationName:"resourceArn" min:"1" type:"string" required:"true"`

	// The tag keys.
	//
	// TagKeys is a required field
	TagKeys []*string `location:"querystring" locationName:"tagKeys" min:"1" type:"list" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UntagResourceInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UntagResourceInput"}
	if s.ResourceArn == nil {
		invalidParams.Add(request.NewErrParamRequired("ResourceArn"))
	}
	if s.ResourceArn != nil && len(*s.ResourceArn) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("ResourceArn", 1))
	}
	if s.TagKeys == nil {
		invalidParams.Add(request.NewErrParamRequired("TagKeys"))
	}
	if s.TagKeys != nil && len(s.TagKeys) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("TagKeys", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetResourceArn sets the ResourceArn field's value.
func (s *UntagResourceInput) SetResourceArn(v string) *UntagResourceInput {
	s.ResourceArn = &v
	return s
}

// SetTagKeys sets the TagKeys field's value.
func (s *UntagResourceInput) SetTagKeys(v []*string) *UntagResourceInput {
	s.TagKeys = v
	return s
}

type UntagResourceOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UntagResourceOutput) GoString() string {
	return s.String()
}

type UpdateDataIntegrationInput struct {
	_ struct{} `type:"structure"`

	// A description of the DataIntegration.
	Description *string `min:"1" type:"string"`

	// A unique identifier for the DataIntegration.
	//
	// Identifier is a required field
	Identifier *string `location:"uri" locationName:"Identifier" min:"1" type:"string" required:"true"`

	// The name of the DataIntegration.
	Name *string `min:"1" type:"string"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateDataIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateDataIntegrationInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Identifier == nil {
		invalidParams.Add(request.NewErrParamRequired("Identifier"))
	}
	if s.Identifier != nil && len(*s.Identifier) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Identifier", 1))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateDataIntegrationInput) SetDescription(v string) *UpdateDataIntegrationInput {
	s.Description = &v
	return s
}

// SetIdentifier sets the Identifier field's value.
func (s *UpdateDataIntegrationInput) SetIdentifier(v string) *UpdateDataIntegrationInput {
	s.Identifier = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateDataIntegrationInput) SetName(v string) *UpdateDataIntegrationInput {
	s.Name = &v
	return s
}

type UpdateDataIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateDataIntegrationOutput) GoString() string {
	return s.String()
}

type UpdateEventIntegrationInput struct {
	_ struct{} `type:"structure"`

	// The description of the event inegration.
	Description *string `min:"1" type:"string"`

	// The name of the event integration.
	//
	// Name is a required field
	Name *string `location:"uri" locationName:"Name" min:"1" type:"string" required:"true"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventIntegrationInput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventIntegrationInput) GoString() string {
	return s.String()
}

// Validate inspects the fields of the type to determine if they are valid.
func (s *UpdateEventIntegrationInput) Validate() error {
	invalidParams := request.ErrInvalidParams{Context: "UpdateEventIntegrationInput"}
	if s.Description != nil && len(*s.Description) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Description", 1))
	}
	if s.Name == nil {
		invalidParams.Add(request.NewErrParamRequired("Name"))
	}
	if s.Name != nil && len(*s.Name) < 1 {
		invalidParams.Add(request.NewErrParamMinLen("Name", 1))
	}

	if invalidParams.Len() > 0 {
		return invalidParams
	}
	return nil
}

// SetDescription sets the Description field's value.
func (s *UpdateEventIntegrationInput) SetDescription(v string) *UpdateEventIntegrationInput {
	s.Description = &v
	return s
}

// SetName sets the Name field's value.
func (s *UpdateEventIntegrationInput) SetName(v string) *UpdateEventIntegrationInput {
	s.Name = &v
	return s
}

type UpdateEventIntegrationOutput struct {
	_ struct{} `type:"structure"`
}

// String returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventIntegrationOutput) String() string {
	return awsutil.Prettify(s)
}

// GoString returns the string representation.
//
// API parameter values that are decorated as "sensitive" in the API will not
// be included in the string output. The member name will be present, but the
// value will be replaced with "sensitive".
func (s UpdateEventIntegrationOutput) GoString() string {
	return s.String()
}
