/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.lang.crypto;

import de.unkrig.commons.lang.AssertionUtil;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;

public final class MD5 {
    private MD5() {
    }

    public static byte[] of(String subject) {
        return MD5.of(subject.getBytes(Charset.forName("UTF-8")));
    }

    public static byte[] of(byte[] subject) {
        return MD5.of(subject, 0, subject.length);
    }

    public static byte[] of(byte[] subject, int offset, int length) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)nsae);
        }
        md.update(subject, offset, length);
        byte[] result = md.digest();
        assert (result.length == 16);
        return result;
    }

    public static byte[] of(InputStream inputStream) throws IOException {
        int n;
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException nsae) {
            throw new AssertionError((Object)nsae);
        }
        byte[] ba = new byte[4096];
        while ((n = inputStream.read(ba)) != -1) {
            md.update(ba, 0, n);
        }
        byte[] result = md.digest();
        assert (result.length == 16);
        return result;
    }

    static {
        AssertionUtil.enableAssertionsForThisClass();
    }
}

