/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.net.authenticator;

import de.unkrig.commons.lang.ExceptionUtil;
import de.unkrig.commons.lang.ObjectUtil;
import de.unkrig.commons.lang.crypto.PasswordAuthenticationStore;
import de.unkrig.commons.lang.crypto.PasswordAuthenticationStores;
import de.unkrig.commons.lang.crypto.SecretKeys;
import de.unkrig.commons.nullanalysis.Nullable;
import de.unkrig.commons.util.JPasswordFields;
import java.io.File;
import java.io.IOException;
import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.crypto.SecretKey;
import javax.security.auth.Destroyable;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPasswordField;
import javax.swing.JTextField;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;

public class CustomAuthenticator
extends Authenticator {
    private final CacheMode cacheMode;
    private final StoreMode storeMode;
    private final List<CredentialsSpec> credentials = new ArrayList<CredentialsSpec>();
    private MessageFormat dialogLabelMf = new MessageFormat("<html>\n  <table>\n    {1,  choice, 0#|1#'<tr><td>Host:    </td><td>'{2}'</td></tr>'}\n    {3,  choice, 0#|1#'<tr><td>Site:    </td><td>'{4}'</td></tr>'}\n    {5,  choice, 0#|1#'<tr><td>Port:    </td><td>'{6}'</td></tr>'}\n    {7,  choice, 0#|1#'<tr><td>Protocol:</td><td>'{8}'</td></tr>'}\n    {9,  choice, 0#|1#'<tr><td>Prompt:  </td><td>'{10}'</td></tr>'}\n    {11, choice, 0#|1#'<tr><td>Scheme:  </td><td>'{12}'</td></tr>'}\n    {13, choice, 0#|1#'<tr><td>URL:     </td><td>'{14}'</td></tr>'}\n    {15, choice, 0#|1#'<tr><td>Type:    </td><td>'{16}'</td></tr>'}\n  </table>\n</html>");
    private final Map<String, String> userNameCache = Collections.synchronizedMap(new HashMap());
    private final Map<String, char[]> passwordCache = Collections.synchronizedMap(new HashMap());
    @Nullable
    private PasswordAuthenticationStore passwordStore;
    public static final String DEFAULT_DIALOG_LABEL = "<html>\n  <table>\n    {1,  choice, 0#|1#'<tr><td>Host:    </td><td>'{2}'</td></tr>'}\n    {3,  choice, 0#|1#'<tr><td>Site:    </td><td>'{4}'</td></tr>'}\n    {5,  choice, 0#|1#'<tr><td>Port:    </td><td>'{6}'</td></tr>'}\n    {7,  choice, 0#|1#'<tr><td>Protocol:</td><td>'{8}'</td></tr>'}\n    {9,  choice, 0#|1#'<tr><td>Prompt:  </td><td>'{10}'</td></tr>'}\n    {11, choice, 0#|1#'<tr><td>Scheme:  </td><td>'{12}'</td></tr>'}\n    {13, choice, 0#|1#'<tr><td>URL:     </td><td>'{14}'</td></tr>'}\n    {15, choice, 0#|1#'<tr><td>Type:    </td><td>'{16}'</td></tr>'}\n  </table>\n</html>";
    private static final File KEY_STORE_FILE = new File(System.getProperty("user.home"), ".customAuthenticator_keystore");
    private static final char[] KEY_STORE_PASSWORD = new char[0];
    private static final String KEY_ALIAS = "setAuthenticatorKey";
    private static final File CREDENTIALS_STORE_FILE = new File(System.getProperty("user.home"), ".customAuthenticator_credentials");
    private static final String CREDENTIALS_STORE_COMMENTS = " The credentials store of the CustomAuthenticator of http://antology.unkrig.de.";

    public CustomAuthenticator(CacheMode cacheMode, StoreMode storeMode) {
        this.cacheMode = cacheMode;
        this.storeMode = storeMode;
    }

    public void setDialogLabel(String message) {
        this.dialogLabelMf = new MessageFormat(message);
    }

    public void addCredentials(Collection<CredentialsSpec> credentials) {
        for (CredentialsSpec newCs : credentials) {
            if (this.credentials.contains(newCs)) continue;
            this.credentials.add(newCs);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    @Nullable
    protected PasswordAuthentication getPasswordAuthentication() {
        boolean hasPassword;
        JPasswordField passwordField;
        JTextField userNameField;
        char[] password;
        String title;
        String message;
        String key;
        String userName;
        block34: {
            userName = null;
            for (CredentialsSpec cs : this.credentials) {
                char[] password2;
                if (!this.matches(cs)) continue;
                if (cs.deny) {
                    return null;
                }
                userName = cs.userName;
                if (userName == null || (password2 = cs.password) == null) break;
                return new PasswordAuthentication(userName, Arrays.copyOf(password2, password2.length));
            }
            key = this.getRequestorType().toString() + '/' + ObjectUtil.or(this.getRequestingProtocol(), "-") + '/' + ObjectUtil.or(this.getRequestingHost(), "-") + '/' + Integer.toString(this.getRequestingPort()) + '/' + ObjectUtil.or(this.getRequestingScheme(), "-");
            ArrayList<Object> args = new ArrayList<Object>();
            args.add(key);
            CustomAuthenticator.add2(this.getRequestingHost(), args);
            CustomAuthenticator.add2(this.getRequestingSite(), args);
            CustomAuthenticator.add2(this.getRequestingPort(), args);
            CustomAuthenticator.add2(this.getRequestingProtocol(), args);
            CustomAuthenticator.add2(this.getRequestingPrompt(), args);
            CustomAuthenticator.add2(this.getRequestingScheme(), args);
            CustomAuthenticator.add2(this.getRequestingURL(), args);
            CustomAuthenticator.add2((Object)this.getRequestorType(), args);
            message = this.dialogLabelMf.format(args.toArray());
            title = this.getRequestingProtocol().toUpperCase() + (this.getRequestorType() == Authenticator.RequestorType.PROXY ? " Proxy Authentication" : " Authentication");
            password = null;
            try {
                switch (this.cacheMode) {
                    case NONE: {
                        break;
                    }
                    case USER_NAMES: {
                        userName = this.userNameCache.get(key);
                        break;
                    }
                    case USER_NAMES_AND_PASSWORDS: {
                        userName = this.userNameCache.get(key);
                        char[] tmp = this.passwordCache.get(key);
                        if (tmp == null) break;
                        password = (char[])tmp.clone();
                        break;
                    }
                }
                switch (this.storeMode) {
                    case NONE: {
                        break;
                    }
                    case USER_NAMES: {
                        if (userName != null) break;
                        userName = this.getPasswordStore().getUserName(key);
                        break;
                    }
                    case USER_NAMES_AND_PASSWORDS: {
                        if (userName == null) {
                            userName = this.getPasswordStore().getUserName(key);
                            if (userName == null) break;
                            if (password != null) {
                                Arrays.fill(password, '\u0000');
                            }
                            password = this.getPasswordStore().getPassword(key, userName);
                            break;
                        }
                        if (password != null || !userName.equals(this.getPasswordStore().getUserName(key))) break;
                        password = this.getPasswordStore().getPassword(key, userName);
                        break;
                    }
                }
                userNameField = new JTextField();
                if (userName != null) {
                    userNameField.setText(userName);
                }
                passwordField = new JPasswordField();
                if (password != null) {
                    JPasswordFields.setPassword(passwordField, password);
                }
                boolean bl = hasPassword = password != null;
                if (password == null) break block34;
            }
            catch (Throwable throwable) {
                if (password == null) throw throwable;
                Arrays.fill(password, '\u0000');
                throw throwable;
            }
            Arrays.fill(password, '\u0000');
        }
        CustomAuthenticator.focussify(userName != null && !hasPassword ? passwordField : userNameField);
        if (JOptionPane.showOptionDialog(null, new Object[]{new JLabel(message), new JLabel("User name:"), userNameField, new JLabel("Password:"), passwordField}, title, 2, -1, null, null, null) != 0) {
            return null;
        }
        userName = userNameField.getText();
        password = passwordField.getPassword();
        try {
            switch (this.cacheMode) {
                case NONE: {
                    break;
                }
                case USER_NAMES: {
                    this.userNameCache.put(key, userName);
                    break;
                }
                case USER_NAMES_AND_PASSWORDS: {
                    this.userNameCache.put(key, userName);
                    char[] prev = this.passwordCache.put(key, (char[])password.clone());
                    if (prev == null) break;
                    Arrays.fill(prev, '\u0000');
                    break;
                }
            }
            try {
                switch (this.storeMode) {
                    case NONE: {
                        this.getPasswordStore().remove(key);
                        break;
                    }
                    case USER_NAMES: {
                        this.getPasswordStore().put(key, userName);
                        break;
                    }
                    case USER_NAMES_AND_PASSWORDS: {
                        this.getPasswordStore().put(key, userName, (char[])password.clone());
                        break;
                    }
                }
            }
            catch (IOException ioe) {
                throw ExceptionUtil.wrap("Saving password store", ioe, IllegalStateException.class);
            }
            PasswordAuthentication passwordAuthentication = new PasswordAuthentication(userName, password);
            return passwordAuthentication;
        }
        finally {
            Arrays.fill(password, '\u0000');
        }
    }

    private boolean matches(CredentialsSpec credentialsSpec) {
        return CustomAuthenticator.matches(credentialsSpec.requestingHost, this.getRequestingHost()) && CustomAuthenticator.matches(credentialsSpec.requestingSite, this.getRequestingSite()) && CustomAuthenticator.matches(credentialsSpec.requestingPort, this.getRequestingPort()) && CustomAuthenticator.matches(credentialsSpec.requestingProtocol, this.getRequestingProtocol()) && CustomAuthenticator.matches(credentialsSpec.requestingPrompt, this.getRequestingPrompt()) && CustomAuthenticator.matches(credentialsSpec.requestingScheme, this.getRequestingScheme()) && CustomAuthenticator.matches(credentialsSpec.requestingUrl, this.getRequestingURL()) && CustomAuthenticator.matches(credentialsSpec.requestorType, (Object)this.getRequestorType());
    }

    private static void add2(@Nullable Object arg, List<Object> args) {
        String s;
        if (arg != null && !Integer.valueOf(-1).equals(arg) && !(s = arg.toString().trim()).isEmpty()) {
            args.add(1);
            args.add(s);
            return;
        }
        args.add(0);
        args.add("");
    }

    private PasswordAuthenticationStore getPasswordStore() {
        PasswordAuthenticationStore result = this.passwordStore;
        if (result != null) {
            return result;
        }
        try {
            SecretKey secretKey = SecretKeys.adHocSecretKey(KEY_STORE_FILE, KEY_STORE_PASSWORD, KEY_ALIAS, "Authentication store", "Do you want to create an authentication store for user names and passwords?", "Do you want to use the existing authentication store for user names and passwords?");
            if (secretKey == null) {
                result = PasswordAuthenticationStore.NOP;
            } else {
                PasswordAuthenticationStore pas = PasswordAuthenticationStores.propertiesPasswordAuthenticationStore(PasswordAuthenticationStores.propertiesFileDestroyableProperties(CREDENTIALS_STORE_FILE, CREDENTIALS_STORE_COMMENTS));
                result = PasswordAuthenticationStores.encryptPasswords(secretKey, pas);
            }
        }
        catch (Exception e) {
            result = PasswordAuthenticationStore.NOP;
        }
        this.passwordStore = result;
        return this.passwordStore;
    }

    private static void focussify(JComponent component) {
        component.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(@Nullable AncestorEvent event) {
                assert (event != null);
                JComponent component = event.getComponent();
                component.requestFocusInWindow();
                component.removeAncestorListener(this);
            }

            @Override
            public void ancestorRemoved(@Nullable AncestorEvent event) {
            }

            @Override
            public void ancestorMoved(@Nullable AncestorEvent event) {
            }
        });
    }

    private static boolean matches(@Nullable Pattern pattern, @Nullable Object subject) {
        return pattern == null || subject != null && pattern.matcher(subject.toString()).matches();
    }

    public static final class CredentialsSpec
    implements Destroyable {
        @Nullable
        private Pattern requestingHost;
        @Nullable
        private Pattern requestingSite;
        @Nullable
        private Pattern requestingPort;
        @Nullable
        private Pattern requestingProtocol;
        @Nullable
        private Pattern requestingPrompt;
        @Nullable
        private Pattern requestingScheme;
        @Nullable
        private Pattern requestingUrl;
        @Nullable
        private Pattern requestorType;
        @Nullable
        private String userName;
        @Nullable
        private char[] password;
        private boolean deny;
        private boolean destroyed;

        protected void finalize() {
            this.destroy();
        }

        @Override
        public void destroy() {
            if (this.password != null) {
                Arrays.fill(this.password, '\u0000');
            }
            this.destroyed = true;
        }

        @Override
        public boolean isDestroyed() {
            return this.destroyed;
        }

        public void setRequestingHost(@Nullable Pattern regex) {
            this.requestingHost = regex;
        }

        public void setRequestingSite(@Nullable Pattern regex) {
            this.requestingSite = regex;
        }

        public void setRequestingPort(@Nullable Pattern regex) {
            this.requestingPort = regex;
        }

        public void setRequestingProtocol(@Nullable Pattern regex) {
            this.requestingProtocol = regex;
        }

        public void setRequestingPrompt(@Nullable Pattern regex) {
            this.requestingPrompt = regex;
        }

        public void setRequestingScheme(@Nullable Pattern regex) {
            this.requestingScheme = regex;
        }

        public void setRequestingUrl(@Nullable Pattern regex) {
            this.requestingUrl = regex;
        }

        public void setRequestorType(@Nullable Pattern regex) {
            this.requestorType = regex;
        }

        public void setDeny(boolean value) {
            this.deny = value;
        }

        public void setUserName(@Nullable String userName) {
            this.userName = userName;
        }

        public void setPassword(@Nullable char[] password) {
            try {
                if (password == null) {
                    if (this.password != null) {
                        Arrays.fill(this.password, '\u0000');
                    }
                    this.password = null;
                } else {
                    this.password = Arrays.copyOf(password, password.length);
                }
            }
            finally {
                if (password != null) {
                    Arrays.fill(password, '\u0000');
                }
            }
        }

        public int hashCode() {
            return ObjectUtil.hashCode(this.requestingHost) + ObjectUtil.hashCode(this.requestingSite) + ObjectUtil.hashCode(this.requestingPort) + ObjectUtil.hashCode(this.requestingProtocol) + ObjectUtil.hashCode(this.requestingPrompt) + ObjectUtil.hashCode(this.requestingScheme) + ObjectUtil.hashCode(this.requestingUrl) + ObjectUtil.hashCode(this.requestorType) + ObjectUtil.hashCode(this.userName) + ObjectUtil.hashCode(this.password) + (this.deny ? 1234 : 789312568);
        }

        public boolean equals(@Nullable Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj == null || obj.getClass() != this.getClass()) {
                return false;
            }
            CredentialsSpec that = (CredentialsSpec)obj;
            return ObjectUtil.equals(this.requestingHost, that.requestingHost) && ObjectUtil.equals(this.requestingSite, that.requestingSite) && ObjectUtil.equals(this.requestingPort, that.requestingPort) && ObjectUtil.equals(this.requestingProtocol, that.requestingProtocol) && ObjectUtil.equals(this.requestingPrompt, that.requestingPrompt) && ObjectUtil.equals(this.requestingScheme, that.requestingScheme) && ObjectUtil.equals(this.requestingUrl, that.requestingUrl) && ObjectUtil.equals(this.requestorType, that.requestorType) && ObjectUtil.equals(this.userName, that.userName) && ObjectUtil.equals(this.password, that.password) && this.deny == that.deny;
        }
    }

    public static enum StoreMode {
        NONE,
        USER_NAMES,
        USER_NAMES_AND_PASSWORDS;

    }

    public static enum CacheMode {
        NONE,
        USER_NAMES,
        USER_NAMES_AND_PASSWORDS;

    }
}

