/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util.concurrent;

import de.unkrig.commons.nullanalysis.NotNullByDefault;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.AbstractExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.TimeUnit;

public class LinearExecutorService
extends AbstractExecutorService {
    private volatile int runState;
    static final int RUNNING = 0;
    static final int SHUTDOWN = 1;
    static final int STOP = 2;
    static final int TERMINATED = 3;

    @Override
    public void shutdown() {
        this.runState = 3;
    }

    @Override
    public List<Runnable> shutdownNow() {
        this.runState = 3;
        return Collections.emptyList();
    }

    @Override
    public boolean isShutdown() {
        return this.runState != 0;
    }

    @Override
    public boolean isTerminated() {
        return this.runState == 3;
    }

    @Override
    @NotNullByDefault(value=false)
    public boolean awaitTermination(long timeout, TimeUnit unit) {
        return this.runState == 3;
    }

    @Override
    @NotNullByDefault(value=false)
    public void execute(Runnable command) {
        if (this.runState != 0) {
            throw new RejectedExecutionException();
        }
        command.run();
    }
}

