/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.util.Predicate;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PredicateUtil {
    private static final Predicate ALWAYS = new Predicate(){

        public boolean evaluate(Object subject) {
            return true;
        }
    };
    private static final Predicate NEVER = new Predicate(){

        public boolean evaluate(Object subject) {
            return false;
        }
    };

    private PredicateUtil() {
    }

    public static <T> Predicate<T> always() {
        return ALWAYS;
    }

    public static <T> Predicate<T> never() {
        return NEVER;
    }

    public static <T> Predicate<T> and(final Predicate<? super T> p1, final Predicate<? super T> p2) {
        if (p1 == NEVER || p2 == NEVER) {
            return NEVER;
        }
        if (p1 == ALWAYS) {
            return p2;
        }
        if (p2 == ALWAYS) {
            return p1;
        }
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return p1.evaluate(subject) && p2.evaluate(subject);
            }
        };
    }

    public static <T> Predicate<T> or(final Predicate<? super T> p1, final Predicate<? super T> p2) {
        if (p1 == ALWAYS || p2 == ALWAYS) {
            return ALWAYS;
        }
        if (p1 == NEVER) {
            return p2;
        }
        if (p2 == NEVER) {
            return p1;
        }
        return new Predicate<T>(){

            @Override
            public boolean evaluate(T subject) {
                return p1.evaluate(subject) || p2.evaluate(subject);
            }
        };
    }
}

