/*
 * Decompiled with CFR 0.152.
 */
package de.unkrig.commons.util;

import de.unkrig.commons.io.charstream.CharSequenceCharStream;
import de.unkrig.commons.io.charstream.CharStream;
import de.unkrig.commons.io.charstream.UnexpectedCharacterException;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public abstract class TimeTable {
    public static final TimeTable NEVER = new TimeTable(){

        public Date next(Date previous) {
            return MAX_DATE;
        }
    };
    public static final Date MAX_DATE = new Date(Long.MAX_VALUE);
    public static final Date MIN_DATE = new Date(Long.MIN_VALUE);

    TimeTable() {
    }

    public abstract Date next(Date var1);

    public static TimeTable once(final Date date) {
        return new TimeTable(){

            public Date next(Date previous) {
                return date.compareTo(previous) > 0 ? date : MAX_DATE;
            }
        };
    }

    public static TimeTable parse(String s) throws ParseException {
        return new Parser<RuntimeException>(new CharSequenceCharStream(s)).parse();
    }

    public static class ParseException
    extends Exception {
        private static final long serialVersionUID = 1L;

        public ParseException(String message) {
            super(message);
        }

        public ParseException(Throwable t) {
            super(t);
        }

        public ParseException(String message, Throwable t) {
            super(message, t);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static final class Parser<T extends Throwable> {
        private final CharStream<T> cs;
        private static final Map<String, Integer> WEEKDAY_DISPLAY_NAMES;

        static {
            HashMap<String, Integer> m = new HashMap<String, Integer>();
            m.put("Mon", 2);
            m.put("Tue", 3);
            m.put("Wed", 4);
            m.put("Thu", 5);
            m.put("Fri", 6);
            m.put("Sat", 7);
            m.put("Sun", 1);
            WEEKDAY_DISPLAY_NAMES = Collections.unmodifiableMap(m);
        }

        public Parser(CharStream<T> cs) {
            this.cs = cs;
        }

        public TimeTable parse() throws ParseException, T {
            return this.parsePatternSequence();
        }

        private TimeTable parsePatternSequence() throws ParseException, T {
            TimeTable tt = this.parsePattern();
            while (this.peekRead(',')) {
                final TimeTable lhs = tt;
                final TimeTable rhs = this.parsePattern();
                tt = new TimeTable(){

                    public Date next(Date previous) {
                        Date d1 = lhs.next(previous);
                        Date d2 = rhs.next(previous);
                        if (d1 == null) {
                            return rhs.next(previous);
                        }
                        return d1.compareTo(d2) < 0 ? d1 : d2;
                    }
                };
            }
            this.eoi();
            return tt;
        }

        private TimeTable parsePattern() throws ParseException, T {
            IntegerPattern dayOfWeek;
            IntegerPattern hour;
            IntegerPattern minute;
            IntegerPattern second;
            IntegerPattern year;
            IntegerPattern month;
            IntegerPattern dayOfMonth;
            block4: {
                block7: {
                    block5: {
                        block6: {
                            block2: {
                                block3: {
                                    int i = 1;
                                    while (true) {
                                        int c;
                                        if ((c = this.peek(i)) == -1 || c == 44 || c == 58 || c == 32) {
                                            month = dayOfMonth = IntegerPattern.ANY;
                                            year = dayOfMonth;
                                            break block2;
                                        }
                                        if (c == 45) break;
                                        ++i;
                                    }
                                    year = this.parseYearPattern();
                                    this.read('-');
                                    month = this.parseMonthPattern();
                                    this.read('-');
                                    dayOfMonth = this.parseDayOfMonthPattern();
                                    if (!this.isAtEoi()) break block3;
                                    minute = second = IntegerPattern.ANY;
                                    hour = second;
                                    dayOfWeek = second;
                                    break block4;
                                }
                                this.read(' ');
                            }
                            if (this.peekLetter() == -1) break block5;
                            dayOfWeek = this.parseDayOfWeekPattern();
                            if (!this.isAtEoi()) break block6;
                            minute = second = IntegerPattern.ANY;
                            hour = second;
                            break block4;
                        }
                        this.read(' ');
                        break block7;
                    }
                    dayOfWeek = IntegerPattern.ANY;
                }
                hour = this.parseHourPattern();
                this.read(':');
                minute = this.parseMinutePattern();
                second = this.peekRead(':') ? this.parseSecondPattern() : IntegerPattern.ZERO;
            }
            return new TimeTable(){

                public Date next(Date previous) {
                    Calendar cal = Calendar.getInstance();
                    cal.setTime(previous);
                    cal.add(13, 1);
                    int ss = second.getConstant();
                    if (ss == -1) {
                        while (!second.matches(cal.get(13))) {
                            cal.add(13, 1);
                        }
                    } else {
                        if (cal.get(13) > ss) {
                            cal.add(12, 1);
                        }
                        cal.set(13, ss);
                    }
                    int mm = minute.getConstant();
                    if (mm == -1) {
                        while (!minute.matches(cal.get(12))) {
                            cal.add(12, 1);
                        }
                    } else {
                        if (cal.get(12) > mm) {
                            cal.add(10, 1);
                        }
                        cal.set(12, mm);
                    }
                    int hh = hour.getConstant();
                    if (hh == -1) {
                        while (!hour.matches(cal.get(10))) {
                            cal.add(10, 1);
                        }
                    } else {
                        if (cal.get(10) > hh) {
                            cal.add(10, 1);
                        }
                        cal.set(10, hh);
                    }
                    while (!dayOfMonth.matches(cal.get(5)) || !dayOfWeek.matches(cal.get(7))) {
                        cal.add(5, 1);
                    }
                    int mo = month.getConstant();
                    if (mo == -1) {
                        while (!month.matches(cal.get(2) + 1)) {
                            cal.add(2, 1);
                        }
                    } else {
                        if (cal.get(2) + 1 > mo) {
                            cal.add(1, 1);
                        }
                        cal.set(2, mo - 1);
                    }
                    int yy = year.getConstant();
                    if (yy == -1) {
                        while (!year.matches(cal.get(1))) {
                            cal.add(1, 1);
                        }
                    } else {
                        if (cal.get(1) > yy) {
                            return MAX_DATE;
                        }
                        cal.set(1, yy);
                    }
                    return cal.getTime();
                }
            };
        }

        private IntegerPattern parseDayOfWeekPattern() throws ParseException, T {
            IntegerPattern ip = this.parseWeekdayRange();
            while (this.peekRead(',')) {
                final IntegerPattern lhs = ip;
                final IntegerPattern rhs = this.parseWeekdayRange();
                ip = new IntegerPattern(){

                    @Override
                    public boolean matches(int subject) {
                        return lhs.matches(subject) || rhs.matches(subject);
                    }

                    @Override
                    public int getConstant() {
                        return -1;
                    }
                };
            }
            return ip;
        }

        private IntegerPattern parseWeekdayRange() throws ParseException, T {
            int from = this.scanWeekday();
            if (!this.peekRead('-')) {
                return new ConstantIntegerPattern(from);
            }
            int to = this.scanWeekday();
            return new RangeIntegerPattern(from, to);
        }

        private IntegerPattern parseYearPattern() throws ParseException, T {
            return this.parseIntegerPattern(0, 3000);
        }

        private IntegerPattern parseMonthPattern() throws ParseException, T {
            return this.parseIntegerPattern(1, 12);
        }

        private IntegerPattern parseDayOfMonthPattern() throws ParseException, T {
            return this.parseIntegerPattern(1, 31);
        }

        private IntegerPattern parseHourPattern() throws ParseException, T {
            return this.parseIntegerPattern(0, 23);
        }

        private IntegerPattern parseMinutePattern() throws ParseException, T {
            return this.parseIntegerPattern(0, 59);
        }

        private IntegerPattern parseSecondPattern() throws ParseException, T {
            return this.parseIntegerPattern(0, 59);
        }

        private IntegerPattern parseIntegerPattern(int min, int max) throws ParseException, T {
            if (this.cs.peekRead('*')) {
                return IntegerPattern.ANY;
            }
            if (this.peekRead('(')) {
                IntegerPattern ip = this.parseIntegerRange(min, max);
                while (this.peekRead(',')) {
                    final IntegerPattern lhs = ip;
                    final IntegerPattern rhs = this.parseIntegerRange(min, max);
                    ip = new IntegerPattern(){

                        @Override
                        public boolean matches(int subject) {
                            return lhs.matches(subject) || rhs.matches(subject);
                        }

                        @Override
                        public int getConstant() {
                            return -1;
                        }
                    };
                }
                this.read(')');
                return ip;
            }
            return new ConstantIntegerPattern(this.parseInteger(min, max));
        }

        private IntegerPattern parseIntegerRange(int min, int max) throws ParseException, T {
            int from = this.parseInteger(min, max);
            if (this.peekRead('-')) {
                return new RangeIntegerPattern(from, this.parseInteger(min, max));
            }
            return new ConstantIntegerPattern(from);
        }

        private int parseInteger(int min, int max) throws ParseException, T {
            int result = this.scanInteger();
            if (result < min) {
                throw new ParseException("Value '" + result + "' is too small - must be '" + min + "' or greater");
            }
            if (result > max) {
                throw new ParseException("Value '" + result + "' is too large - mus be '" + max + "' or less");
            }
            return result;
        }

        private int scanInteger() throws ParseException, T {
            StringBuilder sb = new StringBuilder().append(this.readDigit());
            while (this.peekDigit() != -1) {
                sb.append(this.read());
            }
            return Integer.parseInt(sb.toString());
        }

        private String scanWord() throws ParseException, T {
            StringBuilder sb = new StringBuilder().append(this.readLetter());
            while (this.peekLetter() != -1) {
                sb.append(this.read());
            }
            return sb.toString();
        }

        private int scanWeekday() throws ParseException, T {
            String word = this.scanWord();
            Integer wd = WEEKDAY_DISPLAY_NAMES.get(word);
            if (wd == null) {
                throw new ParseException("Invalid weekday '" + word + "' - valid weekdays are " + WEEKDAY_DISPLAY_NAMES);
            }
            return wd;
        }

        private int peekLetter() throws T {
            int c = this.cs.peek();
            return c != -1 && Character.isLetter(c) ? c : -1;
        }

        private char readLetter() throws ParseException, T {
            char c = this.read();
            if (!Character.isLetter(c)) {
                throw new ParseException("Letter expected instead of '" + c + "'");
            }
            return c;
        }

        private int peekDigit() throws T {
            int c = this.cs.peek();
            return c != -1 && Character.isDigit(c) ? c : -1;
        }

        private char readDigit() throws ParseException, T {
            char c = this.read();
            if (!Character.isDigit(c)) {
                throw new ParseException("Digit expected instead of '" + c + "'");
            }
            return c;
        }

        private int peek(int distance) throws T {
            return this.cs.peek(distance);
        }

        private boolean peekRead(char c) throws T {
            return this.cs.peekRead(c);
        }

        private char read() throws ParseException, T {
            try {
                return this.cs.read();
            }
            catch (UnexpectedCharacterException uce) {
                throw new ParseException(uce.getMessage(), uce);
            }
        }

        private void read(char c) throws ParseException, T {
            try {
                this.cs.read(c);
            }
            catch (UnexpectedCharacterException uce) {
                throw new ParseException(uce.getMessage(), uce);
            }
        }

        private boolean isAtEoi() throws T {
            return this.cs.isAtEoi();
        }

        private void eoi() throws ParseException, T {
            try {
                this.cs.eoi();
            }
            catch (UnexpectedCharacterException uce) {
                throw new ParseException(uce.getMessage(), uce);
            }
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class ConstantIntegerPattern
        implements IntegerPattern {
            private final int constantValue;

            public ConstantIntegerPattern(int constantValue) {
                this.constantValue = constantValue;
            }

            @Override
            public boolean matches(int subject) {
                return subject == this.constantValue;
            }

            @Override
            public int getConstant() {
                return this.constantValue;
            }
        }

        static interface IntegerPattern {
            public static final IntegerPattern ANY = new IntegerPattern(){

                @Override
                public boolean matches(int subject) {
                    return true;
                }

                @Override
                public int getConstant() {
                    return -1;
                }
            };
            public static final IntegerPattern ZERO = new ConstantIntegerPattern(0);

            public boolean matches(int var1);

            public int getConstant();
        }

        /*
         * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
         */
        static final class RangeIntegerPattern
        implements IntegerPattern {
            private final int from;
            private final int to;

            public RangeIntegerPattern(int from, int to) throws ParseException {
                if (to < from) {
                    throw new ParseException("Upper limit '" + to + "' is smaller than lower limit '" + from + "'");
                }
                this.from = from;
                this.to = to;
            }

            @Override
            public boolean matches(int subject) {
                return subject >= this.from && subject <= this.to;
            }

            @Override
            public int getConstant() {
                return -1;
            }
        }
    }
}

