/*
 * Decompiled with CFR 0.152.
 */
package com.apple.laf;

import apple.laf.JRSUIConstants;
import apple.laf.JRSUIState;
import apple.laf.JRSUIStateFactory;
import com.apple.laf.AquaImageFactory;
import com.apple.laf.AquaPainter;
import com.apple.laf.AquaSplitPaneUI;
import com.apple.laf.AquaUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.GradientPaint;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Insets;
import java.beans.PropertyChangeEvent;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.border.Border;
import javax.swing.plaf.basic.BasicSplitPaneDivider;

public class AquaSplitPaneDividerUI
extends BasicSplitPaneDivider {
    final AquaPainter<JRSUIState> painter = AquaPainter.create(JRSUIStateFactory.getSplitPaneDivider());
    static final AquaUtils.LazyKeyedSingleton<Integer, Image> directionArrows = new AquaUtils.LazyKeyedSingleton<Integer, Image>(){

        @Override
        protected Image getInstance(Integer n) {
            Image image = AquaImageFactory.getArrowImageForDirection(n);
            int n2 = image.getHeight(null) * 5 / 7;
            int n3 = image.getWidth(null) * 5 / 7;
            return AquaUtils.generateLightenedImage(image.getScaledInstance(n3, n2, 4), 50);
        }
    };
    static final int kMaxPopupArrowSize = 9;

    public AquaSplitPaneDividerUI(AquaSplitPaneUI aquaSplitPaneUI) {
        super(aquaSplitPaneUI);
        this.setLayout(new DividerLayout());
    }

    @Override
    public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
        if (propertyChangeEvent.getSource() == this.splitPane) {
            String string = propertyChangeEvent.getPropertyName();
            if ("enabled".equals(string)) {
                boolean bl = this.splitPane.isEnabled();
                if (this.leftButton != null) {
                    this.leftButton.setEnabled(bl);
                }
                if (this.rightButton != null) {
                    this.rightButton.setEnabled(bl);
                }
            } else if ("orientation".equals(string)) {
                if (this.rightButton != null) {
                    this.remove(this.rightButton);
                    this.rightButton = null;
                }
                if (this.leftButton != null) {
                    this.remove(this.leftButton);
                    this.leftButton = null;
                }
                this.oneTouchExpandableChanged();
            }
        }
        super.propertyChange(propertyChangeEvent);
    }

    public int getMaxDividerSize() {
        return 10;
    }

    @Override
    public void paint(Graphics graphics) {
        Dimension dimension = this.getSize();
        int n = 0;
        int n2 = 0;
        boolean bl = this.splitPane.getOrientation() == 0;
        int n3 = this.getMaxDividerSize();
        boolean bl2 = true;
        if (bl) {
            if (dimension.height > n3) {
                int n4 = dimension.height - n3;
                n2 = n4 / 2;
                dimension.height = n3;
            }
            if (dimension.height < 4) {
                bl2 = false;
            }
        } else {
            if (dimension.width > n3) {
                int n5 = dimension.width - n3;
                n = n5 / 2;
                dimension.width = n3;
            }
            if (dimension.width < 4) {
                bl2 = false;
            }
        }
        if (bl2) {
            ((JRSUIState)this.painter.state).set(this.getState());
            this.painter.paint(graphics, this.splitPane, n, n2, dimension.width, dimension.height);
        }
        super.paint(graphics);
    }

    protected JRSUIConstants.State getState() {
        return this.splitPane.isEnabled() ? JRSUIConstants.State.ACTIVE : JRSUIConstants.State.DISABLED;
    }

    @Override
    protected JButton createLeftOneTouchButton() {
        return AquaSplitPaneDividerUI.createButtonForDirection(this.getDirection(true));
    }

    @Override
    protected JButton createRightOneTouchButton() {
        return AquaSplitPaneDividerUI.createButtonForDirection(this.getDirection(false));
    }

    static JButton createButtonForDirection(int n) {
        JButton jButton = new JButton(new ImageIcon(directionArrows.get(n)));
        jButton.setCursor(Cursor.getPredefinedCursor(0));
        jButton.setFocusPainted(false);
        jButton.setRequestFocusEnabled(false);
        jButton.setFocusable(false);
        jButton.setBorder(BorderFactory.createEmptyBorder(1, 1, 1, 1));
        return jButton;
    }

    int getDirection(boolean bl) {
        if (this.splitPane.getOrientation() == 1) {
            return bl ? 7 : 3;
        }
        return bl ? 1 : 5;
    }

    public static Border getHorizontalSplitDividerGradientVariant() {
        return HorizontalSplitDividerGradientPainter.instance();
    }

    static class HorizontalSplitDividerGradientPainter
    implements Border {
        private static final AquaUtils.RecyclableSingleton<HorizontalSplitDividerGradientPainter> instance = new AquaUtils.RecyclableSingletonFromDefaultConstructor<HorizontalSplitDividerGradientPainter>(HorizontalSplitDividerGradientPainter.class);
        final Color startColor = Color.white;
        final Color endColor = new Color(217, 217, 217);
        final Color borderLines = Color.lightGray;

        HorizontalSplitDividerGradientPainter() {
        }

        static HorizontalSplitDividerGradientPainter instance() {
            return instance.get();
        }

        @Override
        public Insets getBorderInsets(Component component) {
            return new Insets(0, 0, 0, 0);
        }

        @Override
        public boolean isBorderOpaque() {
            return true;
        }

        @Override
        public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
            if (!(graphics instanceof Graphics2D)) {
                return;
            }
            Graphics2D graphics2D = (Graphics2D)graphics;
            Color color = graphics2D.getColor();
            graphics2D.setPaint(new GradientPaint(0.0f, 0.0f, this.startColor, 0.0f, n4, this.endColor));
            graphics2D.fillRect(n, n2, n3, n4);
            graphics2D.setColor(this.borderLines);
            graphics2D.drawLine(n, n2, n + n3, n2);
            graphics2D.drawLine(n, n2 + n4 - 1, n + n3, n2 + n4 - 1);
            graphics2D.setColor(color);
        }
    }

    protected class DividerLayout
    extends BasicSplitPaneDivider.DividerLayout {
        protected DividerLayout() {
            super(AquaSplitPaneDividerUI.this);
        }

        @Override
        public void layoutContainer(Container container) {
            int n = AquaSplitPaneDividerUI.this.getMaxDividerSize();
            Dimension dimension = AquaSplitPaneDividerUI.this.getSize();
            if (AquaSplitPaneDividerUI.this.leftButton == null || AquaSplitPaneDividerUI.this.rightButton == null || container != AquaSplitPaneDividerUI.this) {
                return;
            }
            if (!AquaSplitPaneDividerUI.this.splitPane.isOneTouchExpandable()) {
                AquaSplitPaneDividerUI.this.leftButton.setBounds(-5, -5, 1, 1);
                AquaSplitPaneDividerUI.this.rightButton.setBounds(-5, -5, 1, 1);
                return;
            }
            int n2 = Math.min(AquaSplitPaneDividerUI.this.getDividerSize(), 9);
            if (AquaSplitPaneDividerUI.this.orientation == 0) {
                int n3;
                int n4 = 0;
                if (dimension.height > n) {
                    n3 = dimension.height - n;
                    n4 = n3 / 2;
                }
                n3 = 11;
                AquaSplitPaneDividerUI.this.rightButton.setBounds(n3, n4, 9, n2);
                AquaSplitPaneDividerUI.this.leftButton.setBounds(n3 -= 11, n4, 9, n2);
            } else {
                int n5;
                int n6 = 0;
                if (dimension.width > n) {
                    n5 = dimension.width - n;
                    n6 = n5 / 2;
                }
                n5 = 11;
                AquaSplitPaneDividerUI.this.rightButton.setBounds(n6, n5, n2, 9);
                AquaSplitPaneDividerUI.this.leftButton.setBounds(n6, n5 -= 11, n2, 9);
            }
        }
    }
}

