/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.automation.internal.module.handler;

import java.util.List;
import java.util.Map;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.automation.Action;
import org.openhab.core.automation.handler.BaseActionModuleHandler;
import org.openhab.core.config.core.Configuration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@NonNullByDefault
public class RuleEnablementActionHandler
extends BaseActionModuleHandler {
    public static final String UID = "core.RuleEnablementAction";
    private static final String ENABLE_KEY = "enable";
    private static final String RULE_UIDS_KEY = "ruleUIDs";
    private final Logger logger = LoggerFactory.getLogger(RuleEnablementActionHandler.class);
    private final List<String> uids;
    private final boolean enable;

    public RuleEnablementActionHandler(Action module) {
        super(module);
        Configuration config = module.getConfiguration();
        Boolean enable = (Boolean)config.get(ENABLE_KEY);
        if (enable == null) {
            throw new IllegalArgumentException("'enable' property can not be null.");
        }
        this.enable = enable;
        this.uids = (List)config.get(RULE_UIDS_KEY);
        if (this.uids == null) {
            throw new IllegalArgumentException("'ruleUIDs' property can not be null.");
        }
    }

    @Override
    public @Nullable Map<String, @Nullable Object> execute(Map<String, Object> context) {
        for (String uid : this.uids) {
            if (this.callback != null) {
                this.callback.setEnabled(uid, this.enable);
                continue;
            }
            this.logger.warn("Action is not applied to {} because rule engine is not available.", (Object)uid);
        }
        return null;
    }
}

