/*
 * Decompiled with CFR 0.152.
 */
package org.openhab.core.io.console.karaf;

import java.io.IOException;
import java.io.PrintStream;
import org.apache.karaf.shell.api.console.Session;
import org.eclipse.jdt.annotation.NonNullByDefault;
import org.eclipse.jdt.annotation.Nullable;
import org.openhab.core.io.console.Console;

@NonNullByDefault
public class OSGiConsole
implements Console {
    private final String scope;
    private final PrintStream out;
    private final Session session;

    public OSGiConsole(String scope, PrintStream out, Session session) {
        this.scope = scope;
        this.out = out;
        this.session = session;
    }

    public void printf(String format, Object ... args) {
        this.out.printf(format, args);
    }

    public void print(String s) {
        this.out.print(s);
    }

    public void println(String s) {
        this.out.println(s);
    }

    public void printUsage(String s) {
        this.out.println(String.format("Usage: %s:%s", this.scope, s));
    }

    public String readLine(String prompt, @Nullable Character mask) throws IOException {
        String previousSetting = System.setProperty("org.jline.reader.support.parsedline", "true");
        try {
            String string = this.session.readLine(prompt, mask);
            return string;
        }
        finally {
            if (previousSetting != null) {
                System.setProperty("org.jline.reader.support.parsedline", previousSetting);
            } else {
                System.clearProperty("org.jline.reader.support.parsedline");
            }
        }
    }

    public @Nullable String getUser() {
        Object result = this.session.get("USER");
        return result != null ? result.toString() : null;
    }

    public Session getSession() {
        return this.session;
    }
}

