/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.vuejs.codeInsight;

import com.intellij.javascript.nodejs.NodeModuleSearchUtil;
import com.intellij.lang.injection.InjectedLanguageManager;
import com.intellij.lang.javascript.DialectDetector;
import com.intellij.lang.javascript.frameworks.JSFrameworkSpecificHandler;
import com.intellij.lang.javascript.psi.JSCallExpression;
import com.intellij.lang.javascript.psi.JSElement;
import com.intellij.lang.javascript.psi.JSExpectedTypeKind;
import com.intellij.lang.javascript.psi.JSExpression;
import com.intellij.lang.javascript.psi.JSExpressionStatement;
import com.intellij.lang.javascript.psi.JSFunctionExpression;
import com.intellij.lang.javascript.psi.JSIndexedPropertyAccessExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.JSType;
import com.intellij.lang.javascript.psi.ecma6.JSStringTemplateExpression;
import com.intellij.lang.javascript.psi.types.JSTypeContext;
import com.intellij.lang.javascript.psi.types.JSTypeImpl;
import com.intellij.lang.javascript.psi.types.JSTypeSourceFactory;
import com.intellij.lang.javascript.psi.types.primitives.JSStringType;
import com.intellij.lang.javascript.psi.util.JSStubBasedPsiTreeUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.polySymbols.html.attributes.HtmlAttributeSymbolDescriptor;
import com.intellij.polySymbols.js.types.TypeScriptSymbolTypeSupportKt;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiLanguageInjectionHost;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.vuejs.codeInsight.attributes.VueAttributeNameParser;
import org.jetbrains.vuejs.context.VueContextKt;
import org.jetbrains.vuejs.index.VueFrameworkHandlerKt;
import org.jetbrains.vuejs.lang.expr.VueExprLanguagesKt;
import org.jetbrains.vuejs.lang.expr.psi.VueJSEmbeddedExpressionContent;
import org.jetbrains.vuejs.model.VueComponent;
import org.jetbrains.vuejs.model.VueGlobalImplKt;
import org.jetbrains.vuejs.model.VueInject;
import org.jetbrains.vuejs.model.VueModelManager;
import org.jetbrains.vuejs.model.VueProvideUtilsKt;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0016J\u0010\u0010\b\u001a\u00020\u00052\u0006\u0010\t\u001a\u00020\nH\u0016J$\u0010\u000b\u001a\u0004\u0018\u00010\n2\u0006\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u00072\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0011H\u0002J\u0012\u0010\u0012\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0013\u001a\u00020\u0011H\u0002J\u001a\u0010\u0014\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u00072\b\u0010\r\u001a\u0004\u0018\u00010\u0007H\u0002J\u0010\u0010\u0015\u001a\u00020\u00052\u0006\u0010\f\u001a\u00020\u0007H\u0002J\u0012\u0010\u0016\u001a\u0004\u0018\u00010\n2\u0006\u0010\u0017\u001a\u00020\u0018H\u0002\u00a8\u0006\u0019"}, d2={"Lorg/jetbrains/vuejs/codeInsight/VueFrameworkSpecificHandler;", "Lcom/intellij/lang/javascript/frameworks/JSFrameworkSpecificHandler;", "<init>", "()V", "useMoreAccurateEvaluation", "", "context", "Lcom/intellij/psi/PsiElement;", "shouldPreserveAlias", "type", "Lcom/intellij/lang/javascript/psi/JSType;", "findExpectedType", "element", "parent", "expectedTypeKind", "Lcom/intellij/lang/javascript/psi/JSExpectedTypeKind;", "isInjectCall", "Lcom/intellij/lang/javascript/psi/JSCallExpression;", "getInjectType", "call", "isTopmostVueExpression", "isMethodHandler", "getPolySymbolType", "attribute", "Lcom/intellij/psi/xml/XmlAttribute;", "intellij.vuejs"})
@SourceDebugExtension(value={"SMAP\nVueFrameworkSpecificHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VueFrameworkSpecificHandler.kt\norg/jetbrains/vuejs/codeInsight/VueFrameworkSpecificHandler\n+ 2 VueUtil.kt\norg/jetbrains/vuejs/codeInsight/VueUtilKt\n+ 3 psiTreeUtil.kt\ncom/intellij/psi/util/PsiTreeUtilKt\n+ 4 fake.kt\nkotlin/jvm/internal/FakeKt\n+ 5 KtUtils.kt\ncom/intellij/util/KotlinUtils\n+ 6 JSSymbolUtils.kt\ncom/intellij/polySymbols/js/JSPolySymbolUtils\n*L\n1#1,92:1\n478#2,2:93\n66#3,2:95\n1#4:97\n19#5:98\n19#5:99\n65#6:100\n*S KotlinDebug\n*F\n+ 1 VueFrameworkSpecificHandler.kt\norg/jetbrains/vuejs/codeInsight/VueFrameworkSpecificHandler\n*L\n43#1:93,2\n43#1:95,2\n66#1:98\n91#1:99\n91#1:100\n*E\n"})
public final class VueFrameworkSpecificHandler
implements JSFrameworkSpecificHandler {
    public boolean useMoreAccurateEvaluation(@NotNull PsiElement context) {
        Intrinsics.checkNotNullParameter((Object)context, (String)"context");
        return VueContextKt.hasPinia(context);
    }

    public boolean shouldPreserveAlias(@NotNull JSType type2) {
        Intrinsics.checkNotNullParameter((Object)type2, (String)"type");
        return type2 instanceof JSTypeImpl && Intrinsics.areEqual((Object)((JSTypeImpl)type2).getTypeText(), (Object)"DefineProps");
    }

    @Nullable
    public JSType findExpectedType(@NotNull PsiElement element, @Nullable PsiElement parent, @NotNull JSExpectedTypeKind expectedTypeKind) {
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        Intrinsics.checkNotNullParameter((Object)expectedTypeKind, (String)"expectedTypeKind");
        if (DialectDetector.isJavaScript((PsiElement)element) && element instanceof JSCallExpression && this.isInjectCall((JSCallExpression)element)) {
            return this.getInjectType((JSCallExpression)element);
        }
        if (this.isTopmostVueExpression(element, parent)) {
            PsiElement host$iv;
            PsiElement $this$parentOfTypeInAttribute$iv = element;
            boolean $i$f$parentOfTypeInAttribute = false;
            PsiLanguageInjectionHost psiLanguageInjectionHost = InjectedLanguageManager.getInstance((Project)$this$parentOfTypeInAttribute$iv.getProject()).getInjectionHost($this$parentOfTypeInAttribute$iv);
            PsiElement $this$parentOfType_u24default$iv$iv = host$iv = psiLanguageInjectionHost != null ? (PsiElement)psiLanguageInjectionHost : $this$parentOfTypeInAttribute$iv;
            boolean withSelf$iv$iv = false;
            boolean $i$f$parentOfType = false;
            XmlAttribute xmlAttribute = (XmlAttribute)PsiTreeUtil.getParentOfType((PsiElement)$this$parentOfType_u24default$iv$iv, XmlAttribute.class, (boolean)true);
            if (xmlAttribute == null) {
                return null;
            }
            XmlAttribute attribute = xmlAttribute;
            XmlTag tag = attribute.getParent();
            String string = attribute.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getName(...)");
            CharSequence charSequence = string;
            Intrinsics.checkNotNull((Object)tag);
            VueAttributeNameParser.VueAttributeInfo attributeInfo = VueAttributeNameParser.Companion.parse(charSequence, tag);
            String string2 = tag.getName();
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getName(...)");
            String tagName = string2;
            if (attributeInfo instanceof VueAttributeNameParser.VueDirectiveInfo && ((VueAttributeNameParser.VueDirectiveInfo)attributeInfo).getDirectiveKind() == VueAttributeNameParser.VueDirectiveKind.ON) {
                return this.isMethodHandler(element) ? this.getPolySymbolType(attribute) : null;
            }
            if (Intrinsics.areEqual((Object)tagName, (Object)"slot") && attributeInfo instanceof VueAttributeNameParser.VueDirectiveInfo && ((VueAttributeNameParser.VueDirectiveInfo)attributeInfo).getDirectiveKind() == VueAttributeNameParser.VueDirectiveKind.BIND && Intrinsics.areEqual((Object)((VueAttributeNameParser.VueDirectiveInfo)attributeInfo).getArguments(), (Object)"name")) {
                return (JSType)new JSStringType(true, JSTypeSourceFactory.createTypeSource((PsiElement)element, (boolean)true), JSTypeContext.INSTANCE);
            }
        }
        return null;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isInjectCall(JSCallExpression element) {
        JSReferenceExpression jSReferenceExpression;
        JSCallExpression jSCallExpression;
        JSCallExpression it = jSCallExpression = element;
        boolean bl = false;
        JSCallExpression jSCallExpression2 = Intrinsics.areEqual((Object)VueFrameworkHandlerKt.getFunctionNameFromVueIndex(it), (Object)"inject") ? jSCallExpression : null;
        JSExpression $this$asSafely$iv = jSCallExpression2 != null ? jSCallExpression2.getMethodExpression() : null;
        boolean $i$f$asSafely = false;
        JSExpression jSExpression = $this$asSafely$iv;
        if (!(jSExpression instanceof JSReferenceExpression)) {
            jSExpression = null;
        }
        if ((jSReferenceExpression = (JSReferenceExpression)jSExpression) == null) return false;
        jSCallExpression2 = jSReferenceExpression.resolve();
        if (jSCallExpression2 == null) return false;
        PsiFile psiFile = jSCallExpression2.getContainingFile();
        if (psiFile == null) return false;
        VirtualFile virtualFile = psiFile.getVirtualFile();
        if (virtualFile == null) return false;
        VirtualFile it2 = virtualFile;
        boolean bl2 = false;
        VirtualFile virtualFile2 = NodeModuleSearchUtil.findDependencyRoot((VirtualFile)it2);
        if (virtualFile2 == null) return false;
        VirtualFile it3 = virtualFile2;
        boolean bl3 = false;
        if (Intrinsics.areEqual((Object)it3.getName(), (Object)"vue")) return true;
        VirtualFile virtualFile3 = it3.getParent();
        if (!Intrinsics.areEqual((Object)(virtualFile3 != null ? virtualFile3.getName() : null), (Object)"@vue")) return false;
        return true;
    }

    private final JSType getInjectType(JSCallExpression call) {
        VueComponent vueComponent = VueModelManager.Companion.findEnclosingComponent((JSElement)call);
        if (vueComponent == null) {
            return null;
        }
        VueComponent component = vueComponent;
        VueInject vueInject = VueProvideUtilsKt.findInjectForCall(call, component);
        if (vueInject == null) {
            return null;
        }
        VueInject inject = vueInject;
        return VueProvideUtilsKt.evaluateInjectedType(inject, VueGlobalImplKt.getProvides(component.getGlobal()));
    }

    private final boolean isTopmostVueExpression(PsiElement element, PsiElement parent) {
        return VueExprLanguagesKt.isVueExprMetaLanguage(element.getLanguage()) && (parent instanceof JSExpressionStatement && JSStubBasedPsiTreeUtil.getParentOrNull((PsiElement)parent) instanceof VueJSEmbeddedExpressionContent || element instanceof JSStringTemplateExpression && parent instanceof VueJSEmbeddedExpressionContent);
    }

    private final boolean isMethodHandler(PsiElement element) {
        return element instanceof JSReferenceExpression || element instanceof JSIndexedPropertyAccessExpression || element instanceof JSFunctionExpression;
    }

    private final JSType getPolySymbolType(XmlAttribute attribute) {
        JSType jSType;
        HtmlAttributeSymbolDescriptor htmlAttributeSymbolDescriptor;
        XmlAttributeDescriptor $this$asSafely$iv = attribute.getDescriptor();
        boolean $i$f$asSafely = false;
        XmlAttributeDescriptor xmlAttributeDescriptor = $this$asSafely$iv;
        if (!(xmlAttributeDescriptor instanceof HtmlAttributeSymbolDescriptor)) {
            xmlAttributeDescriptor = null;
        }
        if ((htmlAttributeSymbolDescriptor = (HtmlAttributeSymbolDescriptor)xmlAttributeDescriptor) != null && (htmlAttributeSymbolDescriptor = htmlAttributeSymbolDescriptor.getSymbol()) != null) {
            HtmlAttributeSymbolDescriptor $this$jsType$iv = htmlAttributeSymbolDescriptor;
            boolean $i$f$getJSType = false;
            jSType = (JSType)$this$jsType$iv.get(TypeScriptSymbolTypeSupportKt.PROP_JS_TYPE);
        } else {
            jSType = null;
        }
        return jSType;
    }
}

