/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.sql.dialects.mongo.js;

import com.intellij.codeInsight.daemon.impl.HighlightInfo;
import com.intellij.codeInsight.daemon.impl.HighlightInfoFilter;
import com.intellij.codeInsight.highlighting.HighlightErrorFilter;
import com.intellij.database.psi.DbDataSource;
import com.intellij.database.vfs.DbVFSUtils;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiFile;
import java.util.Locale;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u00012\u00020\u0002B\u0007\u00a2\u0006\u0004\b\u0003\u0010\u0004J\u001a\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u000b2\b\u0010\f\u001a\u0004\u0018\u00010\rH\u0016J\u0010\u0010\u000e\u001a\u00020\t2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016R\u0014\u0010\u0005\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0011"}, d2={"Lcom/intellij/sql/dialects/mongo/js/MongoJSHighlightInfoFilter;", "Lcom/intellij/codeInsight/highlighting/HighlightErrorFilter;", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfoFilter;", "<init>", "()V", "suppressedWarnings", "", "", "accept", "", "highlightInfo", "Lcom/intellij/codeInsight/daemon/impl/HighlightInfo;", "psiFile", "Lcom/intellij/psi/PsiFile;", "shouldHighlightErrorElement", "element", "Lcom/intellij/psi/PsiErrorElement;", "intellij.database.dialects.mongo"})
@SourceDebugExtension(value={"SMAP\nMongoJSHighlightInfoFilter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 MongoJSHighlightInfoFilter.kt\ncom/intellij/sql/dialects/mongo/js/MongoJSHighlightInfoFilter\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,32:1\n1#2:33\n*E\n"})
public final class MongoJSHighlightInfoFilter
extends HighlightErrorFilter
implements HighlightInfoFilter {
    @NotNull
    private final Set<String> suppressedWarnings;

    public MongoJSHighlightInfoFilter() {
        Object[] objectArray = new String[]{"JSUnresolvedReference", "UnterminatedStatementJS"};
        this.suppressedWarnings = SetsKt.setOf((Object[])objectArray);
    }

    public boolean accept(@NotNull HighlightInfo highlightInfo, @Nullable PsiFile psiFile) {
        Intrinsics.checkNotNullParameter((Object)highlightInfo, (String)"highlightInfo");
        PsiFile psiFile2 = psiFile;
        if (psiFile2 == null || (psiFile2 = psiFile2.getVirtualFile()) == null) {
            return true;
        }
        PsiFile vFile = psiFile2;
        DbDataSource dbDataSource = DbVFSUtils.getDataSource((Project)psiFile.getProject(), (VirtualFile)vFile);
        if (dbDataSource == null) {
            return true;
        }
        DbDataSource dataSource = dbDataSource;
        if (!dataSource.getDataSource().getDbms().isMongo()) {
            return true;
        }
        return !CollectionsKt.contains((Iterable)this.suppressedWarnings, (Object)highlightInfo.getInspectionToolId());
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean shouldHighlightErrorElement(@NotNull PsiErrorElement element) {
        String string;
        Intrinsics.checkNotNullParameter((Object)element, (String)"element");
        PsiFile psiFile = element.getContainingFile();
        if (psiFile == null) {
            return true;
        }
        PsiFile file = psiFile;
        VirtualFile virtualFile = file.getVirtualFile();
        if (virtualFile == null) {
            return true;
        }
        VirtualFile virtualFile2 = virtualFile;
        DbDataSource dataSource = DbVFSUtils.getDataSource((Project)element.getProject(), (VirtualFile)virtualFile2);
        if (dataSource == null) return true;
        if (!dataSource.getDbms().isMongo()) return true;
        Object object = element.getPrevSibling();
        if (object != null && (object = object.getText()) != null) {
            Object object2 = object;
            Locale locale = Locale.ENGLISH;
            Intrinsics.checkNotNullExpressionValue((Object)locale, (String)"ENGLISH");
            String string2 = ((String)object2).toLowerCase(locale);
            string = string2;
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        } else {
            string = null;
        }
        String prev2 = string;
        boolean bl = false;
        if (Intrinsics.areEqual(prev2, (Object)"show")) return false;
        if (Intrinsics.areEqual((Object)prev2, (Object)"use")) return false;
        return true;
    }
}

