/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.docker.agent.progress;

import com.github.dockerjava.api.model.ResponseItem;
import com.intellij.docker.agent.progress.DockerResponseItem;
import com.intellij.docker.agent.progress.ResponseItemCallbackTemplate;
import com.intellij.docker.agent.util.DockerErrorUtilKt;
import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.LinkedBlockingQueue;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0012\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0003\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0016\u0018\u0000*\b\b\u0000\u0010\u0001*\u00020\u00022\b\u0012\u0004\u0012\u0002H\u00010\u0003B\u001b\u0012\u0012\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005\u00a2\u0006\u0004\b\b\u0010\tJ\u0015\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00028\u0000H\u0014\u00a2\u0006\u0002\u0010\u0014J\u0010\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0018H\u0016J\u0017\u0010\u0019\u001a\u00020\u00162\b\u0010\u001a\u001a\u0004\u0018\u00018\u0000H\u0016\u00a2\u0006\u0002\u0010\u001bJ\u0010\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\b\u0010\u001f\u001a\u00020\u0016H\u0016J\u0012\u0010 \u001a\u0004\u0018\u00010!2\u0006\u0010\u001d\u001a\u00020\u001eH\u0014J\u0010\u0010\"\u001a\u00020\u00162\u0006\u0010\u001a\u001a\u00020!H\u0002J\b\u0010#\u001a\u00020\u0007H\u0002J\b\u0010$\u001a\u00020\u0016H\u0002R\u001a\u0010\u0004\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00070\u00060\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\f\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068BX\u0082\u0084\u0002\u00a2\u0006\f\n\u0004\b\u000f\u0010\u0010\u001a\u0004\b\r\u0010\u000e\u00a8\u0006%"}, d2={"Lcom/intellij/docker/agent/progress/PromisingSerializedItemsCallback;", "RI", "Lcom/github/dockerjava/api/model/ResponseItem;", "Lcom/intellij/docker/agent/progress/ResponseItemCallbackTemplate;", "result", "Ljava/util/concurrent/CompletableFuture;", "Ljava/util/concurrent/BlockingQueue;", "", "<init>", "(Ljava/util/concurrent/CompletableFuture;)V", "myIsClosed", "", "myChannel", "getMyChannel", "()Ljava/util/concurrent/BlockingQueue;", "myChannel$delegate", "Lkotlin/Lazy;", "wrapAgentItem", "Lcom/intellij/docker/agent/progress/DockerResponseItem$Builder;", "agentItem", "(Lcom/github/dockerjava/api/model/ResponseItem;)Lcom/intellij/docker/agent/progress/DockerResponseItem$Builder;", "onStart", "", "stream", "Ljava/io/Closeable;", "onNext", "item", "(Lcom/github/dockerjava/api/model/ResponseItem;)V", "doOnError", "throwable", "", "onComplete", "wrapError", "Lcom/intellij/docker/agent/progress/DockerResponseItem$Impl;", "sendResponseItem", "signalClosed", "closeChannel", "intellij.clouds.docker.agent"})
@SourceDebugExtension(value={"SMAP\nPromisingSerializedItemsCallback.kt\nKotlin\n*S Kotlin\n*F\n+ 1 PromisingSerializedItemsCallback.kt\ncom/intellij/docker/agent/progress/PromisingSerializedItemsCallback\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,75:1\n1#2:76\n*E\n"})
public class PromisingSerializedItemsCallback<RI extends ResponseItem>
extends ResponseItemCallbackTemplate<RI> {
    @NotNull
    private final CompletableFuture<BlockingQueue<byte[]>> result;
    private volatile boolean myIsClosed;
    @NotNull
    private final Lazy myChannel$delegate;

    public PromisingSerializedItemsCallback(@NotNull CompletableFuture<BlockingQueue<byte[]>> result2) {
        Intrinsics.checkNotNullParameter(result2, (String)"result");
        this.result = result2;
        this.myChannel$delegate = LazyKt.lazy(() -> PromisingSerializedItemsCallback.myChannel_delegate$lambda$1(this));
    }

    private final BlockingQueue<byte[]> getMyChannel() {
        Lazy lazy = this.myChannel$delegate;
        return (BlockingQueue)lazy.getValue();
    }

    @NotNull
    protected DockerResponseItem.Builder wrapAgentItem(@NotNull RI agentItem) {
        Intrinsics.checkNotNullParameter(agentItem, (String)"agentItem");
        return DockerResponseItem.Companion.fromAgentItem((ResponseItem)agentItem);
    }

    public void onStart(@NotNull Closeable stream) {
        Intrinsics.checkNotNullParameter((Object)stream, (String)"stream");
        this.getMyChannel();
        super.onStart(stream);
    }

    public void onNext(@Nullable RI item) {
        if (item != null && !this.myIsClosed) {
            DockerResponseItem.Impl impl = this.wrapAgentItem(item).build();
            this.sendResponseItem(impl);
        }
    }

    @Override
    protected void doOnError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        DockerResponseItem.Impl impl = this.wrapError(throwable);
        if (impl != null) {
            DockerResponseItem.Impl it = impl;
            boolean bl = false;
            this.sendResponseItem(it);
        }
        this.closeChannel();
    }

    public void onComplete() {
        super.onComplete();
        this.closeChannel();
    }

    @Nullable
    protected DockerResponseItem.Impl wrapError(@NotNull Throwable throwable) {
        Intrinsics.checkNotNullParameter((Object)throwable, (String)"throwable");
        return new DockerResponseItem.Builder().withError(0, DockerErrorUtilKt.dockerUserFriendlyMessage(throwable)).build();
    }

    private final void sendResponseItem(DockerResponseItem.Impl item) {
        try {
            byte[] bytes = item.toByteArray();
            this.getMyChannel().add(bytes);
        }
        catch (IOException e) {
            this.closeChannel();
        }
    }

    private final byte[] signalClosed() {
        return new byte[0];
    }

    private final void closeChannel() {
        if (!this.myIsClosed) {
            this.getMyChannel().add(this.signalClosed());
            this.myIsClosed = true;
        }
    }

    private static final LinkedBlockingQueue myChannel_delegate$lambda$1(PromisingSerializedItemsCallback this$0) {
        LinkedBlockingQueue linkedBlockingQueue;
        LinkedBlockingQueue it = linkedBlockingQueue = new LinkedBlockingQueue();
        boolean bl = false;
        this$0.result.complete(it);
        return linkedBlockingQueue;
    }
}

