/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.plugins.markdown.model.psi.labels;

import com.intellij.model.Symbol;
import com.intellij.model.psi.PsiExternalReferenceHost;
import com.intellij.model.psi.PsiSymbolReference;
import com.intellij.model.psi.PsiSymbolReferenceHints;
import com.intellij.model.psi.PsiSymbolReferenceProvider;
import com.intellij.model.search.SearchRequest;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.openapi.util.registry.Registry;
import com.intellij.psi.PsiElement;
import java.util.Collection;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import org.intellij.plugins.markdown.lang.psi.impl.MarkdownLinkLabel;
import org.intellij.plugins.markdown.model.psi.labels.LinkLabelSymbol;
import org.intellij.plugins.markdown.model.psi.labels.LinkLabelSymbolReference;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0000\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u001e\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nH\u0016J\u001e\u0010\u000b\u001a\b\u0012\u0004\u0012\u00020\f0\u00052\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010H\u0016\u00a8\u0006\u0011"}, d2={"Lorg/intellij/plugins/markdown/model/psi/labels/LinkLabelSymbolReferenceProvider;", "Lcom/intellij/model/psi/PsiSymbolReferenceProvider;", "<init>", "()V", "getReferences", "", "Lcom/intellij/model/psi/PsiSymbolReference;", "element", "Lcom/intellij/model/psi/PsiExternalReferenceHost;", "hints", "Lcom/intellij/model/psi/PsiSymbolReferenceHints;", "getSearchRequests", "Lcom/intellij/model/search/SearchRequest;", "project", "Lcom/intellij/openapi/project/Project;", "target", "Lcom/intellij/model/Symbol;", "intellij.markdown.model"})
public final class LinkLabelSymbolReferenceProvider
implements PsiSymbolReferenceProvider {
    @NotNull
    public Collection<PsiSymbolReference> getReferences(@NotNull PsiExternalReferenceHost element2, @NotNull PsiSymbolReferenceHints hints) {
        Intrinsics.checkNotNullParameter((Object)element2, (String)"element");
        Intrinsics.checkNotNullParameter((Object)hints, (String)"hints");
        if (!(element2 instanceof MarkdownLinkLabel) || LinkLabelSymbol.Companion.isDeclaration((MarkdownLinkLabel)element2)) {
            return CollectionsKt.emptyList();
        }
        if (LinkLabelSymbol.Companion.isShortLink((MarkdownLinkLabel)element2) && !Registry.Companion.is("markdown.validate.short.links")) {
            return CollectionsKt.emptyList();
        }
        TextRange rangeInElement = new TextRange(0, ((MarkdownLinkLabel)element2).getTextLength());
        String text2 = ((MarkdownLinkLabel)element2).getText();
        PsiElement psiElement = (PsiElement)element2;
        Intrinsics.checkNotNull((Object)text2);
        LinkLabelSymbolReference reference = new LinkLabelSymbolReference(psiElement, rangeInElement, text2);
        return CollectionsKt.listOf((Object)reference);
    }

    @NotNull
    public Collection<SearchRequest> getSearchRequests(@NotNull Project project, @NotNull Symbol target) {
        Intrinsics.checkNotNullParameter((Object)project, (String)"project");
        Intrinsics.checkNotNullParameter((Object)target, (String)"target");
        return CollectionsKt.emptyList();
    }
}

