/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.api;

import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.api.Failure;
import com.intellij.profiler.api.ProfilerDumpFileParsingResult;
import java.io.File;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000$\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0004\bf\u0018\u0000 \f2\u00020\u0001:\u0001\fJ\u0018\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H&R\u0014\u0010\b\u001a\u0004\u0018\u00010\tX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\n\u0010\u000b\u00f8\u0001\u0000\u0082\u0002\u0006\n\u0004\b!0\u0001\u00a8\u0006\r\u00c0\u0006\u0001"}, d2={"Lcom/intellij/profiler/api/ProfilerDumpFileParser;", "", "parse", "Lcom/intellij/profiler/api/ProfilerDumpFileParsingResult;", "file", "Ljava/io/File;", "indicator", "Lcom/intellij/openapi/progress/ProgressIndicator;", "helpId", "", "getHelpId", "()Ljava/lang/String;", "Companion", "intellij.profiler.common"})
public interface ProfilerDumpFileParser {
    @NotNull
    public static final Companion Companion = com.intellij.profiler.api.ProfilerDumpFileParser$Companion.$$INSTANCE;

    @NotNull
    public ProfilerDumpFileParsingResult parse(@NotNull File var1, @NotNull ProgressIndicator var2);

    @Nullable
    public String getHelpId();

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0010\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lcom/intellij/profiler/api/ProfilerDumpFileParser$Companion;", "", "<init>", "()V", "validate", "Lcom/intellij/profiler/api/Failure;", "file", "Ljava/io/File;", "intellij.profiler.common"})
    public static final class Companion {
        static final /* synthetic */ Companion $$INSTANCE;

        private Companion() {
        }

        @Nullable
        public final Failure validate(@NotNull File file) {
            String string;
            Intrinsics.checkNotNullParameter((Object)file, (String)"file");
            if (!file.exists()) {
                string = CommonProfilerBundleKt.commonProfilerMessage("profiler.error.dumpIsMissing", new Object[0]);
            } else if (file.isDirectory()) {
                string = CommonProfilerBundleKt.commonProfilerMessage("profiler.error.importingDirectory", new Object[0]);
            } else if (file.length() == 0L) {
                string = CommonProfilerBundleKt.commonProfilerMessage("profiler.error.dumpIsEmpty", new Object[0]);
            } else {
                return null;
            }
            String description = string;
            Object[] objectArray = new Object[2];
            Intrinsics.checkNotNullExpressionValue((Object)file.getAbsolutePath(), (String)"getAbsolutePath(...)");
            objectArray[1] = description;
            return new Failure(CommonProfilerBundleKt.commonProfilerMessage("profiler.action.import.error.description", objectArray));
        }

        static {
            $$INSTANCE = new Companion();
        }
    }
}

