/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.profiler.ui.diff;

import com.intellij.profiler.CommonProfilerBundleKt;
import com.intellij.profiler.ui.ProfilerUIUtilsKt;
import com.intellij.profiler.ui.flamechart.FlameChartColors;
import com.intellij.ui.SimpleTextAttributes;
import java.awt.Color;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

/*
 * Uses 'sealed' constructs - enablewith --sealed true
 */
@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\b0\u0018\u0000 \u00182\u00020\u0001:\u0004\u0015\u0016\u0017\u0018B\t\b\u0004\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0017\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0007\u0010\bR\u0012\u0010\t\u001a\u00020\nX\u00a6\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\r\u001a\u00020\u000e8F\u00a2\u0006\u0006\u001a\u0004\b\u000f\u0010\u0010R\u0011\u0010\u0011\u001a\u00020\u00128F\u00a2\u0006\u0006\u001a\u0004\b\u0013\u0010\u0014\u0082\u0001\u0003\u0019\u001a\u001b\u00a8\u0006\u001c"}, d2={"Lcom/intellij/profiler/ui/diff/UiDiffKind;", "", "<init>", "()V", "text", "", "Lorg/jetbrains/annotations/Nls;", "getText", "()Ljava/lang/String;", "fraction", "", "getFraction", "()D", "foreground", "Ljava/awt/Color;", "getForeground", "()Ljava/awt/Color;", "style", "Lcom/intellij/ui/SimpleTextAttributes;", "getStyle", "()Lcom/intellij/ui/SimpleTextAttributes;", "Removed", "Added", "Changed", "Companion", "Lcom/intellij/profiler/ui/diff/UiDiffKind$Added;", "Lcom/intellij/profiler/ui/diff/UiDiffKind$Changed;", "Lcom/intellij/profiler/ui/diff/UiDiffKind$Removed;", "intellij.profiler.common"})
@SourceDebugExtension(value={"SMAP\nUiDiffKind.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiDiffKind.kt\ncom/intellij/profiler/ui/diff/UiDiffKind\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
public abstract class UiDiffKind {
    @NotNull
    public static final Companion Companion = new Companion(null);

    private UiDiffKind() {
    }

    @NotNull
    public abstract String getText();

    public abstract double getFraction();

    @NotNull
    public final Color getForeground() {
        double it = this.getFraction();
        boolean bl = false;
        return it > 0.0 ? FlameChartColors.INSTANCE.getFireColor$intellij_profiler_common(it) : FlameChartColors.INSTANCE.getGreenColor$intellij_profiler_common(-it);
    }

    @NotNull
    public final SimpleTextAttributes getStyle() {
        return new SimpleTextAttributes(0, this.getForeground());
    }

    public /* synthetic */ UiDiffKind(DefaultConstructorMarker $constructor_marker) {
        this();
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0019\u0010\u0004\u001a\u00070\u0005\u00a2\u0006\u0002\b\u0006X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\nX\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\r"}, d2={"Lcom/intellij/profiler/ui/diff/UiDiffKind$Added;", "Lcom/intellij/profiler/ui/diff/UiDiffKind;", "<init>", "()V", "text", "", "Lorg/jetbrains/annotations/Nls;", "getText", "()Ljava/lang/String;", "fraction", "", "getFraction", "()D", "intellij.profiler.common"})
    public static final class Added
    extends UiDiffKind {
        @NotNull
        public static final Added INSTANCE = new Added();
        @NotNull
        private static final String text = CommonProfilerBundleKt.profilerMessage("ui.flamechart.tooltip.added", new Object[0]);
        private static final double fraction = 1.0;

        private Added() {
            super(null);
        }

        @Override
        @NotNull
        public String getText() {
            return text;
        }

        @Override
        public double getFraction() {
            return fraction;
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000&\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0004\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0005\u0010\u0006R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0007\u001a\u00020\b8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0019\u0010\u000b\u001a\u00070\f\u00a2\u0006\u0002\b\r8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\u000f\u00a8\u0006\u0010"}, d2={"Lcom/intellij/profiler/ui/diff/UiDiffKind$Changed;", "Lcom/intellij/profiler/ui/diff/UiDiffKind;", "oldValue", "", "newValue", "<init>", "(JJ)V", "fraction", "", "getFraction", "()D", "text", "", "Lorg/jetbrains/annotations/Nls;", "getText", "()Ljava/lang/String;", "intellij.profiler.common"})
    @SourceDebugExtension(value={"SMAP\nUiDiffKind.kt\nKotlin\n*S Kotlin\n*F\n+ 1 UiDiffKind.kt\ncom/intellij/profiler/ui/diff/UiDiffKind$Changed\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,47:1\n1#2:48\n*E\n"})
    public static final class Changed
    extends UiDiffKind {
        private final long oldValue;
        private final long newValue;

        public Changed(long oldValue, long newValue) {
            super(null);
            this.oldValue = oldValue;
            this.newValue = newValue;
            if (!(this.oldValue > 0L)) {
                boolean $i$a$-require-UiDiffKind$Changed$32 = false;
                String $i$a$-require-UiDiffKind$Changed$32 = "Wrong kind, should be Added";
                throw new IllegalArgumentException($i$a$-require-UiDiffKind$Changed$32.toString());
            }
            if (!(this.newValue > 0L)) {
                boolean bl = false;
                String string = "Wrong kind, should be Removed";
                throw new IllegalArgumentException(string.toString());
            }
        }

        @Override
        public double getFraction() {
            return (double)this.newValue / (double)this.oldValue - 1.0;
        }

        @Override
        @NotNull
        public String getText() {
            return ProfilerUIUtilsKt.fractionToString$default(this.getFraction(), 0.0, true, false, 8, null);
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001a\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\t\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u0016\u0010\u0004\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\u0007\u00a8\u0006\t"}, d2={"Lcom/intellij/profiler/ui/diff/UiDiffKind$Companion;", "", "<init>", "()V", "from", "Lcom/intellij/profiler/ui/diff/UiDiffKind;", "oldValue", "", "newValue", "intellij.profiler.common"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final UiDiffKind from(long oldValue, long newValue) {
            return newValue == 0L ? (UiDiffKind)Removed.INSTANCE : (oldValue == 0L ? (UiDiffKind)Added.INSTANCE : (UiDiffKind)new Changed(oldValue, newValue));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0006\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\b\u00c6\u0002\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0004\u001a\u00020\u0005X\u0096D\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0006\u0010\u0007R\u0014\u0010\b\u001a\u00020\tX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006\f"}, d2={"Lcom/intellij/profiler/ui/diff/UiDiffKind$Removed;", "Lcom/intellij/profiler/ui/diff/UiDiffKind;", "<init>", "()V", "fraction", "", "getFraction", "()D", "text", "", "getText", "()Ljava/lang/String;", "intellij.profiler.common"})
    public static final class Removed
    extends UiDiffKind {
        @NotNull
        public static final Removed INSTANCE = new Removed();
        private static final double fraction = -1.0;
        @NotNull
        private static final String text = ProfilerUIUtilsKt.fractionToString$default(INSTANCE.getFraction(), 0.0, false, false, 14, null);

        private Removed() {
            super(null);
        }

        @Override
        public double getFraction() {
            return fraction;
        }

        @Override
        @NotNull
        public String getText() {
            return text;
        }
    }
}

