/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.platform.trialPromotion.idesWithFreeTier;

import com.intellij.ide.ui.laf.darcula.DarculaNewUIUtil;
import com.intellij.platform.trialPromotion.common.TrialUi;
import com.intellij.platform.trialPromotion.common.TrialWidgetColorState;
import com.intellij.util.ui.JBFont;
import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import javax.swing.JComponent;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.ApiStatus;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000B\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u000e\n\u0002\u0010\u000e\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0007\u0018\u00002\u00020\u0001B\u0007\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u001f\u001a\u00020 2\u0006\u0010\u001d\u001a\u00020\u001eJ\b\u0010!\u001a\u00020 H\u0016J\u0010\u0010\"\u001a\u00020 2\u0006\u0010#\u001a\u00020$H\u0014J\b\u0010%\u001a\u00020&H\u0016J\b\u0010'\u001a\u00020&H\u0016J\b\u0010(\u001a\u00020&H\u0002R\u001c\u0010\u0004\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0006\u0010\u0007\"\u0004\b\b\u0010\tR\u001c\u0010\n\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000b\u0010\u0007\"\u0004\b\f\u0010\tR\u001c\u0010\r\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u000e\u0010\u0007\"\u0004\b\u000f\u0010\tR\u001c\u0010\u0010\u001a\u0004\u0018\u00010\u0005X\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0011\u0010\u0007\"\u0004\b\u0012\u0010\tR2\u0010\u0016\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u00152\r\u0010\u0013\u001a\t\u0018\u00010\u0014\u00a2\u0006\u0002\b\u0015@FX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\u0017\u0010\u0018\"\u0004\b\u0019\u0010\u001aR\u000e\u0010\u001b\u001a\u00020\u001cX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u0010\u0010\u001d\u001a\u0004\u0018\u00010\u001eX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006)"}, d2={"Lcom/intellij/platform/trialPromotion/idesWithFreeTier/TrialStateButton;", "Ljavax/swing/JComponent;", "<init>", "()V", "borderColor", "Ljava/awt/Color;", "getBorderColor", "()Ljava/awt/Color;", "setBorderColor", "(Ljava/awt/Color;)V", "hoverForeground", "getHoverForeground", "setHoverForeground", "hoverBackground", "getHoverBackground", "setHoverBackground", "hoverBorderColor", "getHoverBorderColor", "setHoverBorderColor", "value", "", "Lcom/intellij/openapi/util/NlsContexts$Button;", "text", "getText", "()Ljava/lang/String;", "setText", "(Ljava/lang/String;)V", "hovered", "", "colorState", "Lcom/intellij/platform/trialPromotion/common/TrialWidgetColorState;", "setColorState", "", "updateUI", "paintComponent", "g", "Ljava/awt/Graphics;", "getMinimumSize", "Ljava/awt/Dimension;", "getPreferredSize", "getTextDimension", "intellij.platform.trialPromotion.idesWithFreeTier"})
@ApiStatus.Internal
public final class TrialStateButton
extends JComponent {
    @Nullable
    private Color borderColor;
    @Nullable
    private Color hoverForeground;
    @Nullable
    private Color hoverBackground;
    @Nullable
    private Color hoverBorderColor;
    @Nullable
    private String text;
    private boolean hovered;
    @Nullable
    private TrialWidgetColorState colorState;

    public TrialStateButton() {
        this.setOpaque(false);
        this.setFont((Font)JBFont.regular().deriveFont(13.0f));
        this.setColorState(TrialWidgetColorState.DEFAULT);
        this.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                hovered = true;
                this.repaint();
            }

            @Override
            public void mouseExited(MouseEvent e) {
                hovered = false;
                this.repaint();
            }
        });
    }

    @Nullable
    public final Color getBorderColor() {
        return this.borderColor;
    }

    public final void setBorderColor(@Nullable Color color) {
        this.borderColor = color;
    }

    @Nullable
    public final Color getHoverForeground() {
        return this.hoverForeground;
    }

    public final void setHoverForeground(@Nullable Color color) {
        this.hoverForeground = color;
    }

    @Nullable
    public final Color getHoverBackground() {
        return this.hoverBackground;
    }

    public final void setHoverBackground(@Nullable Color color) {
        this.hoverBackground = color;
    }

    @Nullable
    public final Color getHoverBorderColor() {
        return this.hoverBorderColor;
    }

    public final void setHoverBorderColor(@Nullable Color color) {
        this.hoverBorderColor = color;
    }

    @Nullable
    public final String getText() {
        return this.text;
    }

    public final void setText(@Nullable String value) {
        if (!Intrinsics.areEqual((Object)this.text, (Object)value)) {
            this.text = value;
            this.revalidate();
            this.repaint();
        }
    }

    public final void setColorState(@NotNull TrialWidgetColorState colorState) {
        Intrinsics.checkNotNullParameter((Object)colorState, (String)"colorState");
        if (colorState == this.colorState) {
            return;
        }
        this.colorState = colorState;
        this.setForeground(colorState.getForeground());
        this.setBackground(colorState.getBackground());
        this.borderColor = colorState.getBorderColor();
        this.hoverForeground = colorState.getHoverForeground();
        this.hoverBackground = colorState.getHoverBackground();
        this.hoverBorderColor = colorState.getHoverBorderColor();
        this.repaint();
    }

    @Override
    public void updateUI() {
        super.updateUI();
        TrialWidgetColorState currentColorState = this.colorState;
        if (currentColorState != null) {
            this.colorState = null;
            this.setColorState(currentColorState);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void paintComponent(@NotNull Graphics g) {
        Intrinsics.checkNotNullParameter((Object)g, (String)"g");
        Rectangle rect = new Rectangle(0, 0, this.getWidth(), this.getHeight());
        float arc = this.getHeight();
        Graphics graphics = g.create();
        Intrinsics.checkNotNull((Object)graphics, (String)"null cannot be cast to non-null type java.awt.Graphics2D");
        Graphics2D g2 = (Graphics2D)graphics;
        try {
            Color background;
            DarculaNewUIUtil.INSTANCE.setupRenderingHints(g2);
            Color borderColor = this.hovered ? this.hoverBorderColor : this.borderColor;
            Color color = background = this.hovered ? this.hoverBackground : this.getBackground();
            if (borderColor == null || borderColor.getAlpha() == 0 || Intrinsics.areEqual((Object)background, (Object)borderColor)) {
                Color color2 = background;
                if (color2 != null) {
                    Color it = color2;
                    boolean bl = false;
                    DarculaNewUIUtil.INSTANCE.fillRoundedRectangle((Graphics)g2, rect, it, arc);
                }
            } else {
                Color color3 = background;
                if (color3 != null) {
                    Color it = color3;
                    boolean bl = false;
                    DarculaNewUIUtil.INSTANCE.fillInsideComponentBorder((Graphics)g2, rect, it, arc);
                }
                DarculaNewUIUtil.INSTANCE.drawRoundedRectangle((Graphics)g2, rect, borderColor, arc, 1.5f);
            }
            String string = this.text;
            if (string != null) {
                String it = string;
                boolean bl = false;
                FontMetrics fontMetrics = this.getFontMetrics(this.getFont());
                int offset = (rect.height - TrialUi.INSTANCE.getTEXT_GAPS().getHeight() - this.getFontMetrics(this.getFont()).getHeight()) / 2;
                g2.setColor(this.hovered ? this.hoverForeground : this.getForeground());
                g2.setFont(this.getFont());
                g2.drawString(it, TrialUi.INSTANCE.getTEXT_GAPS().getLeft(), TrialUi.INSTANCE.getTEXT_GAPS().getTop() + offset + fontMetrics.getAscent());
            }
        }
        finally {
            g2.dispose();
        }
    }

    @Override
    @NotNull
    public Dimension getMinimumSize() {
        return this.getPreferredSize();
    }

    @Override
    @NotNull
    public Dimension getPreferredSize() {
        Dimension textDimension = this.getTextDimension();
        return new Dimension(textDimension.width + TrialUi.INSTANCE.getTEXT_GAPS().getWidth(), textDimension.height + TrialUi.INSTANCE.getTEXT_GAPS().getHeight());
    }

    private final Dimension getTextDimension() {
        Font font = this.getFont();
        if (font == null) {
            return new Dimension(0, 13);
        }
        Font font2 = font;
        String text = this.text;
        FontMetrics fontMetrics = this.getFontMetrics(font2);
        String string = text;
        int width = string == null ? 0 : fontMetrics.stringWidth(string);
        return new Dimension(width, fontMetrics.getHeight());
    }
}

