/*
 * Decompiled with CFR 0.152.
 */
package com.oracle.truffle.host;

import com.oracle.truffle.api.CompilerDirectives;
import com.oracle.truffle.api.TruffleOptions;
import com.oracle.truffle.host.HostAdapterClassLoader;
import com.oracle.truffle.host.HostClassDesc;
import com.oracle.truffle.host.HostObject;
import com.oracle.truffle.host.HostTargetMapping;
import java.lang.invoke.MethodHandles;
import java.lang.ref.WeakReference;
import java.lang.reflect.Constructor;
import java.lang.reflect.Executable;
import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.graalvm.polyglot.impl.AbstractPolyglotImpl;

final class HostClassCache {
    static final HostTargetMapping[] EMPTY_MAPPINGS = new HostTargetMapping[0];
    final AbstractPolyglotImpl.APIAccess apiAccess;
    final Object hostAccess;
    final AbstractPolyglotImpl.AbstractHostAccess polyglotHostAccess;
    private final boolean arrayAccess;
    private final boolean listAccess;
    private final boolean bufferAccess;
    private final boolean iterableAccess;
    private final boolean iteratorAccess;
    private final boolean mapAccess;
    private final boolean bigIntegerNumberAccess;
    final boolean allowsPublicAccess;
    final boolean allowsAccessInheritance;
    private final Map<Class<?>, Object> targetMappings;
    private final MethodHandles.Lookup methodLookup;
    private final WeakReference<HostClassCache> weakHostClassRef = new WeakReference<HostClassCache>(this);
    private final ClassValue<HostClassDesc> descs = new ClassValue<HostClassDesc>(){

        @Override
        protected HostClassDesc computeValue(Class<?> type) {
            return new HostClassDesc(HostClassCache.this.weakHostClassRef, type);
        }
    };

    private HostClassCache(AbstractPolyglotImpl.AbstractHostAccess polyglotAccess, AbstractPolyglotImpl.APIAccess apiAccess, Object hostAccess) {
        this.polyglotHostAccess = polyglotAccess;
        this.hostAccess = hostAccess;
        this.apiAccess = apiAccess;
        this.arrayAccess = apiAccess.isArrayAccessible(hostAccess);
        this.listAccess = apiAccess.isListAccessible(hostAccess);
        this.bufferAccess = apiAccess.isBufferAccessible(hostAccess);
        this.iterableAccess = apiAccess.isIterableAccessible(hostAccess);
        this.iteratorAccess = apiAccess.isIteratorAccessible(hostAccess);
        this.mapAccess = apiAccess.isMapAccessible(hostAccess);
        this.bigIntegerNumberAccess = apiAccess.isBigIntegerAccessibleAsNumber(hostAccess);
        this.allowsPublicAccess = apiAccess.allowsPublicAccess(hostAccess);
        this.allowsAccessInheritance = apiAccess.allowsAccessInheritance(hostAccess);
        this.targetMappings = HostClassCache.groupMappings(apiAccess, hostAccess);
        this.methodLookup = apiAccess.getMethodLookup(hostAccess);
    }

    MethodHandles.Lookup getMethodLookup(Class<?> clazz) {
        return this.methodLookup == null || clazz != null && !clazz.getModule().isNamed() ? MethodHandles.publicLookup() : this.methodLookup;
    }

    boolean hasCustomNamedLookup() {
        return this.methodLookup != null && this.methodLookup.lookupClass().getModule().isNamed();
    }

    boolean hasTargetMappings() {
        return this.targetMappings != null;
    }

    @CompilerDirectives.TruffleBoundary
    HostTargetMapping[] getMappings(Class<?> targetType) {
        if (this.targetMappings != null) {
            Class<Object> lookupType = targetType.isPrimitive() ? (targetType == Byte.TYPE ? Byte.class : (targetType == Short.TYPE ? Short.class : (targetType == Integer.TYPE ? Integer.class : (targetType == Long.TYPE ? Long.class : (targetType == Float.TYPE ? Float.class : (targetType == Double.TYPE ? Double.class : (targetType == Boolean.TYPE ? Boolean.class : (targetType == Character.TYPE ? Character.class : (targetType == Void.TYPE ? Void.class : null))))))))) : targetType;
            HostTargetMapping[] mappings = (HostTargetMapping[])this.targetMappings.get(lookupType);
            if (mappings == null) {
                return EMPTY_MAPPINGS;
            }
            return mappings;
        }
        return EMPTY_MAPPINGS;
    }

    private static Map<Class<?>, Object> groupMappings(AbstractPolyglotImpl.APIAccess apiAccess, Object hostAccess) {
        List<Object> mappings = apiAccess.getTargetMappings(hostAccess);
        if (mappings == null) {
            return null;
        }
        HashMap localMappings = new HashMap();
        for (Object object : mappings) {
            HostTargetMapping map = (HostTargetMapping)object;
            ArrayList<HostTargetMapping> list = (ArrayList<HostTargetMapping>)localMappings.get(map.targetType);
            if (list == null) {
                list = new ArrayList<HostTargetMapping>();
                localMappings.put(map.targetType, list);
            }
            list.add(map);
        }
        for (Map.Entry entry : localMappings.entrySet()) {
            List classMappings = (List)entry.getValue();
            Collections.sort(classMappings);
            entry.setValue(classMappings.toArray(EMPTY_MAPPINGS));
        }
        return localMappings;
    }

    public static HostClassCache findOrInitialize(AbstractPolyglotImpl.AbstractHostAccess hostLanguage, AbstractPolyglotImpl.APIAccess apiAccess, Object hostAccess) {
        HostClassCache cache = (HostClassCache)apiAccess.getHostAccessImpl(hostAccess);
        if (cache == null) {
            cache = HostClassCache.initializeHostCache(hostLanguage, apiAccess, hostAccess);
        }
        return cache;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static HostClassCache initializeHostCache(AbstractPolyglotImpl.AbstractHostAccess polyglotAccess, AbstractPolyglotImpl.APIAccess apiAccess, Object hostAccess) {
        HostClassCache cache;
        Object object = hostAccess;
        synchronized (object) {
            cache = (HostClassCache)apiAccess.getHostAccessImpl(hostAccess);
            if (cache == null) {
                cache = new HostClassCache(polyglotAccess, apiAccess, hostAccess);
                apiAccess.setHostAccessImpl(hostAccess, cache);
            }
        }
        return cache;
    }

    @CompilerDirectives.TruffleBoundary
    public static HostClassCache forInstance(HostObject receiver) {
        return receiver.context.getHostClassCache();
    }

    @CompilerDirectives.TruffleBoundary
    HostClassDesc forClass(Class<?> clazz) {
        return this.descs.get(clazz);
    }

    @CompilerDirectives.TruffleBoundary
    boolean allowsAccess(Method m) {
        return this.apiAccess.allowsAccess(this.hostAccess, m) || HostClassCache.isGeneratedClassMember(m);
    }

    @CompilerDirectives.TruffleBoundary
    boolean allowsAccess(Constructor<?> m) {
        return this.apiAccess.allowsAccess(this.hostAccess, m) || HostClassCache.isGeneratedClassMember(m);
    }

    @CompilerDirectives.TruffleBoundary
    boolean allowsAccess(Field f) {
        return this.apiAccess.allowsAccess(this.hostAccess, f) || HostClassCache.isGeneratedClassMember(f);
    }

    private static boolean isGeneratedClassMember(Member member) {
        if (TruffleOptions.AOT) {
            return false;
        }
        return HostAdapterClassLoader.isGeneratedClass(member.getDeclaringClass());
    }

    boolean isArrayAccess() {
        return this.arrayAccess;
    }

    boolean isListAccess() {
        return this.listAccess;
    }

    boolean isBufferAccess() {
        return this.bufferAccess;
    }

    boolean isIterableAccess() {
        return this.iterableAccess;
    }

    boolean isIteratorAccess() {
        return this.iteratorAccess;
    }

    boolean isMapAccess() {
        return this.mapAccess;
    }

    public boolean isBigIntegerNumberAccess() {
        return this.bigIntegerNumberAccess;
    }

    boolean allowsImplementation(Class<?> type) {
        return this.apiAccess.allowsImplementation(this.hostAccess, type);
    }

    boolean methodScoped(Executable e) {
        return this.apiAccess.isMethodScoped(this.hostAccess, e);
    }
}

