/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.python.django.lang.template;

import com.google.common.collect.Collections2;
import com.google.common.collect.Maps;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtilCore;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.newvfs.BulkFileListener;
import com.intellij.openapi.vfs.newvfs.events.VFileEvent;
import com.intellij.psi.NavigatablePsiElement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiNamedElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.SofterReference;
import com.intellij.util.messages.MessageBusConnection;
import com.jetbrains.django.DjangoFQNamesProvider;
import com.jetbrains.django.codeInsight.DjangoSettingsPy;
import com.jetbrains.django.facet.DjangoFacet;
import com.jetbrains.django.model.DjangoTemplateManager;
import com.jetbrains.django.model.TemplateParametersEvaluator;
import com.jetbrains.django.model.modelApi.DjangoModelApi;
import com.jetbrains.django.util.DjangoPsiUtil;
import com.jetbrains.python.extensions.python.PyCallExpressionExtKt;
import com.jetbrains.python.nameResolver.FQNamesProvider;
import com.jetbrains.python.psi.PyCallExpression;
import com.jetbrains.python.psi.PyClass;
import com.jetbrains.python.psi.PyExpression;
import com.jetbrains.python.psi.PyFunction;
import com.jetbrains.python.psi.PyImportStatementBase;
import com.jetbrains.python.psi.PyTupleExpression;
import com.jetbrains.python.psi.impl.PyPsiUtils;
import com.jetbrains.python.psi.types.TypeEvalContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DjangoWebUrlEvaluator
implements Disposable {
    private final Map<PsiElement, SofterReference<String>> myCache;
    private final Set<VirtualFile> myUsedFilesSet;

    public DjangoWebUrlEvaluator(@NotNull Project project) {
        if (project == null) {
            DjangoWebUrlEvaluator.$$$reportNull$$$0(0);
        }
        this.myCache = Maps.newHashMap();
        this.myUsedFilesSet = new HashSet<VirtualFile>();
        MessageBusConnection messageBusConnection = project.getMessageBus().connect((Disposable)this);
        messageBusConnection.subscribe(VirtualFileManager.VFS_CHANGES, (Object)new BulkFileListener(){

            public void after(@NotNull @NotNull List<? extends @NotNull VFileEvent> events) {
                if (events == null) {
                    1.$$$reportNull$$$0(0);
                }
                for (VFileEvent vFileEvent : events) {
                    if (!DjangoWebUrlEvaluator.this.myUsedFilesSet.contains(vFileEvent.getFile())) continue;
                    DjangoWebUrlEvaluator.this.clearCache();
                    break;
                }
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "events", "com/intellij/python/django/lang/template/DjangoWebUrlEvaluator$1", "after"));
            }
        });
    }

    private void clearCache() {
        this.myCache.clear();
        this.myUsedFilesSet.clear();
    }

    public static DjangoWebUrlEvaluator getInstance(@NotNull Project project) {
        if (project == null) {
            DjangoWebUrlEvaluator.$$$reportNull$$$0(1);
        }
        return (DjangoWebUrlEvaluator)project.getService(DjangoWebUrlEvaluator.class);
    }

    @NotNull
    private List<NavigatablePsiElement> computeUrlReferences(PsiElement element) {
        NavigatablePsiElement ex;
        ArrayList<NavigatablePsiElement> urlReferences = new ArrayList<NavigatablePsiElement>();
        if (element instanceof PsiFile && (ex = this.getReferenceFromUrlsToTemplate((PsiFile)element)) != null) {
            urlReferences.add(ex);
        }
        if (!urlReferences.isEmpty()) {
            PyExpression refFromUrl;
            while (!DjangoWebUrlEvaluator.isRootConf(DjangoPsiUtil.getFile((PsiElement)((PsiElement)urlReferences.get(urlReferences.size() - 1)))) && (refFromUrl = this.searchForReferenceInAllUrlsFiles((PsiNamedElement)DjangoPsiUtil.getFile((PsiElement)((PsiElement)urlReferences.get(urlReferences.size() - 1))))) != null) {
                urlReferences.add((NavigatablePsiElement)refFromUrl);
            }
        }
        ArrayList<NavigatablePsiElement> arrayList = urlReferences;
        if (arrayList == null) {
            DjangoWebUrlEvaluator.$$$reportNull$$$0(2);
        }
        return arrayList;
    }

    private static boolean isRootConf(@NotNull PsiFile file) {
        Module module;
        if (file == null) {
            DjangoWebUrlEvaluator.$$$reportNull$$$0(3);
        }
        if ((module = ModuleUtilCore.findModuleForPsiElement((PsiElement)file)) == null) {
            return true;
        }
        String rootConfExpr = DjangoSettingsPy.getRootUrlconf((Module)module);
        if (rootConfExpr != null) {
            PsiFile rootUrl = DjangoPsiUtil.findFileInRoots((String)rootConfExpr, (PsiElement)file);
            return rootUrl != null && DjangoWebUrlEvaluator.fileEquals(file, rootUrl);
        }
        return true;
    }

    private static boolean fileEquals(PsiFile file, PsiFile rootUrl) {
        if (file != null && rootUrl != null && file.getVirtualFile() != null && rootUrl.getVirtualFile() != null) {
            return rootUrl.getVirtualFile().getPath().equals(file.getVirtualFile().getPath());
        }
        return false;
    }

    @Nullable
    public String getRelativePath(PsiElement element) {
        if (!DjangoFacet.isPresent((Module)ModuleUtilCore.findModuleForPsiElement((PsiElement)element))) {
            return null;
        }
        SofterReference<String> resultRef = this.myCache.get(element);
        if (resultRef != null && resultRef.get() != null) {
            return (String)resultRef.get();
        }
        List<NavigatablePsiElement> list = this.computeUrlReferences(element);
        if (list.isEmpty()) {
            return null;
        }
        String path = DjangoWebUrlEvaluator.getRelativePath(0, list);
        if (path == null) {
            return null;
        }
        this.myCache.put(element, (SofterReference<String>)new SofterReference((Object)path));
        return path;
    }

    @Nullable
    private static String getRelativePath(int i, @NotNull List<NavigatablePsiElement> list) {
        if (list == null) {
            DjangoWebUrlEvaluator.$$$reportNull$$$0(4);
        }
        if (i < list.size()) {
            String regexp = DjangoWebUrlEvaluator.getWebPath(DjangoWebUrlEvaluator.getUrlPatternRegexp(list.get(i)));
            String result = DjangoWebUrlEvaluator.getRelativePath(i + 1, list);
            if (regexp != null && result != null) {
                return result + regexp;
            }
            return null;
        }
        return "";
    }

    @Nullable
    public String getDjangoUrlPath(PsiElement element, int port) {
        return DjangoWebUrlEvaluator.getDjangoUrl(this.getRelativePath(element), port);
    }

    public void dispose() {
    }

    @Nullable
    private NavigatablePsiElement getReferenceFromUrlsToTemplate(PsiFile file) {
        TypeEvalContext context = TypeEvalContext.userInitiated((Project)file.getProject(), (PsiFile)file);
        Set references = DjangoTemplateManager.getTemplateReferences((PsiFile)file, null, (TypeEvalContext)context);
        for (NavigatablePsiElement expr : references) {
            NavigatablePsiElement el = this.getReferenceFromUrls(expr);
            if (el == null) continue;
            this.myUsedFilesSet.add(expr.getContainingFile().getVirtualFile());
            return el;
        }
        return null;
    }

    @Nullable
    private NavigatablePsiElement getReferenceFromUrls(@NotNull NavigatablePsiElement expr) {
        PyClass clazz;
        String fileName;
        if (expr == null) {
            DjangoWebUrlEvaluator.$$$reportNull$$$0(5);
        }
        if (expr.getContainingFile() != null && "urls.py".equals(fileName = expr.getContainingFile().getName())) {
            PyCallExpression call = (PyCallExpression)PsiTreeUtil.getParentOfType((PsiElement)expr, PyCallExpression.class);
            if (call != null && call.getCallee() != null && !PyCallExpressionExtKt.isCalleeName((PyCallExpression)call, (FQNamesProvider[])new FQNamesProvider[]{DjangoFQNamesProvider.URL_I18N_PATTERNS_FUNCTION, DjangoFQNamesProvider.URL_PATH_OR_RE_PATH_FUNCTION})) {
                return call;
            }
            return expr;
        }
        PyFunction func = (PyFunction)PsiTreeUtil.getParentOfType((PsiElement)expr, PyFunction.class);
        if (func != null) {
            return this.searchForReferenceInAllUrlsFiles((PsiNamedElement)func);
        }
        if (TemplateParametersEvaluator.isTemplateNameInViewClass((NavigatablePsiElement)expr) && (clazz = (PyClass)PsiTreeUtil.getParentOfType((PsiElement)expr, PyClass.class)) != null) {
            return this.searchForReferenceInAllUrlsFiles((PsiNamedElement)clazz);
        }
        return null;
    }

    @Nullable
    private PyExpression searchForReferenceInAllUrlsFiles(PsiNamedElement element) {
        HashSet urlFiles = new HashSet();
        Module module = ModuleUtilCore.findModuleForPsiElement((PsiElement)element);
        if (module == null) {
            return null;
        }
        DjangoModelApi modelApi = (DjangoModelApi)DjangoModelApi.create((Module)module).getSuccessOrNull();
        if (modelApi == null) {
            return null;
        }
        modelApi.collectAllUrlsFromCache(urlFiles);
        Ref expr = Ref.create();
        ReferencesSearch.search((PsiElement)element, (SearchScope)GlobalSearchScope.filesScope((Project)element.getProject(), (Collection)Collections2.transform(urlFiles, input -> input != null ? input.getVirtualFile() : null))).forEach(reference -> {
            PsiElement referenceElement;
            PsiElement el;
            if (reference != null && PsiTreeUtil.getParentOfType((PsiElement)(el = reference.resolve()), PyImportStatementBase.class) == null && (referenceElement = reference.getElement()) instanceof PyExpression) {
                this.myUsedFilesSet.add(referenceElement.getContainingFile().getVirtualFile());
                expr.set((Object)((PyExpression)referenceElement));
                return true;
            }
            return false;
        });
        return (PyExpression)expr.get();
    }

    @Nullable
    private static PyExpression getUrlPatternRegexp(NavigatablePsiElement expr) {
        PyCallExpression urlCall = DjangoPsiUtil.getPathCall((PsiElement)expr);
        if (urlCall != null) {
            return urlCall.getArguments()[0];
        }
        PyTupleExpression tuple = DjangoPsiUtil.getTuple((PsiElement)expr);
        if (tuple != null) {
            return tuple.getElements()[0];
        }
        return null;
    }

    @Nullable
    private static String getWebPath(@Nullable PyExpression expr) {
        String value = PyPsiUtils.getStringValue((PsiElement)expr);
        if (value != null) {
            value = value.replace("$", "").replace("^", "");
            value = StringUtil.trimStart((String)value, (String)"/");
        }
        return value;
    }

    @Nullable
    static String getDjangoUrl(@Nullable String path, int port) {
        if (path == null) {
            return null;
        }
        return "http://localhost:" + port + "/" + path;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[switch (n) {
            default -> 3;
            case 2 -> 2;
        }];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/python/django/lang/template/DjangoWebUrlEvaluator";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "file";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "list";
                break;
            }
            case 5: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/python/django/lang/template/DjangoWebUrlEvaluator";
                break;
            }
            case 2: {
                objectArray = objectArray2;
                objectArray2[1] = "computeUrlReferences";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: {
                objectArray = objectArray;
                objectArray[2] = "getInstance";
                break;
            }
            case 2: {
                break;
            }
            case 3: {
                objectArray = objectArray;
                objectArray[2] = "isRootConf";
                break;
            }
            case 4: {
                objectArray = objectArray;
                objectArray[2] = "getRelativePath";
                break;
            }
            case 5: {
                objectArray = objectArray;
                objectArray[2] = "getReferenceFromUrls";
                break;
            }
        }
        String string = String.format(v0, objectArray);
        throw switch (n) {
            default -> new IllegalArgumentException(string);
            case 2 -> new IllegalStateException(string);
        };
    }
}

