/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.jest;

import com.intellij.lang.javascript.index.JSSymbolUtil;
import com.intellij.lang.javascript.psi.JSLiteralExpression;
import com.intellij.lang.javascript.psi.JSReferenceExpression;
import com.intellij.lang.javascript.psi.resolve.JSModuleReferenceContributor;
import com.intellij.lang.javascript.psi.util.JSUtils;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.PatternCondition;
import com.intellij.patterns.PlatformPatterns;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceContributor;
import com.intellij.psi.PsiReferenceProvider;
import com.intellij.psi.PsiReferenceRegistrar;
import com.intellij.util.ObjectUtils;
import com.intellij.util.ProcessingContext;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class JestReferenceContributor
extends PsiReferenceContributor {
    private static final Set<String> jestMethodNames = Set.of("mock", "createMockFromModule", "unmock", "deepUnmock", "doMock", "dontMock", "setMock", "requireActual", "requireMock");

    public void registerReferenceProviders(@NotNull PsiReferenceRegistrar registrar) {
        if (registrar == null) {
            JestReferenceContributor.$$$reportNull$$$0(0);
        }
        registrar.registerReferenceProvider((ElementPattern)PlatformPatterns.psiElement(JSLiteralExpression.class).with((PatternCondition)new PatternCondition<JSLiteralExpression>("jestMocksWithModuleName"){

            public boolean accepts(@NotNull JSLiteralExpression expression, ProcessingContext context2) {
                if (expression == null) {
                    1.$$$reportNull$$$0(0);
                }
                JSReferenceExpression methodExpression = JSUtils.getMethodNameIfInsideCall(expression.getParent());
                return JestReferenceContributor.isJestWithModuleNameCall(methodExpression);
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "expression", "com/intellij/javascript/jest/JestReferenceContributor$1", "accepts"));
            }
        }), (PsiReferenceProvider)new JestReferenceProvider());
    }

    private static boolean isJestWithModuleNameCall(JSReferenceExpression methodExpression) {
        for (String name : jestMethodNames) {
            if (!JSSymbolUtil.isAccurateReferenceExpressionName(methodExpression, "jest", name)) continue;
            return true;
        }
        return false;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "registrar", "com/intellij/javascript/jest/JestReferenceContributor", "registerReferenceProviders"));
    }

    private static class JestReferenceProvider
    extends PsiReferenceProvider {
        private JestReferenceProvider() {
        }

        public PsiReference @NotNull [] getReferencesByElement(@NotNull PsiElement element2, @NotNull ProcessingContext context2) {
            if (element2 == null) {
                JestReferenceProvider.$$$reportNull$$$0(0);
            }
            if (context2 == null) {
                JestReferenceProvider.$$$reportNull$$$0(1);
            }
            JSLiteralExpression literalExpression = (JSLiteralExpression)ObjectUtils.tryCast((Object)element2, JSLiteralExpression.class);
            PsiReference[] psiReferenceArray = JSModuleReferenceContributor.getReferencesForStringLiteral(literalExpression, this);
            if (psiReferenceArray == null) {
                JestReferenceProvider.$$$reportNull$$$0(2);
            }
            return psiReferenceArray;
        }

        private static /* synthetic */ void $$$reportNull$$$0(int n) {
            Object[] objectArray;
            Object[] objectArray2;
            Object[] objectArray3 = new Object[switch (n) {
                default -> 3;
                case 2 -> 2;
            }];
            switch (n) {
                default: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "element";
                    break;
                }
                case 1: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "context";
                    break;
                }
                case 2: {
                    objectArray2 = objectArray3;
                    objectArray3[0] = "com/intellij/javascript/jest/JestReferenceContributor$JestReferenceProvider";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray2;
                    objectArray2[1] = "com/intellij/javascript/jest/JestReferenceContributor$JestReferenceProvider";
                    break;
                }
                case 2: {
                    objectArray = objectArray2;
                    objectArray2[1] = "getReferencesByElement";
                    break;
                }
            }
            switch (n) {
                default: {
                    objectArray = objectArray;
                    objectArray[2] = "getReferencesByElement";
                    break;
                }
                case 2: {
                    break;
                }
            }
            String string = String.format(v0, objectArray);
            throw switch (n) {
                default -> new IllegalArgumentException(string);
                case 2 -> new IllegalStateException(string);
            };
        }
    }
}

