/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.javascript.testing.vitest.snapshot;

import com.intellij.execution.filters.HyperlinkInfo;
import com.intellij.execution.testframework.Printer;
import com.intellij.execution.testframework.sm.runner.SMTRunnerEventsAdapter;
import com.intellij.execution.testframework.sm.runner.SMTestProxy;
import com.intellij.execution.ui.ConsoleViewContentType;
import com.intellij.javascript.nodejs.execution.NodeTargetRun;
import com.intellij.javascript.testing.runConfiguration.JSTestLocation;
import com.intellij.javascript.testing.vitest.snapshot.VitestUpdateSnapshotHyperlinkInfo;
import com.intellij.lang.javascript.JavaScriptBundle;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.util.PathUtil;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010#\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 \u00112\u00020\u0001:\u0001\u0011B\u0011\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u0010\u0010\u000b\u001a\u00020\f2\u0006\u0010\r\u001a\u00020\u000eH\u0016J\u0010\u0010\u000f\u001a\u00020\f2\u0006\u0010\u0010\u001a\u00020\bH\u0016R\u0010\u0010\u0002\u001a\u0004\u0018\u00010\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\b\u0012\u0004\u0012\u00020\b0\u0007X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0012"}, d2={"Lcom/intellij/javascript/testing/vitest/snapshot/VitestSnapshotEventsListener;", "Lcom/intellij/execution/testframework/sm/runner/SMTRunnerEventsAdapter;", "targetRun", "Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;", "<init>", "(Lcom/intellij/javascript/nodejs/execution/NodeTargetRun;)V", "failedFileProxies", "", "Lcom/intellij/execution/testframework/sm/runner/SMTestProxy;", "allTestsLinkAdded", "", "onTestingStarted", "", "testsRoot", "Lcom/intellij/execution/testframework/sm/runner/SMTestProxy$SMRootTestProxy;", "onTestFailed", "test", "Companion", "intellij.javascript.impl"})
@SourceDebugExtension(value={"SMAP\nVitestSnapshotEventsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VitestSnapshotEventsListener.kt\ncom/intellij/javascript/testing/vitest/snapshot/VitestSnapshotEventsListener\n+ 2 logger.kt\ncom/intellij/openapi/diagnostic/LoggerKt\n*L\n1#1,92:1\n14#2:93\n*S KotlinDebug\n*F\n+ 1 VitestSnapshotEventsListener.kt\ncom/intellij/javascript/testing/vitest/snapshot/VitestSnapshotEventsListener\n*L\n59#1:93\n*E\n"})
public final class VitestSnapshotEventsListener
extends SMTRunnerEventsAdapter {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @Nullable
    private final NodeTargetRun targetRun;
    @NotNull
    private final Set<SMTestProxy> failedFileProxies;
    private boolean allTestsLinkAdded;
    @NotNull
    private static final Logger LOG;
    @NotNull
    private static final String FILE_SCHEME = "file://";
    @NotNull
    private static final String LINK_START = "<link>";
    @NotNull
    private static final String LINK_END = "</link>";
    @NotNull
    private static final List<String> ERROR_PREFIXES;
    @NotNull
    private static final String ERROR_SUFFIX = "` mismatched";

    public VitestSnapshotEventsListener(@Nullable NodeTargetRun targetRun) {
        this.targetRun = targetRun;
        this.failedFileProxies = new HashSet();
    }

    public void onTestingStarted(@NotNull SMTestProxy.SMRootTestProxy testsRoot) {
        Intrinsics.checkNotNullParameter((Object)testsRoot, (String)"testsRoot");
        this.failedFileProxies.clear();
        this.allTestsLinkAdded = false;
    }

    public void onTestFailed(@NotNull SMTestProxy test) {
        Intrinsics.checkNotNullParameter((Object)test, (String)"test");
        if (test.isDefect() && VitestSnapshotEventsListener.Companion.isSnapshotMatchFailed(test)) {
            JSTestLocation jSTestLocation;
            String string = test.getLocationUrl();
            if (string == null) {
                return;
            }
            String testLocationUrl = string;
            try {
                jSTestLocation = JSTestLocation.Companion.fromTestLocationUrl(testLocationUrl, this.targetRun);
            }
            catch (Exception e) {
                LOG.info("Cannot add update snapshot links", (Throwable)e);
                return;
            }
            JSTestLocation testCoordinates = jSTestLocation;
            String testFilePath = testCoordinates.getLocalTestFilePath();
            List<String> testNames = testCoordinates.getTestNames();
            test.insert(arg_0 -> VitestSnapshotEventsListener.onTestFailed$lambda$0(testNames, testFilePath, arg_0), 0);
            SMTestProxy fileProxy = VitestSnapshotEventsListener.Companion.findTestFileProxy(test);
            if (fileProxy != null && this.failedFileProxies.add(fileProxy)) {
                fileProxy.insert(arg_0 -> VitestSnapshotEventsListener.onTestFailed$lambda$1(testFilePath, arg_0), fileProxy instanceof SMTestProxy.SMRootTestProxy ? 1 : 0);
            }
            if (fileProxy != null && fileProxy.getParent() instanceof SMTestProxy.SMRootTestProxy && !this.allTestsLinkAdded && this.failedFileProxies.size() > 1) {
                this.allTestsLinkAdded = true;
                fileProxy.getParent().insert(VitestSnapshotEventsListener::onTestFailed$lambda$2, 1);
            }
        }
    }

    private static final void onTestFailed$lambda$0(List $testNames, String $testFilePath, Printer it) {
        Intrinsics.checkNotNull((Object)it);
        Object[] objectArray = new Object[]{CollectionsKt.lastOrNull((List)$testNames)};
        VitestSnapshotEventsListener.Companion.printLink(it, JavaScriptBundle.message("testing.snapshot.update.single.test.text", objectArray) + "\n", new VitestUpdateSnapshotHyperlinkInfo($testFilePath, $testNames));
    }

    private static final void onTestFailed$lambda$1(String $testFilePath, Printer it) {
        Intrinsics.checkNotNull((Object)it);
        Object[] objectArray = new Object[]{PathUtil.getFileName((String)$testFilePath)};
        VitestSnapshotEventsListener.Companion.printLink(it, JavaScriptBundle.message("testing.snapshot.update.test.file.text", objectArray) + "\n\n", new VitestUpdateSnapshotHyperlinkInfo($testFilePath, null));
    }

    private static final void onTestFailed$lambda$2(Printer it) {
        Intrinsics.checkNotNull((Object)it);
        VitestSnapshotEventsListener.Companion.printLink(it, JavaScriptBundle.message("testing.snapshot.update.all.tests.text", new Object[0]) + "\n\n", new VitestUpdateSnapshotHyperlinkInfo(null, null));
    }

    static {
        boolean $i$f$logger = false;
        Logger logger = Logger.getInstance(VitestSnapshotEventsListener.class);
        Intrinsics.checkNotNullExpressionValue((Object)logger, (String)"getInstance(...)");
        LOG = logger;
        Object[] objectArray = new String[]{"AssertionError: Snapshot `", "Error: Snapshot `"};
        ERROR_PREFIXES = CollectionsKt.listOf((Object[])objectArray);
    }

    @Metadata(mv={2, 2, 0}, k=1, xi=48, d1={"\u0000D\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J \u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0010\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u0013\u001a\u00020\u0014H\u0002J\u0012\u0010\u0015\u001a\u0004\u0018\u00010\u00142\u0006\u0010\u0013\u001a\u00020\u0014H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0016\u001a\b\u0012\u0004\u0012\u00020\u00070\u0017X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0018\u001a\u00020\u0007X\u0082T\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0019"}, d2={"Lcom/intellij/javascript/testing/vitest/snapshot/VitestSnapshotEventsListener$Companion;", "", "<init>", "()V", "LOG", "Lcom/intellij/openapi/diagnostic/Logger;", "FILE_SCHEME", "", "LINK_START", "LINK_END", "printLink", "", "printer", "Lcom/intellij/execution/testframework/Printer;", "message", "linkInfo", "Lcom/intellij/javascript/testing/vitest/snapshot/VitestUpdateSnapshotHyperlinkInfo;", "isSnapshotMatchFailed", "", "test", "Lcom/intellij/execution/testframework/sm/runner/SMTestProxy;", "findTestFileProxy", "ERROR_PREFIXES", "", "ERROR_SUFFIX", "intellij.javascript.impl"})
    @SourceDebugExtension(value={"SMAP\nVitestSnapshotEventsListener.kt\nKotlin\n*S Kotlin\n*F\n+ 1 VitestSnapshotEventsListener.kt\ncom/intellij/javascript/testing/vitest/snapshot/VitestSnapshotEventsListener$Companion\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,92:1\n1761#2,3:93\n*S KotlinDebug\n*F\n+ 1 VitestSnapshotEventsListener.kt\ncom/intellij/javascript/testing/vitest/snapshot/VitestSnapshotEventsListener$Companion\n*L\n78#1:93,3\n*E\n"})
    public static final class Companion {
        private Companion() {
        }

        private final void printLink(Printer printer, String message, VitestUpdateSnapshotHyperlinkInfo linkInfo) {
            int linkStartInd = StringsKt.indexOf$default((CharSequence)message, (String)VitestSnapshotEventsListener.LINK_START, (int)0, (boolean)false, (int)6, null);
            int linkEndInd = StringsKt.indexOf$default((CharSequence)message, (String)VitestSnapshotEventsListener.LINK_END, (int)(linkStartInd + 6), (boolean)false, (int)4, null);
            if (linkStartInd >= 0 && linkEndInd >= 0) {
                if (linkStartInd > 0) {
                    String string = message.substring(0, linkStartInd);
                    Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                    printer.print(string, ConsoleViewContentType.NORMAL_OUTPUT);
                }
                String string = message.substring(linkStartInd + 6, linkEndInd);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                printer.printHyperlink(string, (HyperlinkInfo)linkInfo);
                String string2 = message.substring(linkEndInd + 7);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                printer.print(string2, ConsoleViewContentType.NORMAL_OUTPUT);
            }
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private final boolean isSnapshotMatchFailed(SMTestProxy test) {
            String it;
            String string = test.getErrorMessage();
            if (string == null) {
                return false;
            }
            String message = string;
            if (!StringsKt.endsWith$default((String)message, (String)VitestSnapshotEventsListener.ERROR_SUFFIX, (boolean)false, (int)2, null)) return false;
            Iterable $this$any$iv = ERROR_PREFIXES;
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                return false;
            }
            Iterator iterator = $this$any$iv.iterator();
            do {
                if (!iterator.hasNext()) return false;
                Object element$iv = iterator.next();
                it = (String)element$iv;
                boolean bl = false;
            } while (!StringsKt.startsWith$default((String)message, (String)it, (boolean)false, (int)2, null));
            return true;
        }

        private final SMTestProxy findTestFileProxy(SMTestProxy test) {
            SMTestProxy proxy = test;
            while (true) {
                String string;
                if ((string = proxy.getLocationUrl()) == null) {
                    string = "";
                }
                if (StringsKt.startsWith$default((String)string, (String)VitestSnapshotEventsListener.FILE_SCHEME, (boolean)false, (int)2, null)) break;
                if (proxy.getParent() != null) continue;
                return null;
            }
            return proxy;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

